/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class DerivableContainerSymbol
extends ContainerSymbol
implements IDerivableContainerSymbol {
    private LinkedList _constructors;
    private LinkedList _parentScopes;

    protected DerivableContainerSymbol(ParserSymbolTable table, String name) {
        super(table, name);
    }

    protected DerivableContainerSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    protected DerivableContainerSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        DerivableContainerSymbol copy = (DerivableContainerSymbol)super.clone();
        copy._parentScopes = this._parentScopes != null ? (LinkedList)this._parentScopes.clone() : null;
        copy._constructors = this._constructors != null ? (LinkedList)this._constructors.clone() : null;
        return copy;
    }

    public void addSymbol(ISymbol symbol) throws ParserSymbolTableException {
        super.addSymbol(symbol);
        if (symbol instanceof IParameterizedSymbol) {
            this.addThis((IParameterizedSymbol)symbol);
        }
    }

    public void addParent(ISymbol parent) {
        this.addParent(parent, false, ASTAccessVisibility.PUBLIC, -1, null);
    }

    public void addParent(ISymbol parent, boolean virtual, ASTAccessVisibility visibility, int offset, List references) {
        if (this._parentScopes == null) {
            this._parentScopes = new LinkedList();
        }
        ParentWrapper wrapper = new ParentWrapper(parent, virtual, visibility, offset, references);
        this._parentScopes.add(wrapper);
        AddParentCommand command = new AddParentCommand(this, wrapper);
        this.getSymbolTable().pushCommand(command);
    }

    public List getParents() {
        if (this._parentScopes == null) {
            this._parentScopes = new LinkedList();
        }
        return this._parentScopes;
    }

    public boolean hasParents() {
        return this._parentScopes != null && !this._parentScopes.isEmpty();
    }

    public void addConstructor(IParameterizedSymbol constructor) throws ParserSymbolTableException {
        if (!constructor.isType(TypeInfo.t_constructor)) {
            throw new ParserSymbolTableException(1);
        }
        List constructors = this.getConstructors();
        if (constructors.size() != 0 && !ParserSymbolTable.isValidOverload(constructors, (ISymbol)constructor)) {
            throw new ParserSymbolTableException(3);
        }
        constructors.add(constructor);
        constructor.setContainingSymbol(this);
        this.addThis(constructor);
        AddConstructorCommand command = new AddConstructorCommand(constructor, this);
        this.getSymbolTable().pushCommand(command);
    }

    public void addCopyConstructor() throws ParserSymbolTableException {
        LinkedList<TypeInfo> parameters = new LinkedList<TypeInfo>();
        TypeInfo param = new TypeInfo(TypeInfo.t_type, 0, (ISymbol)this, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, true, false), false);
        parameters.add(param);
        IParameterizedSymbol constructor = this.lookupConstructor(parameters);
        if (constructor == null) {
            constructor = this.getSymbolTable().newParameterizedSymbol(this.getName(), TypeInfo.t_constructor);
            constructor.addParameter(this, new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference, true, false), false);
            this.addConstructor(constructor);
        }
    }

    public IParameterizedSymbol lookupConstructor(List parameters) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData("", TypeInfo.t_constructor, null);
        data.parameters = parameters;
        LinkedList constructors = new LinkedList();
        if (!this.getConstructors().isEmpty()) {
            constructors.addAll(this.getConstructors());
        }
        return ParserSymbolTable.resolveFunction(data, constructors);
    }

    public List getConstructors() {
        if (this._constructors == null) {
            this._constructors = new LinkedList();
        }
        return this._constructors;
    }

    private boolean addThis(IParameterizedSymbol obj) {
        if (this.getSymbolTable().getLanguage() != ParserLanguage.CPP) {
            return false;
        }
        TypeInfo type = obj.getTypeInfo();
        if (!type.isType(TypeInfo.t_function) && !type.isType(TypeInfo.t_constructor) || type.checkBit(128)) {
            return false;
        }
        if (obj.getContainingSymbol().isType(TypeInfo.t_class, TypeInfo.t_union)) {
            ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData("this", TypeInfo.t_any, null);
            ParserSymbolTable.lookupInContained(data, obj);
            if (data.foundItems == null) {
                ISymbol thisObj = this.getSymbolTable().newSymbol("this", TypeInfo.t_type);
                thisObj.setTypeSymbol(obj.getContainingSymbol());
                TypeInfo.PtrOp ptr = new TypeInfo.PtrOp();
                ptr.setType(TypeInfo.PtrOp.t_pointer);
                if (obj.getTypeInfo().hasPtrOperators()) {
                    ptr.setConst(((TypeInfo.PtrOp)obj.getPtrOperators().iterator().next()).isConst());
                    ptr.setVolatile(((TypeInfo.PtrOp)obj.getPtrOperators().iterator().next()).isVolatile());
                }
                thisObj.addPtrOperator(ptr);
                try {
                    obj.addSymbol(thisObj);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    return false;
                }
            }
        }
        return true;
    }

    private ISymbol addFriend(String name) throws ParserSymbolTableException {
        ISymbol friend = this.lookupForFriendship(name);
        if (friend == null) {
            friend = this.getSymbolTable().newSymbol(name);
            friend.getTypeInfo().setIsForwardDeclaration(true);
            IContainerSymbol containing = this.getContainingSymbol();
            while (containing != null && containing.getType() != TypeInfo.t_namespace) {
                containing = containing.getContainingSymbol();
            }
            IContainerSymbol namespace = containing == null ? this.getSymbolTable().getCompilationUnit() : containing;
            namespace.addSymbol(friend);
        }
        return friend;
    }

    private ISymbol lookupForFriendship(String name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_any, this.getTemplateInstance());
        boolean inClass = this.getType() == TypeInfo.t_class;
        IContainerSymbol enclosing = this.getContainingSymbol();
        while (enclosing != null && !(inClass ? enclosing.getType() == TypeInfo.t_class : enclosing.getType() != TypeInfo.t_namespace)) {
            enclosing = enclosing.getContainingSymbol();
        }
        data.stopAt = enclosing;
        ParserSymbolTable.lookup(data, this);
        return ParserSymbolTable.resolveAmbiguities(data);
    }

    private static class AddParentCommand
    extends ParserSymbolTable.Command {
        private IDerivableContainerSymbol _decl;
        private ParentWrapper _wrapper;

        public AddParentCommand(IDerivableContainerSymbol container, ParentWrapper wrapper) {
            this._decl = container;
            this._wrapper = wrapper;
        }

        public void undoIt() {
            List parents = this._decl.getParents();
            parents.remove(this._wrapper);
        }
    }

    private static class AddConstructorCommand
    extends ParserSymbolTable.Command {
        private IParameterizedSymbol _constructor;
        private IDerivableContainerSymbol _context;

        AddConstructorCommand(IParameterizedSymbol newConstr, IDerivableContainerSymbol context) {
            this._constructor = newConstr;
            this._context = context;
        }

        public void undoIt() {
            List constructors = this._context.getConstructors();
            ListIterator iter = constructors.listIterator();
            int size = constructors.size();
            IParameterizedSymbol item = null;
            int i = 0;
            while (i < size) {
                item = (IParameterizedSymbol)iter.next();
                if (item == this._constructor) {
                    iter.remove();
                    break;
                }
                ++i;
            }
        }
    }

    public class ParentWrapper
    implements IDerivableContainerSymbol.IParentSymbol {
        private boolean isVirtual = false;
        protected ISymbol parent = null;
        private final ASTAccessVisibility access;
        private final int offset;
        private final List references;

        public ParentWrapper(ISymbol p, boolean v, ASTAccessVisibility s, int offset, List r) {
            this.parent = p;
            this.isVirtual = v;
            this.access = s;
            this.offset = offset;
            this.references = r;
        }

        public void setParent(ISymbol parent) {
            this.parent = parent;
        }

        public ISymbol getParent() {
            return this.parent;
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        public void setVirtual(boolean virtual) {
            this.isVirtual = virtual;
        }

        public ASTAccessVisibility getVisibility() {
            return this.access;
        }

        public ASTAccessVisibility getAccess() {
            return this.access;
        }

        public int getOffset() {
            return this.offset;
        }

        public List getReferences() {
            return this.references;
        }
    }
}

