/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class AbstractErrorParserBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ErrorParserBlock";
    private static final String LABEL = "ErrorParserBlock.label";
    private static final String DESC = "ErrorParserBlock.desc";
    private static String[] EMPTY = new String[0];
    private Preferences fPrefs;
    protected HashMap mapParsers = new HashMap();
    private CheckedListDialogField fErrorParserList;
    protected boolean listDirty = false;

    public AbstractErrorParserBlock(Preferences prefs) {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
        this.fPrefs = prefs;
    }

    public Image getImage() {
        return null;
    }

    protected ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                String name = (String)AbstractErrorParserBlock.this.mapParsers.get(element.toString());
                return name != null ? name : "";
            }
        };
    }

    protected FieldListenerAdapter getFieldListenerAdapter() {
        return new FieldListenerAdapter();
    }

    protected String[] getErrorParserIDs(Preferences prefs) {
        String parserIDs = prefs.getString("org.eclipse.cdt.core.errorOutputParser");
        String[] empty = new String[]{};
        if (parserIDs != null && parserIDs.length() > 0) {
            StringTokenizer tok = new StringTokenizer(parserIDs, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(empty);
        }
        return empty;
    }

    protected abstract String[] getErrorParserIDs(IProject var1);

    protected abstract void saveErrorParsers(IProject var1, String[] var2) throws CoreException;

    protected void saveErrorParsers(Preferences prefs, String[] parserIDs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < parserIDs.length) {
            buf.append(parserIDs[i]).append(';');
            ++i;
        }
        prefs.setValue("org.eclipse.cdt.core.errorOutputParser", buf.toString());
    }

    protected void initMapParsers() {
        this.mapParsers.clear();
        IExtensionPoint point = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("ErrorParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            int i = 0;
            while (i < exts.length) {
                this.mapParsers.put(exts[i].getUniqueIdentifier(), exts[i].getLabel());
                ++i;
            }
        }
    }

    protected void initializeValues() {
        this.initMapParsers();
        ArrayList<String> list = new ArrayList<String>(this.mapParsers.size());
        Iterator items = this.mapParsers.keySet().iterator();
        while (items.hasNext()) {
            list.add((String)items.next());
        }
        this.fErrorParserList.setElements(list);
        list.clear();
        String[] parserIDs = EMPTY;
        IProject project = this.getContainer().getProject();
        parserIDs = project == null ? this.getErrorParserIDs(this.fPrefs) : this.getErrorParserIDs(project);
        this.fErrorParserList.setCheckedElements(Arrays.asList(parserIDs));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.cdt_error_parsers_page");
        String[] stringArray = new String[5];
        stringArray[0] = "Up";
        stringArray[1] = "Down";
        stringArray[3] = "Select All";
        stringArray[4] = "Unselect All";
        String[] buttonLabels = stringArray;
        this.fErrorParserList = new CheckedListDialogField(null, buttonLabels, this.getLabelProvider());
        this.fErrorParserList.setDialogFieldListener(this.getFieldListenerAdapter());
        this.fErrorParserList.setLabelText("Error Parsers");
        this.fErrorParserList.setUpButtonIndex(0);
        this.fErrorParserList.setDownButtonIndex(1);
        this.fErrorParserList.setCheckAllButtonIndex(3);
        this.fErrorParserList.setUncheckAllButtonIndex(4);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fErrorParserList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fErrorParserList.getListControl(null));
        this.initializeValues();
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.listDirty) {
            IProject project = this.getContainer().getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Setting Error Parsers...", 1);
            List list = this.fErrorParserList.getCheckedElements();
            String[] parserIDs = list.toArray(EMPTY);
            if (project == null) {
                this.saveErrorParsers(this.fPrefs, parserIDs);
            } else {
                this.saveErrorParsers(project, parserIDs);
            }
            monitor.worked(1);
            monitor.done();
        }
    }

    public void performDefaults() {
        this.initializeValues();
    }

    class FieldListenerAdapter
    implements IDialogFieldListener {
        FieldListenerAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            AbstractErrorParserBlock.this.listDirty = true;
        }
    }
}

