/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.OptionReference;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolReference
implements ITool {
    private ITool parent;
    private IConfiguration owner;
    private List optionReferences;
    private Map optionRefMap;

    public ToolReference(Configuration owner, ITool parent) {
        this.owner = owner;
        this.parent = parent;
        owner.addToolReference(this);
    }

    public void addOptionReference(OptionReference optionRef) {
        this.getLocalOptionRefs().add(optionRef);
    }

    public ToolReference(Configuration owner, IConfigurationElement element) {
        this.owner = owner;
        this.parent = ((Target)owner.getTarget()).getTool(element.getAttribute("id"));
        owner.addToolReference(this);
        IConfigurationElement[] toolElements = element.getChildren();
        int m = 0;
        while (m < toolElements.length) {
            IConfigurationElement toolElement = toolElements[m];
            if (toolElement.getName().equals("optionReference")) {
                new OptionReference(this, toolElement);
            }
            ++m;
        }
    }

    public ToolReference(Configuration owner, Element element) {
        this.owner = owner;
        Target parentTarget = (Target)owner.getTarget();
        this.parent = ((Target)parentTarget.getParent()).getTool(element.getAttribute("id"));
        owner.addToolReference(this);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("optionReference")) {
                new OptionReference(this, (Element)configElement);
            }
            ++i;
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.parent.getId());
        ListIterator iter = this.getLocalOptionRefs().listIterator();
        while (iter.hasNext()) {
            OptionReference optionRef = (OptionReference)iter.next();
            Element optionRefElement = doc.createElement("optionReference");
            element.appendChild(optionRefElement);
            optionRef.serialize(doc, optionRefElement);
        }
    }

    public IConfiguration getConfiguration() {
        return this.owner;
    }

    public ITool getTool() {
        return this.parent;
    }

    public String getToolCommand() {
        return this.parent.getToolCommand();
    }

    public String getToolFlags() throws BuildException {
        StringBuffer buf = new StringBuffer();
        IOption[] opts = this.getOptions();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            switch (option.getValueType()) {
                case 0: {
                    if (!option.getBooleanValue()) break;
                    buf.append(String.valueOf(option.getCommand()) + " ");
                    break;
                }
                case 1: {
                    String string = option.getEnumCommand(option.getSelectedEnum());
                    if (string.length() <= 0) break;
                    buf.append(String.valueOf(string) + " ");
                    break;
                }
                case 2: {
                    String val = option.getStringValue();
                    if (val.length() <= 0) break;
                    buf.append(String.valueOf(val) + " ");
                    break;
                }
                case 3: {
                    String cmd = option.getCommand();
                    String[] list = option.getStringListValue();
                    int j = 0;
                    while (j < list.length) {
                        String temp = list[j];
                        buf.append(String.valueOf(cmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
                case 4: {
                    String incCmd = option.getCommand();
                    String[] paths = option.getIncludePaths();
                    int j = 0;
                    while (j < paths.length) {
                        String temp = paths[j];
                        buf.append(String.valueOf(incCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
                case 5: {
                    String defCmd = option.getCommand();
                    String[] symbols = option.getDefinedSymbols();
                    int j = 0;
                    while (j < symbols.length) {
                        String temp = symbols[j];
                        buf.append(String.valueOf(defCmd) + temp + " ");
                        ++j;
                    }
                    break;
                }
            }
            ++index;
        }
        return buf.toString().trim();
    }

    public IOption createOption() {
        return null;
    }

    public IOption[] getOptions() {
        IOption[] options = this.parent.getOptions();
        int i = 0;
        while (i < options.length) {
            OptionReference ref = this.getOptionReference(options[i]);
            if (ref != null) {
                options[i] = ref;
            }
            ++i;
        }
        return options;
    }

    public String getOutputFlag() {
        return this.parent.getOutputFlag();
    }

    public String getOutputPrefix() {
        return this.parent.getOutputPrefix();
    }

    public ITarget getTarget() {
        return this.owner.getTarget();
    }

    public IOptionCategory getTopOptionCategory() {
        return this.parent.getTopOptionCategory();
    }

    public boolean isHeaderFile(String ext) {
        return this.parent.isHeaderFile(ext);
    }

    public boolean producesFileType(String outputExtension) {
        return this.parent.producesFileType(outputExtension);
    }

    protected List getAllOptionRefs() {
        return ((Configuration)this.owner).getOptionReferences(this.parent);
    }

    public String getId() {
        return this.parent.getId();
    }

    public String getName() {
        return this.parent.getName();
    }

    public boolean references(ITool target) {
        if (this.equals(target)) {
            return true;
        }
        if (this.parent instanceof ToolReference) {
            return ((ToolReference)this.parent).references(target);
        }
        if (target instanceof ToolReference) {
            return this.parent.equals(((ToolReference)target).parent);
        }
        return this.parent.equals(target);
    }

    private OptionReference getOptionReference(IOption option) {
        ListIterator iter = this.getAllOptionRefs().listIterator();
        while (iter.hasNext()) {
            OptionReference optionRef = (OptionReference)iter.next();
            if (!optionRef.references(option)) continue;
            return optionRef;
        }
        return null;
    }

    protected List getLocalOptionRefs() {
        if (this.optionReferences == null) {
            this.optionReferences = new ArrayList();
            this.optionReferences.clear();
        }
        return this.optionReferences;
    }

    public OptionReference createOptionReference(IOption option) {
        OptionReference ref = this.getOptionReference(option);
        if (ref == null) {
            ref = new OptionReference(this, option);
        }
        return ref;
    }

    public boolean buildsFileType(String extension) {
        return this.parent.buildsFileType(extension);
    }

    public int getNatureFilter() {
        return this.parent.getNatureFilter();
    }

    public IOption getOption(String id) {
        return null;
    }

    public String getOutputExtension(String inputExtension) {
        return this.parent.getOutputExtension(inputExtension);
    }
}

