/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBDebugger
implements ICDebugger {
    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CDIException {
        try {
            List p;
            ICDISharedLibraryManager manager = session.getSharedLibraryManager();
            if (manager instanceof SharedLibraryManager) {
                SharedLibraryManager mgr = (SharedLibraryManager)manager;
                boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, false);
                boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
                try {
                    mgr.setAutoLoadSymbols(autolib);
                    mgr.setStopOnSolibEvents(stopOnSolibEvents);
                    if (autolib && !stopOnSolibEvents) {
                        mgr.setDeferredBreakpoint(true);
                        mgr.setStopOnSolibEvents(true);
                    }
                }
                catch (CDIException cDIException) {}
            }
            if ((p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST)).size() > 0) {
                String[] oldPaths = manager.getSharedLibraryPaths();
                String[] paths = new String[oldPaths.length + p.size()];
                System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                manager.setSharedLibraryPaths(paths);
            }
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing shared library options: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            try {
                String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File cwd = exe.getProject().getLocation().toFile();
                String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                session2 = (Session)MIPlugin.getDefault().createCSession(gdb, exe.getLocation().toFile(), cwd, gdbinit);
                this.initializeLibraries(config, session2);
                session = session2;
                Object var8_12 = null;
                if (!failed) return session;
                if (session2 == null) return session;
            }
            catch (IOException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
            catch (MIException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
            catch (CoreException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!failed) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            try {
                String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File cwd = exe.getProject().getLocation().toFile();
                String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                session2 = (Session)MIPlugin.getDefault().createCSession(gdb, exe.getLocation().toFile(), pid, null, cwd, gdbinit);
                this.initializeLibraries(config, session2);
                session = session2;
                Object var9_13 = null;
                if (!failed) return session;
                if (session2 == null) return session;
            }
            catch (IOException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
            catch (MIException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
            catch (CoreException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!failed) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            try {
                String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
                File cwd = exe.getProject().getLocation().toFile();
                String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
                session2 = (Session)MIPlugin.getDefault().createCSession(gdb, exe.getLocation().toFile(), corefile.toFile(), cwd, gdbinit);
                this.initializeLibraries(config, session2);
                session = session2;
                Object var9_13 = null;
                if (!failed) return session;
                if (session2 == null) return session;
            }
            catch (IOException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
            catch (MIException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
            catch (CoreException e) {
                failed = true;
                throw new CDIException("Error creating session: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!failed) throw throwable;
            if (session2 == null) throw throwable;
            try {
                session2.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session2.terminate();
        return session;
    }
}

