/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BinaryFunction;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.BinaryModule;
import org.eclipse.cdt.internal.core.model.BinaryVariable;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Binary
extends Openable
implements IBinary {
    private int fBinType;
    private String hasDebug;
    private String cpu;
    private String[] needed;
    private long longData;
    private long longText;
    private long longBSS;
    private String endian;
    private String soname;
    private long fLastModification;
    IBinaryParser.IBinaryFile binaryFile;

    public Binary(ICElement parent, IFile file, IBinaryParser.IBinaryFile bin) {
        super(parent, (IResource)file, 14);
        this.binaryFile = bin;
    }

    public Binary(ICElement parent, IPath path, IBinaryParser.IBinaryFile bin) {
        super(parent, path, 14);
        this.binaryFile = bin;
    }

    public boolean isSharedLib() {
        return this.getType() == 4;
    }

    public boolean isExecutable() {
        return this.getType() == 2;
    }

    public boolean isObject() {
        return this.getType() == 1;
    }

    public boolean isCore() {
        return this.getType() == 16;
    }

    public boolean hasDebug() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.hasDebug == null || this.hasChanged())) {
            this.hasDebug = new Boolean(((IBinaryParser.IBinaryObject)this.getBinaryFile()).hasDebug()).toString();
        }
        return Boolean.valueOf(this.hasDebug);
    }

    public String getCPU() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.cpu == null || this.hasChanged())) {
            this.cpu = ((IBinaryParser.IBinaryObject)this.getBinaryFile()).getCPU();
        }
        return this.cpu == null ? "" : this.cpu;
    }

    public String[] getNeededSharedLibs() {
        if ((this.isExecutable() || this.isSharedLib()) && (this.needed == null || this.hasChanged())) {
            this.needed = ((IBinaryParser.IBinaryExecutable)this.getBinaryFile()).getNeededSharedLibs();
        }
        return this.needed == null ? new String[]{} : this.needed;
    }

    public long getText() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longText == -1L || this.hasChanged())) {
            this.longText = ((IBinaryParser.IBinaryObject)this.getBinaryFile()).getText();
        }
        return this.longText;
    }

    public long getData() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longData == -1L || this.hasChanged())) {
            this.longData = ((IBinaryParser.IBinaryObject)this.getBinaryFile()).getData();
        }
        return this.longData;
    }

    public long getBSS() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longBSS == -1L || this.hasChanged())) {
            this.longBSS = ((IBinaryParser.IBinaryObject)this.getBinaryFile()).getBSS();
        }
        return this.longBSS;
    }

    public String getSoname() {
        if (this.isSharedLib() && (this.soname == null || this.hasChanged())) {
            this.soname = ((IBinaryParser.IBinaryShared)this.getBinaryFile()).getSoName();
        }
        return this.soname == null ? "" : this.soname;
    }

    public boolean isLittleEndian() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.endian == null || this.hasChanged())) {
            this.endian = new Boolean(((IBinaryParser.IBinaryObject)this.getBinaryFile()).isLittleEndian()).toString();
        }
        return Boolean.valueOf(this.endian);
    }

    protected IBinaryParser.IBinaryFile getBinaryFile() {
        return this.binaryFile;
    }

    protected int getType() {
        if (this.getBinaryFile() != null && (this.fBinType == 0 || this.hasChanged())) {
            this.fBinType = this.getBinaryFile().getType();
        }
        return this.fBinType;
    }

    protected boolean hasChanged() {
        long modification = this.getModificationStamp();
        boolean changed = modification != this.fLastModification;
        this.fLastModification = modification;
        if (changed) {
            this.hasDebug = null;
            this.needed = null;
            this.cpu = null;
            this.endian = null;
            this.longBSS = -1L;
            this.longData = -1L;
            this.longText = -1L;
            this.soname = null;
        }
        return changed;
    }

    protected long getModificationStamp() {
        IResource res = this.getResource();
        if (res != null) {
            return res.getModificationStamp();
        }
        return 0L;
    }

    public boolean isReadOnly() {
        return true;
    }

    public CElementInfo createElementInfo() {
        return new BinaryInfo(this);
    }

    protected boolean generateInfos(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().putInfo(this, info);
        return this.computeChildren(info, underlyingResource);
    }

    boolean computeChildren(OpenableInfo info, IResource res) {
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            HashMap hash = new HashMap();
            IBinaryParser.ISymbol[] symbols = ((IBinaryParser.IBinaryObject)this.getBinaryFile()).getSymbols();
            int i = 0;
            while (i < symbols.length) {
                switch (symbols[i].getType()) {
                    case 1: {
                        this.addFunction(info, symbols[i], hash);
                        break;
                    }
                    case 2: {
                        this.addVariable(info, symbols[i], hash);
                    }
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private void addFunction(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) {
        IPath filename = symbol.getFilename();
        BinaryFunction function = null;
        if (filename != null) {
            BinaryModule module = null;
            if (hash.containsKey(filename)) {
                module = (BinaryModule)hash.get(filename);
            } else {
                module = new BinaryModule(this, filename);
                hash.put(filename, module);
                info.addChild(module);
            }
            function = new BinaryFunction((ICElement)module, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(function);
        } else {
            function = new BinaryFunction((ICElement)this, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(function);
        }
    }

    private void addVariable(OpenableInfo info, IBinaryParser.ISymbol symbol, Map hash) {
        IPath filename = symbol.getFilename();
        BinaryVariable variable = null;
        if (filename != null) {
            BinaryModule module = null;
            if (hash.containsKey(filename)) {
                module = (BinaryModule)hash.get(filename);
            } else {
                module = new BinaryModule(this, filename);
                hash.put(filename, module);
                info.addChild(module);
            }
            variable = new BinaryVariable((ICElement)module, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(variable);
        } else {
            variable = new BinaryVariable((ICElement)this, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(variable);
        }
    }
}

