/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class BinaryRunner {
    IProject project;
    Thread runner;

    public BinaryRunner(IProject prj) {
        this.project = prj;
    }

    public void start() {
        this.runner = new Thread(new Runnable(){

            public void run() {
                ICProject cproject = CModelManager.getDefault().create(BinaryRunner.this.project);
                BinaryContainer cbin = (BinaryContainer)cproject.getBinaryContainer();
                ArchiveContainer clib = (ArchiveContainer)cproject.getArchiveContainer();
                clib.removeChildren();
                cbin.removeChildren();
                try {
                    cproject.getProject().accept((IResourceVisitor)new Visitor(BinaryRunner.this));
                }
                catch (CoreException coreException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!Thread.currentThread().isInterrupted()) {
                    BinaryRunner.this.fireEvents(cproject, cbin);
                    BinaryRunner.this.fireEvents(cproject, clib);
                }
                BinaryRunner binaryRunner = BinaryRunner.this;
                synchronized (binaryRunner) {
                    BinaryRunner.this.notifyAll();
                    BinaryRunner.this.runner = null;
                }
            }
        }, "Binary Search Thread");
        this.runner.start();
    }

    public synchronized void waitIfRunning() {
        while (this.runner != null && this.runner.isAlive()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        if (this.runner != null && this.runner.isAlive()) {
            this.runner.interrupt();
        }
    }

    void fireEvents(ICProject cproject, Parent container) {
        ICElement[] children = container.getChildren();
        if (children.length > 0) {
            CModelManager factory = CModelManager.getDefault();
            ICModel root = factory.getCModel();
            CElementDelta cdelta = new CElementDelta(root);
            cdelta.added(cproject);
            cdelta.added(container);
            int i = 0;
            while (i < children.length) {
                cdelta.added(children[i]);
                ++i;
            }
            factory.registerCModelDelta(cdelta);
            factory.fire();
        }
    }

    void addChildIfBinary(IFile file) {
        IBinaryParser.IBinaryFile bin;
        CModelManager factory = CModelManager.getDefault();
        if (!factory.isTranslationUnit(file) && (bin = factory.createBinaryFile(file)) != null) {
            IContainer res = file.getParent();
            ICElement parent = factory.create((IResource)res);
            factory.create(parent, file, bin);
        }
    }

    class Visitor
    implements IResourceVisitor {
        BinaryRunner runner;

        public Visitor(BinaryRunner r) {
            this.runner = r;
        }

        public boolean visit(IResource res) throws CoreException {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (res instanceof IFile) {
                this.runner.addChildIfBinary((IFile)res);
                return false;
            }
            return true;
        }
    }
}

