/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.FunctionInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.Util;

public class FunctionDeclaration
extends SourceManipulation
implements IFunctionDeclaration {
    protected static final String[] fgEmptyList = new String[0];
    protected String[] fParameterTypes = fgEmptyList;
    protected String returnType;

    public FunctionDeclaration(ICElement parent, String name) {
        super(parent, name, 70);
    }

    public FunctionDeclaration(ICElement parent, String name, int type) {
        super(parent, name, type);
    }

    public String getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        return "";
    }

    public void setReturnType(String type) {
        this.returnType = type;
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.fParameterTypes = parameterTypes;
    }

    public String getSignature() {
        StringBuffer sig = new StringBuffer(this.getElementName());
        sig.append(this.getParameterClause());
        if (this.isConst()) {
            sig.append(" const");
        }
        if (this.isVolatile()) {
            sig.append(" volatile");
        }
        return sig.toString();
    }

    public String getParameterClause() {
        StringBuffer sig = new StringBuffer();
        if (this.getNumberOfParameters() > 0) {
            sig.append("(");
            String[] paramTypes = this.getParameterTypes();
            int i = 0;
            sig.append(paramTypes[i++]);
            while (i < paramTypes.length) {
                sig.append(", ");
                sig.append(paramTypes[i++]);
            }
            sig.append(")");
        } else {
            sig.append("()");
        }
        return sig.toString();
    }

    public String getParameterInitializer(int pos) {
        return "";
    }

    public String[] getExceptions() {
        return new String[0];
    }

    protected CElementInfo createElementInfo() {
        return new FunctionInfo(this);
    }

    protected FunctionInfo getFunctionInfo() {
        return (FunctionInfo)this.getElementInfo();
    }

    public boolean equals(Object other) {
        return super.equals(other) && Util.equalArraysOrNull(this.fParameterTypes, ((FunctionDeclaration)other).fParameterTypes) && this.getReturnType().equals(((FunctionDeclaration)other).getReturnType());
    }

    public boolean isConst() {
        return this.getFunctionInfo().isConst();
    }

    public void setConst(boolean isConst) {
        this.getFunctionInfo().setConst(isConst);
    }

    public boolean isStatic() {
        return this.getFunctionInfo().isStatic();
    }

    public boolean isVolatile() {
        return this.getFunctionInfo().isVolatile();
    }

    public void setStatic(boolean isStatic) {
        this.getFunctionInfo().setStatic(isStatic);
    }

    public void setVolatile(boolean isVolatile) {
        this.getFunctionInfo().setVolatile(isVolatile);
    }
}

