/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.util.LinkedList;
import org.eclipse.cdt.core.parser.DefaultProblemHandler;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.indexing.SourceIndexer;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    IDocument document;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;
    private IASTInclusion currentInclude = null;
    private LinkedList includeStack = new LinkedList();

    public SourceIndexerRequestor(SourceIndexer indexer, IDocument document) {
        this.indexer = indexer;
        this.document = document;
    }

    public boolean acceptProblem(IProblem problem) {
        return DefaultProblemHandler.ruleOnProblem((IProblem)problem, (ParserMode)ParserMode.COMPLETE_PARSE);
    }

    public void acceptMacro(IASTMacro macro) {
        this.indexer.addMacro(macro);
    }

    public void acceptVariable(IASTVariable variable) {
        this.indexer.addVariable(variable);
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        this.indexer.addFunctionDeclaration(function);
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition asmDefinition) {
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.indexer.addTypedefDeclaration(typedef);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.indexer.addEnumerationSpecifier(enumeration);
    }

    public void enterFunctionBody(IASTFunction function) {
        this.indexer.addFunctionDeclaration(function);
    }

    public void exitFunctionBody(IASTFunction function) {
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
    }

    public void enterInclusion(IASTInclusion inclusion) {
        IASTInclusion parent = this.peekInclude();
        this.indexer.addInclude(inclusion, parent);
        this.pushInclude(inclusion);
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.indexer.addNamespaceDefinition(namespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        this.indexer.addClassSpecifier(classSpecification);
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        this.indexer.addMethodDeclaration(method);
    }

    public void enterMethodBody(IASTMethod method) {
        this.indexer.addMethodDeclaration(method);
    }

    public void exitMethodBody(IASTMethod method) {
    }

    public void acceptField(IASTField field) {
        this.indexer.addFieldDeclaration(field);
    }

    public void acceptClassReference(IASTClassReference reference) {
        if (reference.getReferencedElement() instanceof IASTClassSpecifier) {
            this.indexer.addClassReference((IASTTypeSpecifier)((IASTClassSpecifier)reference.getReferencedElement()));
        } else if (reference.getReferencedElement() instanceof IASTElaboratedTypeSpecifier) {
            this.indexer.addClassReference((IASTTypeSpecifier)reference.getReferencedElement());
        }
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
    }

    public void exitInclusion(IASTInclusion inclusion) {
        this.popInclude();
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
    }

    public void acceptTypedefReference(IASTTypedefReference reference) {
        if (reference.getReferencedElement() instanceof IASTTypedefDeclaration) {
            this.indexer.addTypedefReference((IASTTypedefDeclaration)reference.getReferencedElement());
        }
    }

    public void acceptNamespaceReference(IASTNamespaceReference reference) {
        if (reference.getReferencedElement() instanceof IASTNamespaceDefinition) {
            this.indexer.addNamespaceReference((IASTNamespaceDefinition)reference.getReferencedElement());
        }
    }

    public void acceptEnumerationReference(IASTEnumerationReference reference) {
        if (reference.getReferencedElement() instanceof IASTEnumerationSpecifier) {
            this.indexer.addEnumerationReference((IASTEnumerationSpecifier)reference.getReferencedElement());
        }
    }

    public void acceptVariableReference(IASTVariableReference reference) {
        if (reference.getReferencedElement() instanceof IASTVariable) {
            this.indexer.addVariableReference((IASTVariable)reference.getReferencedElement());
        }
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
        if (reference.getReferencedElement() instanceof IASTFunction) {
            this.indexer.addFunctionReference((IASTFunction)reference.getReferencedElement());
        }
    }

    public void acceptFieldReference(IASTFieldReference reference) {
        if (reference.getReferencedElement() instanceof IASTField) {
            this.indexer.addFieldReference((IASTField)reference.getReferencedElement());
        }
    }

    public void acceptMethodReference(IASTMethodReference reference) {
        if (reference.getReferencedElement() instanceof IASTMethod) {
            this.indexer.addMethodReference((IASTMethod)reference.getReferencedElement());
        }
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        this.indexer.addElaboratedForwardDeclaration(elaboratedType);
    }

    public void enterCodeBlock(IASTCodeScope scope) {
    }

    public void exitCodeBlock(IASTCodeScope scope) {
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference reference) {
        if (reference.getReferencedElement() instanceof IASTEnumerator) {
            this.indexer.addEnumeratorReference((IASTEnumerator)reference.getReferencedElement());
        }
    }

    public void acceptParameterReference(IASTParameterReference reference) {
        if (reference.getReferencedElement() instanceof IASTParameterDeclaration) {
            this.indexer.addParameterReference((IASTParameterDeclaration)reference.getReferencedElement());
        }
    }

    private void pushInclude(IASTInclusion inclusion) {
        this.includeStack.addFirst(this.currentInclude);
        this.currentInclude = inclusion;
    }

    private IASTInclusion popInclude() {
        IASTInclusion oldInclude = this.currentInclude;
        this.currentInclude = this.includeStack.size() > 0 ? (IASTInclusion)this.includeStack.removeFirst() : null;
        return oldInclude;
    }

    private IASTInclusion peekInclude() {
        return this.currentInclude;
    }
}

