/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class GCCErrorParser
implements IErrorParser {
    public boolean processLine(String line, ErrorParserManager eoParser) {
        block47: {
            int firstColon;
            block46: {
                firstColon = line.indexOf(58);
                if (firstColon == 1) {
                    try {
                        String os = System.getProperty("os.name");
                        if (os == null || !os.startsWith("Win")) break block46;
                        try {
                            if (Character.isLetter(line.charAt(0))) {
                                firstColon = line.indexOf(58, 2);
                            }
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    }
                    catch (SecurityException securityException) {}
                }
            }
            if (firstColon != -1) {
                try {
                    int secondColon = -1;
                    int num = -1;
                    while ((secondColon = line.indexOf(58, firstColon + 1)) != -1) {
                        String lineNumber = line.substring(firstColon + 1, secondColon);
                        try {
                            num = Integer.parseInt(lineNumber);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (num != -1) break;
                        firstColon = secondColon;
                    }
                    if (secondColon != -1) {
                        IFile file;
                        int p;
                        int col = -1;
                        String fileName = line.substring(0, firstColon);
                        String varName = null;
                        String desc = line.substring(secondColon + 1).trim();
                        int severity = 2;
                        int thirdColon = line.indexOf(58, secondColon + 1);
                        if (thirdColon != -1) {
                            String columnNumber = line.substring(secondColon + 1, thirdColon);
                            try {
                                col = Integer.parseInt(columnNumber);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (col != -1) {
                            desc = line.substring(thirdColon + 1).trim();
                        }
                        if (desc.startsWith("(Each undeclared")) {
                            return false;
                        }
                        String previous = eoParser.getPreviousLine();
                        if (desc.endsWith(")") && previous.indexOf("(Each undeclared") >= 0) {
                            return false;
                        }
                        int s = desc.indexOf("' undeclared");
                        if (s != -1) {
                            p = desc.indexOf("`");
                            if (p != -1) {
                                varName = desc.substring(p + 1, s);
                            }
                        } else {
                            s = desc.indexOf("' defined but not used");
                            if (s != -1) {
                                p = desc.indexOf("`");
                                if (p != -1) {
                                    varName = desc.substring(p + 1, s);
                                }
                            } else {
                                s = desc.indexOf("conflicting types for `");
                                if (s != -1) {
                                    p = desc.indexOf("'", s);
                                    if (p != -1) {
                                        varName = desc.substring(desc.indexOf("`") + 1, p);
                                    }
                                } else {
                                    s = desc.indexOf("previous declaration of `");
                                    if (s != -1) {
                                        p = desc.indexOf("'", s);
                                        if (p != -1) {
                                            varName = desc.substring(desc.indexOf("`") + 1, p);
                                        }
                                    } else {
                                        s = desc.indexOf("parse error before ");
                                        if (s != -1 && (p = desc.indexOf("'", s)) != -1) {
                                            varName = desc.substring(desc.indexOf("`") + 1, p);
                                        }
                                    }
                                }
                            }
                        }
                        if (eoParser.getScratchBuffer().startsWith("In file included from ")) {
                            if (line.startsWith("from ")) {
                                eoParser.appendToScratchBuffer(line);
                                return false;
                            }
                            String buffer = eoParser.getScratchBuffer();
                            eoParser.clearScratchBuffer();
                            int from = -1;
                            String inclusionError = String.valueOf(fileName) + ":" + num;
                            while ((from = buffer.indexOf("from ")) != -1) {
                                String buf;
                                int coma = buffer.indexOf(44, from);
                                if (coma != -1) {
                                    buf = String.valueOf(buffer.substring(from + 5, coma)) + ':';
                                    buffer = buffer.substring(coma);
                                } else {
                                    buf = buffer.substring(from + 5);
                                    buffer = "";
                                }
                                String t = buf;
                                buf = String.valueOf(buf) + " in inclusion " + inclusionError;
                                inclusionError = t;
                                this.processLine(buf, eoParser);
                            }
                        }
                        if ((file = eoParser.findFilePath(fileName)) == null && (file = eoParser.findFileName(fileName)) != null && eoParser.isConflictingName(fileName)) {
                            desc = "*" + desc;
                            file = null;
                        }
                        if (desc.startsWith("warning") || desc.startsWith("Warning")) {
                            severity = 1;
                            String d = desc.substring("warning".length()).trim();
                            if (d.startsWith(":")) {
                                d = d.substring(1).trim();
                            }
                            if (d.length() != 0) {
                                desc = d;
                            }
                        }
                        if (file == null) {
                            desc = String.valueOf(desc) + "[" + fileName + "]";
                        }
                        eoParser.generateMarker((IResource)file, num, desc, severity, varName);
                        break block47;
                    }
                    if (line.startsWith("In file included from ")) {
                        eoParser.appendToScratchBuffer(line);
                    } else if (line.startsWith("from ")) {
                        eoParser.appendToScratchBuffer(line);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return false;
    }
}

