/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.IToolsProvider;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.cdt.utils.elf.parser.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.Symbol;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BinaryObject
extends BinaryFile
implements IBinaryParser.IBinaryObject {
    protected String soname;
    protected String[] needed;
    protected int type = 1;
    private ElfHelper.Sizes sizes;
    private Elf.Attribute attribute;
    private IBinaryParser.ISymbol[] symbols;
    private IBinaryParser.ISymbol[] NO_SYMBOLS = new IBinaryParser.ISymbol[0];

    public BinaryObject(IPath path) throws IOException {
        super(path);
    }

    public BinaryObject(IPath path, ElfHelper helper, IToolsProvider provider) throws IOException {
        super(path);
        this.setToolsProvider(provider);
        this.loadInformation(helper);
        helper.dispose();
        this.hasChanged();
    }

    public IBinaryParser.ISymbol getSymbol(long addr) {
        Object[] syms = this.getSymbols();
        int insertion = Arrays.binarySearch(syms, new Long(addr));
        if (insertion > 0) {
            return syms[insertion];
        }
        if (insertion == -1) {
            return null;
        }
        insertion = -insertion - 1;
        return syms[insertion - 1];
    }

    public long getBSS() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.bss;
        }
        return 0L;
    }

    public String getCPU() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.getCPU();
        }
        return "";
    }

    public long getData() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.data;
        }
        return 0L;
    }

    public long getText() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.text;
        }
        return 0L;
    }

    public boolean hasDebug() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.hasDebug();
        }
        return false;
    }

    public boolean isLittleEndian() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.isLittleEndian();
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
            if (this.symbols == null) {
                this.symbols = this.NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    public String getName() {
        return this.getPath().lastSegment().toString();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * Exception decompiling
     */
    protected Elf.Attribute getAttribute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 43->46)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected ElfHelper.Sizes getSizes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 43->46)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ElfHelper getElfHelper() throws IOException {
        return new ElfHelper(this.getPath().toOSString());
    }

    /*
     * Exception decompiling
     */
    protected void loadInformation() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 32->36)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadInformation(ElfHelper helper) throws IOException {
        this.loadAttributes(helper);
        this.loadSymbols(helper);
    }

    private void loadAttributes(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
    }

    private void loadSymbols(ElfHelper helper) throws IOException {
        ArrayList list = new ArrayList();
        helper.getElf().setCppFilter(false);
        Addr2line addr2line = this.getAddr2Line();
        CPPFilt cppfilt = this.getCPPFilt();
        this.addSymbols(helper.getExternalFunctions(), 1, addr2line, cppfilt, list);
        this.addSymbols(helper.getLocalFunctions(), 1, addr2line, cppfilt, list);
        this.addSymbols(helper.getExternalObjects(), 2, addr2line, cppfilt, list);
        this.addSymbols(helper.getLocalObjects(), 2, addr2line, cppfilt, list);
        list.trimToSize();
        if (addr2line != null) {
            addr2line.dispose();
        }
        if (cppfilt != null) {
            cppfilt.dispose();
        }
        this.symbols = list.toArray(this.NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void addSymbols(Elf.Symbol[] array, int type, Addr2line addr2line, CPPFilt cppfilt, List list) {
        int i = 0;
        while (i < array.length) {
            Symbol sym = new Symbol(this);
            sym.type = type;
            sym.name = array[i].toString();
            if (cppfilt != null) {
                try {
                    sym.name = cppfilt.getFunction(sym.name);
                }
                catch (IOException iOException) {}
            }
            sym.addr = array[i].st_value;
            sym.filename = null;
            sym.endLine = sym.startLine = 0;
            if (addr2line != null) {
                try {
                    String filename = addr2line.getFileName(sym.addr);
                    sym.filename = filename != null && !filename.equals("??") ? new Path(filename) : null;
                    sym.startLine = addr2line.getLineNumber(sym.addr);
                    sym.endLine = addr2line.getLineNumber(sym.addr + array[i].st_size - 1L);
                }
                catch (IOException iOException) {}
            }
            list.add(sym);
            ++i;
        }
    }
}

