/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.BinaryArchive;
import org.eclipse.cdt.utils.elf.parser.BinaryExecutable;
import org.eclipse.cdt.utils.elf.parser.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.BinaryObject;
import org.eclipse.cdt.utils.elf.parser.BinaryShared;
import org.eclipse.core.runtime.IPath;

public class ElfParser
extends AbstractCExtension
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        if (path == null) {
            throw new IOException("path is null");
        }
        BinaryFile binary = null;
        try {
            Elf.Attribute attribute = Elf.getAttributes(path.toOSString());
            if (attribute != null) {
                switch (attribute.getType()) {
                    case 1: {
                        binary = new BinaryExecutable(path);
                        break;
                    }
                    case 2: {
                        binary = new BinaryShared(path);
                        break;
                    }
                    case 3: {
                        binary = new BinaryObject(path);
                        break;
                    }
                    case 4: {
                        BinaryObject obj = new BinaryObject(path);
                        obj.setType(16);
                        binary = obj;
                    }
                }
            }
        }
        catch (IOException iOException) {
            binary = new BinaryArchive(path);
        }
        return binary;
    }

    public String getFormat() {
        return "ELF";
    }

    public boolean isBinary(byte[] array, IPath path) {
        return Elf.isElfHeader(array) || AR.isARHeader(array);
    }
}

