/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.SharedLibrary;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetAutoSolib;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetStopOnSolibEvents;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShow;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIInfoSharedLibrary;
import org.eclipse.cdt.debug.mi.core.command.MISharedLibrary;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowSolibSearchPathInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfoSharedLibraryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIShared;

public class SharedLibraryManager
extends SessionObject
implements ICDISharedLibraryManager {
    List sharedList = new ArrayList(1);
    boolean autoupdate = true;
    boolean isDeferred;

    public SharedLibraryManager(Session session) {
        super(session);
    }

    MIShared[] getMIShareds() throws CDIException {
        MIShared[] miLibs = new MIShared[]{};
        Session session = (Session)this.getSession();
        CommandFactory factory = session.getMISession().getCommandFactory();
        MIInfoSharedLibrary infoShared = factory.createMIInfoSharedLibrary();
        try {
            session.getMISession().postCommand(infoShared);
            MIInfoSharedLibraryInfo info = infoShared.getMIInfoSharedLibraryInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
            miLibs = info.getMIShared();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return miLibs;
    }

    public void update() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        List eventList = this.updateState();
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public List updateState() throws CDIException {
        Session session = (Session)this.getSession();
        ICDIConfiguration conf = session.getConfiguration();
        if (!conf.supportsSharedLibrary()) {
            return Collections.EMPTY_LIST;
        }
        MIShared[] miLibs = this.getMIShareds();
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>(miLibs.length);
        int i = 0;
        while (i < miLibs.length) {
            ICDISharedLibrary sharedlib = this.getSharedLibrary(miLibs[i].getName());
            if (sharedlib != null) {
                if (this.hasSharedLibChanged(sharedlib, miLibs[i])) {
                    ((SharedLibrary)sharedlib).setMIShared(miLibs[i]);
                    eventList.add(new MISharedLibChangedEvent(miLibs[i].getName()));
                }
            } else {
                this.sharedList.add(new SharedLibrary(this, miLibs[i]));
                eventList.add(new MISharedLibCreatedEvent(miLibs[i].getName()));
            }
            ++i;
        }
        ICDISharedLibrary[] oldlibs = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int i2 = 0;
        while (i2 < oldlibs.length) {
            boolean found = false;
            int j = 0;
            while (j < miLibs.length) {
                if (miLibs[j].getName().equals(oldlibs[i2].getFileName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                eventList.add(new MISharedLibUnloadedEvent(oldlibs[i2].getFileName()));
            }
            ++i2;
        }
        return eventList;
    }

    public boolean hasSharedLibChanged(ICDISharedLibrary lib, MIShared miLib) {
        return !miLib.getName().equals(lib.getFileName()) || miLib.getFrom() != lib.getStartAddress() || miLib.getTo() != lib.getEndAddress() || miLib.isRead() != lib.areSymbolsLoaded();
    }

    public void deleteSharedLibrary(ICDISharedLibrary lib) {
        this.sharedList.remove(lib);
    }

    public ICDISharedLibrary getSharedLibrary(String name) {
        ICDISharedLibrary[] libs = this.sharedList.toArray(new ICDISharedLibrary[0]);
        int i = 0;
        while (i < libs.length) {
            if (name.equals(libs[i].getFileName())) {
                return libs[i];
            }
            ++i;
        }
        return null;
    }

    public void setDeferredBreakpoint(boolean set) {
        this.isDeferred = set;
    }

    public boolean isDeferredBreakpoint() {
        return this.isDeferred;
    }

    public void setAutoLoadSymbols(boolean set) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetAutoSolib solib = factory.createMIGDBSetAutoSolib(set);
        try {
            mi.postCommand(solib);
            solib.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isAutoLoadSymbols() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShow show = factory.createMIGDBShow(new String[]{"auto-solib-add"});
        try {
            mi.postCommand(show);
            MIGDBShowInfo info = show.getMIGDBShowInfo();
            String value = info.getValue();
            if (value != null) {
                return value.equalsIgnoreCase("on");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return false;
    }

    public void setStopOnSolibEvents(boolean set) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetStopOnSolibEvents stop = factory.createMIGDBSetStopOnSolibEvents(set);
        try {
            mi.postCommand(stop);
            stop.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean isStopOnSolibEvents() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShow show = factory.createMIGDBShow(new String[]{"stop-on-solib-events"});
        try {
            mi.postCommand(show);
            MIGDBShowInfo info = show.getMIGDBShowInfo();
            String value = info.getValue();
            if (value != null) {
                return value.equalsIgnoreCase("1");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return false;
    }

    public void setSharedLibraryPaths(String[] libPaths) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetSolibSearchPath solib = factory.createMIGDBSetSolibSearchPath(libPaths);
        try {
            mi.postCommand(solib);
            solib.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public String[] getSharedLibraryPaths() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShowSolibSearchPath dir = factory.createMIGDBShowSolibSearchPath();
        try {
            mi.postCommand(dir);
            MIGDBShowSolibSearchPathInfo info = dir.getMIGDBShowSolibSearchPathInfo();
            return info.getDirectories();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public ICDISharedLibrary[] getSharedLibraries() throws CDIException {
        return this.sharedList.toArray(new ICDISharedLibrary[0]);
    }

    public void loadSymbols() throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MISharedLibrary sharedlibrary = factory.createMISharedLibrary();
        try {
            mi.postCommand(sharedlibrary);
            MIInfo info = sharedlibrary.getMIInfo();
            if (info == null) {
                throw new CDIException("No answer");
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        this.update();
    }

    public void loadSymbols(ICDISharedLibrary[] libs) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].areSymbolsLoaded()) {
                MISharedLibrary sharedlibrary = factory.createMISharedLibrary(libs[i].getFileName());
                try {
                    session.getMISession().postCommand(sharedlibrary);
                    MIInfo info = sharedlibrary.getMIInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
                ((SharedLibrary)libs[i]).getMIShared().setSymbolsRead(true);
                mi.fireEvent(new MISharedLibChangedEvent(libs[i].getFileName()));
            }
            ++i;
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }

    public boolean supportsAutoLoadSymbols() {
        return true;
    }

    public boolean supportsStopOnSolibEvents() {
        return true;
    }
}

