/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDICreatedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISourceLocator;

public class CBreakpointManager
implements ICBreakpointManager,
ICDIEventListener,
IAdaptable {
    private CDebugTarget fDebugTarget;
    private BreakpointMap fMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CBreakpointManager(CDebugTarget target) {
        this.setDebugTarget(target);
        this.fMap = new BreakpointMap();
        this.getDebugTarget().getCDISession().getEventManager().addEventListener(this);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.cdt.debug.internal.core.CBreakpointManager;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.cdt.debug.internal.core.model.CDebugTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.getDebugTarget();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.cdt.debug.core.model.ICDebugTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(adapter)) {
            return this.getDebugTarget();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Lorg.eclipse.debug.core.model.IDebugTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz4.equals(adapter)) {
            return this.getDebugTarget();
        }
        return null;
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected ICDIBreakpointManager getCDIBreakpointManager() {
        return this.getDebugTarget().getCDISession().getBreakpointManager();
    }

    protected ICSourceLocator getCSourceLocator() {
        ISourceLocator locator = this.getDebugTarget().getLaunch().getSourceLocator();
        if (locator instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public void dispose() {
        this.getDebugTarget().getCDISession().getEventManager().removeEventListener(this);
        this.removeAllBreakpoints();
        this.getBreakpointMap().dispose();
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source != null && source.getTarget().equals(this.getDebugTarget().getCDITarget())) {
            if (event instanceof ICDICreatedEvent) {
                if (source instanceof ICDIBreakpoint) {
                    this.handleBreakpointCreatedEvent((ICDIBreakpoint)source);
                }
            } else if (event instanceof ICDIDestroyedEvent) {
                if (source instanceof ICDIBreakpoint) {
                    this.handleBreakpointDestroyedEvent((ICDIBreakpoint)source);
                }
            } else if (event instanceof ICDIChangedEvent && source instanceof ICDIBreakpoint) {
                this.handleBreakpointChangedEvent((ICDIBreakpoint)source);
            }
        }
    }

    public boolean isTargetBreakpoint(ICBreakpoint breakpoint) {
        IResource resource = breakpoint.getMarker().getResource();
        if (breakpoint instanceof ICAddressBreakpoint) {
            return this.supportsAddressBreakpoint((ICAddressBreakpoint)breakpoint);
        }
        if (breakpoint instanceof ICLineBreakpoint) {
            ICSourceLocator sl = this.getSourceLocator();
            if (sl != null) {
                return sl.contains(resource);
            }
        } else {
            IProject project = resource.getProject();
            if (project != null && project.exists()) {
                ICSourceLocator sl = this.getSourceLocator();
                if (sl != null) {
                    return sl.contains((IResource)project);
                }
                if (project.equals((Object)this.getExecFile().getProject())) {
                    return true;
                }
                return CDebugUtils.isReferencedProject(this.getExecFile().getProject(), project);
            }
        }
        return true;
    }

    public boolean isCDIRegistered(ICBreakpoint breakpoint) {
        return this.getBreakpointMap().getCDIBreakpoint(breakpoint) != null;
    }

    public boolean supportsAddressBreakpoint(ICAddressBreakpoint breakpoint) {
        return this.getExecFile() != null && this.getExecFile().getLocation().toOSString().equals(breakpoint.getMarker().getResource().getLocation().toOSString());
    }

    public IFile getCDIBreakpointFile(ICDIBreakpoint cdiBreakpoint) {
        IResource resource;
        ICBreakpoint breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
        if (breakpoint instanceof ICLineBreakpoint && !(breakpoint instanceof ICAddressBreakpoint) && (resource = ((ICLineBreakpoint)breakpoint).getMarker().getResource()) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public ICBreakpoint getBreakpoint(ICDIBreakpoint cdiBreakpoint) {
        return this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
    }

    public long getBreakpointAddress(ICBreakpoint breakpoint) {
        ICDIBreakpoint cdiBreakpoint;
        if (breakpoint != null && (cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint)) instanceof ICDILocationBreakpoint) {
            try {
                ICDILocation location = ((ICDILocationBreakpoint)cdiBreakpoint).getLocation();
                if (location != null) {
                    return location.getAddress();
                }
            }
            catch (CDIException cDIException) {}
        }
        return 0L;
    }

    public void setBreakpoint(final ICBreakpoint breakpoint) throws DebugException {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    CBreakpointManager.this.doSetBreakpoint(breakpoint);
                }
                catch (DebugException debugException) {}
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doSetBreakpoint(ICBreakpoint breakpoint) throws DebugException {
        try {
            ICDIBreakpoint cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint);
            if (cdiBreakpoint == null) {
                if (breakpoint instanceof ICFunctionBreakpoint) {
                    cdiBreakpoint = this.setFunctionBreakpoint((ICFunctionBreakpoint)breakpoint);
                } else if (breakpoint instanceof ICAddressBreakpoint) {
                    cdiBreakpoint = this.setAddressBreakpoint((ICAddressBreakpoint)breakpoint);
                } else if (breakpoint instanceof ICLineBreakpoint) {
                    cdiBreakpoint = this.setLineBreakpoint((ICLineBreakpoint)breakpoint);
                } else if (breakpoint instanceof ICWatchpoint) {
                    cdiBreakpoint = this.setWatchpoint((ICWatchpoint)breakpoint);
                }
            }
            if (cdiBreakpoint == null) {
                return;
            }
            if (!breakpoint.isEnabled()) {
                cdiBreakpoint.setEnabled(false);
            }
            this.setBreakpointCondition(breakpoint);
        }
        catch (CoreException e) {
            this.requestFailed("Set breakpoint failed. Reason: " + e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            this.requestFailed("Set breakpoint failed. Reason: " + e.getMessage(), e);
        }
        catch (CDIException e) {
            this.targetRequestFailed("Set breakpoint failed. Reason: " + e.getMessage(), e);
        }
    }

    public void removeBreakpoint(final ICBreakpoint breakpoint) throws DebugException {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    CBreakpointManager.this.doRemoveBreakpoint(breakpoint);
                }
                catch (DebugException debugException) {}
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doRemoveBreakpoint(ICBreakpoint breakpoint) throws DebugException {
        ICDIBreakpoint cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint);
        if (cdiBreakpoint != null) {
            ICDIBreakpointManager bm = this.getCDIBreakpointManager();
            try {
                bm.deleteBreakpoints(new ICDIBreakpoint[]{cdiBreakpoint});
            }
            catch (CDIException e) {
                this.targetRequestFailed("Delete breakpoint failed. Reason: " + e.getMessage(), e);
            }
        }
    }

    public void changeBreakpointProperties(final ICBreakpoint breakpoint, final IMarkerDelta delta) throws DebugException {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    CBreakpointManager.this.doChangeBreakpointProperties(breakpoint, delta);
                }
                catch (DebugException debugException) {}
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doChangeBreakpointProperties(ICBreakpoint breakpoint, IMarkerDelta delta) throws DebugException {
        ICDIBreakpoint cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint);
        if (cdiBreakpoint == null) {
            return;
        }
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        try {
            boolean enabled = breakpoint.isEnabled();
            boolean oldEnabled = delta.getAttribute("org.eclipse.debug.core.enabled", true);
            int ignoreCount = breakpoint.getIgnoreCount();
            int oldIgnoreCount = delta.getAttribute("org.eclipse.cdt.debug.core.ignoreCount", 0);
            String condition = breakpoint.getCondition();
            String oldCondition = delta.getAttribute("org.eclipse.cdt.debug.core.condition", "");
            if (enabled != oldEnabled) {
                cdiBreakpoint.setEnabled(enabled);
            }
            if (ignoreCount != oldIgnoreCount || !condition.equals(oldCondition)) {
                ICDICondition cdiCondition = bm.createCondition(ignoreCount, condition);
                cdiBreakpoint.setCondition(cdiCondition);
            }
        }
        catch (CoreException e) {
            this.requestFailed("Change breakpoint properties failed. Reason: " + e.getMessage(), e);
        }
        catch (CDIException e) {
            this.targetRequestFailed("Change breakpoint properties failed. Reason: " + e.getMessage(), e);
        }
    }

    private void handleBreakpointCreatedEvent(final ICDIBreakpoint cdiBreakpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (cdiBreakpoint instanceof ICDILocationBreakpoint) {
                    CBreakpointManager.this.doHandleLocationBreakpointCreatedEvent((ICDILocationBreakpoint)cdiBreakpoint);
                } else if (cdiBreakpoint instanceof ICDIWatchpoint) {
                    CBreakpointManager.this.doHandleWatchpointCreatedEvent((ICDIWatchpoint)cdiBreakpoint);
                }
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleLocationBreakpointCreatedEvent(ICDILocationBreakpoint cdiBreakpoint) {
        if (cdiBreakpoint.isTemporary()) {
            return;
        }
        ICBreakpoint breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
        if (breakpoint == null) {
            try {
                if (cdiBreakpoint.getLocation().getFile() != null && cdiBreakpoint.getLocation().getFile().length() > 0) {
                    ICSourceLocator locator = this.getSourceLocator();
                    if (locator != null) {
                        Object sourceElement = locator.findSourceElement(cdiBreakpoint.getLocation().getFile());
                        if (sourceElement != null && sourceElement instanceof IFile) {
                            breakpoint = this.createLineBreakpoint((IFile)sourceElement, cdiBreakpoint);
                        } else if (cdiBreakpoint.getLocation().getAddress() > 0L) {
                            breakpoint = this.createAddressBreakpoint(cdiBreakpoint);
                        }
                    }
                } else if (cdiBreakpoint.getLocation().getAddress() > 0L) {
                    breakpoint = this.createAddressBreakpoint(cdiBreakpoint);
                }
            }
            catch (CDIException cDIException) {
            }
            catch (CoreException coreException) {}
        }
        if (breakpoint != null) {
            try {
                ((CBreakpoint)breakpoint).incrementInstallCount();
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e.getStatus());
            }
        }
    }

    protected void doHandleWatchpointCreatedEvent(ICDIWatchpoint cdiWatchpoint) {
        ICBreakpoint breakpoint = this.getBreakpointMap().getCBreakpoint(cdiWatchpoint);
        if (breakpoint == null) {
            try {
                breakpoint = CDebugModel.createWatchpoint((IResource)this.getExecFile().getProject(), cdiWatchpoint.isWriteType(), cdiWatchpoint.isReadType(), cdiWatchpoint.getWatchExpression(), cdiWatchpoint.isEnabled(), cdiWatchpoint.getCondition().getIgnoreCount(), cdiWatchpoint.getCondition().getExpression(), false);
                this.getBreakpointMap().put(breakpoint, cdiWatchpoint);
                ((CBreakpoint)breakpoint).register(true);
            }
            catch (CDIException cDIException) {
            }
            catch (CoreException coreException) {}
        }
        if (breakpoint != null) {
            try {
                ((CBreakpoint)breakpoint).incrementInstallCount();
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e.getStatus());
            }
        }
    }

    private void handleBreakpointDestroyedEvent(final ICDIBreakpoint cdiBreakpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                CBreakpointManager.this.doHandleBreakpointDestroyedEvent(cdiBreakpoint);
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleBreakpointDestroyedEvent(ICDIBreakpoint cdiBreakpoint) {
        ICBreakpoint breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
        if (breakpoint != null) {
            this.getBreakpointMap().removeCDIBreakpoint(breakpoint, cdiBreakpoint);
            try {
                ((CBreakpoint)breakpoint).decrementInstallCount();
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e.getStatus());
            }
        }
    }

    private void handleBreakpointChangedEvent(final ICDIBreakpoint cdiBreakpoint) {
        Runnable runnable = new Runnable(){

            public void run() {
                CBreakpointManager.this.doHandleBreakpointChangedEvent(cdiBreakpoint);
            }
        };
        CDebugCorePlugin.getDefault().asyncExec(runnable);
    }

    protected void doHandleBreakpointChangedEvent(ICDIBreakpoint cdiBreakpoint) {
        ICBreakpoint breakpoint = this.getBreakpointMap().getCBreakpoint(cdiBreakpoint);
        if (breakpoint != null) {
            try {
                breakpoint.setEnabled(cdiBreakpoint.isEnabled());
                breakpoint.setIgnoreCount(cdiBreakpoint.getCondition().getIgnoreCount());
                breakpoint.setCondition(cdiBreakpoint.getCondition().getExpression());
            }
            catch (CDIException cDIException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void removeAllBreakpoints() {
        ICDIBreakpoint[] cdiBreakpoints = this.getBreakpointMap().getAllCDIBreakpoints();
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        if (cdiBreakpoints.length > 0) {
            try {
                bm.deleteBreakpoints(cdiBreakpoints);
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e.getMessage());
            }
            ICBreakpoint[] breakpoints = this.getBreakpointMap().getAllCBreakpoints();
            int i = 0;
            while (i < breakpoints.length) {
                try {
                    ((CBreakpoint)breakpoints[i]).decrementInstallCount();
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e.getMessage());
                }
                ++i;
            }
        }
    }

    private synchronized ICDIBreakpoint setFunctionBreakpoint(ICFunctionBreakpoint breakpoint) throws CDIException, CoreException {
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        String function = breakpoint.getFunction();
        String fileName = function != null && function.indexOf("::") == -1 ? breakpoint.getFileName() : null;
        ICDILocation location = bm.createLocation(fileName, function, -1);
        ICDILocationBreakpoint cdiBreakpoint = bm.setLocationBreakpoint(0, location, null, null, true);
        this.getBreakpointMap().put(breakpoint, cdiBreakpoint);
        return cdiBreakpoint;
    }

    private synchronized ICDIBreakpoint setAddressBreakpoint(ICAddressBreakpoint breakpoint) throws CDIException, CoreException, NumberFormatException {
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        ICDILocation location = bm.createLocation(Long.parseLong(breakpoint.getAddress()));
        ICDILocationBreakpoint cdiBreakpoint = bm.setLocationBreakpoint(0, location, null, null, true);
        this.getBreakpointMap().put(breakpoint, cdiBreakpoint);
        return cdiBreakpoint;
    }

    private synchronized ICDIBreakpoint setLineBreakpoint(ICLineBreakpoint breakpoint) throws CDIException, CoreException {
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        ICDILocation location = bm.createLocation(breakpoint.getMarker().getResource().getLocation().lastSegment(), null, breakpoint.getLineNumber());
        ICDILocationBreakpoint cdiBreakpoint = bm.setLocationBreakpoint(0, location, null, null, true);
        this.getBreakpointMap().put(breakpoint, cdiBreakpoint);
        return cdiBreakpoint;
    }

    private synchronized ICDIBreakpoint setWatchpoint(ICWatchpoint watchpoint) throws CDIException, CoreException {
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        int accessType = 0;
        accessType |= watchpoint.isWriteType() ? 1 : 0;
        int n = watchpoint.isReadType() ? 2 : 0;
        String expression = watchpoint.getExpression();
        ICDIWatchpoint cdiWatchpoint = bm.setWatchpoint(0, accessType |= n, expression, null);
        this.getBreakpointMap().put(watchpoint, cdiWatchpoint);
        return cdiWatchpoint;
    }

    private void setBreakpointCondition(ICBreakpoint breakpoint) throws CoreException, CDIException {
        ICDIBreakpoint cdiBreakpoint = this.getBreakpointMap().getCDIBreakpoint(breakpoint);
        ICDIBreakpointManager bm = this.getCDIBreakpointManager();
        ICDICondition condition = bm.createCondition(breakpoint.getIgnoreCount(), breakpoint.getCondition());
        cdiBreakpoint.setCondition(condition);
    }

    private BreakpointMap getBreakpointMap() {
        return this.fMap;
    }

    protected void targetRequestFailed(String message, Throwable e) throws DebugException {
        this.requestFailed0(message, e, 5010);
    }

    protected void requestFailed(String message, Throwable e) throws DebugException {
        this.requestFailed0(message, e, 5012);
    }

    private void requestFailed0(String message, Throwable e, int code) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), code, message, e));
    }

    private ICLineBreakpoint createLineBreakpoint(IFile file, ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        ICLineBreakpoint breakpoint = CDebugModel.createLineBreakpoint((IResource)file, cdiBreakpoint.getLocation().getLineNumber(), cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        this.getBreakpointMap().put(breakpoint, cdiBreakpoint);
        ((CBreakpoint)((Object)breakpoint)).register(true);
        return breakpoint;
    }

    private ICAddressBreakpoint createAddressBreakpoint(ICDILocationBreakpoint cdiBreakpoint) throws CDIException, CoreException {
        ICAddressBreakpoint breakpoint = CDebugModel.createAddressBreakpoint((IResource)this.getExecFile(), cdiBreakpoint.getLocation().getAddress(), cdiBreakpoint.isEnabled(), cdiBreakpoint.getCondition().getIgnoreCount(), cdiBreakpoint.getCondition().getExpression(), false);
        this.getBreakpointMap().put(breakpoint, cdiBreakpoint);
        ((CBreakpoint)((Object)breakpoint)).register(true);
        return breakpoint;
    }

    private ICSourceLocator getSourceLocator() {
        ICSourceLocator iCSourceLocator;
        ISourceLocator locator = this.getDebugTarget().getLaunch().getSourceLocator();
        if (locator instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)locator;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("[Lorg.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz);
        } else {
            iCSourceLocator = null;
        }
        return iCSourceLocator;
    }

    private IFile getExecFile() {
        return this.getDebugTarget().getExecFile();
    }

    public class BreakpointMap {
        private HashMap fCBreakpoints = new HashMap(10);
        private HashMap fCDIBreakpoints = new HashMap(10);

        protected BreakpointMap() {
        }

        protected synchronized void put(ICBreakpoint breakpoint, ICDIBreakpoint cdiBreakpoint) {
            this.fCBreakpoints.put(breakpoint, cdiBreakpoint);
            this.fCDIBreakpoints.put(cdiBreakpoint, breakpoint);
        }

        protected synchronized ICDIBreakpoint getCDIBreakpoint(ICBreakpoint breakpoint) {
            return (ICDIBreakpoint)this.fCBreakpoints.get(breakpoint);
        }

        protected synchronized ICBreakpoint getCBreakpoint(ICDIBreakpoint cdiBreakpoint) {
            return (ICBreakpoint)this.fCDIBreakpoints.get(cdiBreakpoint);
        }

        protected void removeCBreakpoint(ICBreakpoint breakpoint) {
            ICDIBreakpoint cdiBreakpoint;
            if (breakpoint != null && (cdiBreakpoint = (ICDIBreakpoint)this.fCBreakpoints.remove(breakpoint)) != null) {
                this.fCDIBreakpoints.remove(cdiBreakpoint);
            }
        }

        protected void removeCDIBreakpoint(ICBreakpoint breakpoin, ICDIBreakpoint cdiBreakpoint) {
            ICBreakpoint breakpoint;
            if (cdiBreakpoint != null && (breakpoint = (ICBreakpoint)this.fCDIBreakpoints.remove(cdiBreakpoint)) != null) {
                this.fCBreakpoints.remove(breakpoint);
            }
        }

        protected ICBreakpoint[] getAllCBreakpoints() {
            Set set = this.fCBreakpoints.keySet();
            return set.toArray(new ICBreakpoint[set.size()]);
        }

        protected ICDIBreakpoint[] getAllCDIBreakpoints() {
            Set set = this.fCDIBreakpoints.keySet();
            return set.toArray(new ICDIBreakpoint[set.size()]);
        }

        protected void dispose() {
            this.fCBreakpoints.clear();
            this.fCDIBreakpoints.clear();
        }
    }
}

