/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends Dialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String COPY = "NewConfiguration.label.copy";
    private static final String TITLE = "NewConfiguration.error.title";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private Combo configSelector;
    private Button btnOk;
    private Text configName;
    private IConfiguration[] definedConfigurations;
    private IConfiguration parentConfig;
    private ITarget target;
    private String newName;
    private String[] allNames;
    private String title = "";

    protected NewConfigurationDialog(Shell parentShell, IConfiguration[] configs, ITarget managedTarget, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.parentConfig = null;
        this.definedConfigurations = configs == null ? new IConfiguration[]{} : configs;
        this.allNames = this.getConfigurationNames();
        this.target = managedTarget;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.newName = this.configName.getText().trim();
            String baseConfigName = this.configSelector.getItem(this.configSelector.getSelectionIndex());
            int i = 0;
            while (i < this.definedConfigurations.length) {
                IConfiguration config = this.definedConfigurations[i];
                if (config.getName().equals(baseConfigName)) {
                    this.parentConfig = config;
                    break;
                }
                ++i;
            }
        } else {
            this.newName = null;
            this.parentConfig = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.updateButtonState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)3);
        Label nameLabel = ControlFactory.createLabel((Composite)composite, (String)ManagedBuilderUIPlugin.getResourceString(NAME));
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        nameLabel.setLayoutData((Object)gd);
        this.configName = ControlFactory.createTextField((Composite)composite);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        Label configLabel = ControlFactory.createLabel((Composite)composite, (String)ManagedBuilderUIPlugin.getResourceString(COPY));
        gd = new GridData();
        gd.horizontalSpan = 1;
        configLabel.setLayoutData((Object)gd);
        this.configSelector = ControlFactory.createSelectCombo((Composite)composite, (String[])this.allNames, (String)this.newName);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.configSelector.setLayoutData((Object)gd);
        this.configSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        return composite;
    }

    public IConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private String[] getConfigurationNames() {
        String[] names = new String[this.definedConfigurations.length];
        int index = 0;
        while (index < this.definedConfigurations.length) {
            IConfiguration config = this.definedConfigurations[index];
            names[index] = config.getName();
            ++index;
        }
        return names;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String newName) {
        IConfiguration[] configs = this.target.getConfigurations();
        int index = 0;
        while (index < configs.length) {
            IConfiguration configuration = configs[index];
            if (configuration.getName() == newName) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private void updateButtonState() {
        if (this.btnOk != null) {
            int selectionIndex = this.configSelector.getSelectionIndex();
            this.btnOk.setEnabled(this.validateName() && selectionIndex != -1);
        }
    }

    private boolean validateName() {
        String currentName = this.configName.getText().trim();
        int nameLength = currentName.length();
        if (this.isDuplicateName(currentName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)ManagedBuilderUIPlugin.getResourceString(TITLE), (String)ManagedBuilderUIPlugin.getFormattedString(DUPLICATE, currentName));
            return false;
        }
        return nameLength > 0;
    }
}

