/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.Reader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IPreprocessor;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryException;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.internal.core.parser.LineOffsetReconciler;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.Preprocessor;
import org.eclipse.cdt.internal.core.parser.QuickParseCallback;
import org.eclipse.cdt.internal.core.parser.Scanner;
import org.eclipse.cdt.internal.core.parser.ast.complete.CompleteParseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.quick.QuickParseASTFactory;

public class ParserFactory {
    private static IParserLogService defaultLogService = new DefaultLogService();

    public static IASTFactory createASTFactory(ParserMode mode, ParserLanguage language) {
        if (mode == ParserMode.QUICK_PARSE) {
            return new QuickParseASTFactory();
        }
        return new CompleteParseASTFactory(language);
    }

    public static IParser createParser(IScanner scanner, ISourceElementRequestor callback, ParserMode mode, ParserLanguage language, IParserLogService log) throws ParserFactoryException {
        if (scanner == null) {
            throw new ParserFactoryException(ParserFactoryException.Kind.NULL_SCANNER);
        }
        if (language == null) {
            throw new ParserFactoryException(ParserFactoryException.Kind.NULL_LANGUAGE);
        }
        IParserLogService logService = log == null ? ParserFactory.createDefaultLogService() : log;
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourCallback = callback == null ? new NullSourceElementRequestor() : callback;
        return new Parser(scanner, ourCallback, ourMode, language, logService);
    }

    public static IScanner createScanner(Reader input, String fileName, IScannerInfo config, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor, IParserLogService log) throws ParserFactoryException {
        if (input == null) {
            throw new ParserFactoryException(ParserFactoryException.Kind.NULL_READER);
        }
        if (fileName == null) {
            throw new ParserFactoryException(ParserFactoryException.Kind.NULL_FILENAME);
        }
        if (config == null) {
            throw new ParserFactoryException(ParserFactoryException.Kind.NULL_CONFIG);
        }
        if (language == null) {
            throw new ParserFactoryException(ParserFactoryException.Kind.NULL_LANGUAGE);
        }
        IParserLogService logService = log == null ? ParserFactory.createDefaultLogService() : log;
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourRequestor = requestor == null ? new NullSourceElementRequestor() : requestor;
        Scanner s = new Scanner(input, fileName, config, ourRequestor, ourMode, language, logService);
        return s;
    }

    public static IPreprocessor createPreprocessor(Reader input, String fileName, IScannerInfo info, ParserMode mode, ParserLanguage language, ISourceElementRequestor requestor, IParserLogService logService) {
        ParserMode ourMode = mode == null ? ParserMode.COMPLETE_PARSE : mode;
        ISourceElementRequestor ourRequestor = requestor == null ? new NullSourceElementRequestor() : requestor;
        Preprocessor s = new Preprocessor(input, fileName, info, ourRequestor, ourMode, language, logService);
        return s;
    }

    public static ILineOffsetReconciler createLineOffsetReconciler(Reader input) {
        return new LineOffsetReconciler(input);
    }

    public static IQuickParseCallback createQuickParseCallback() {
        return new QuickParseCallback();
    }

    public static IParserLogService createDefaultLogService() {
        return defaultLogService;
    }
}

