/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTScopedTypeSpecifier;

public class ASTEnumerationSpecifier
extends ASTScopedTypeSpecifier
implements IASTEnumerationSpecifier,
IASTOffsetableNamedElement {
    private final String name;
    private NamedOffsets offsets = new NamedOffsets();
    private List enumerators = new ArrayList();

    public ASTEnumerationSpecifier(IASTScope scope, String name, int startingOffset, int nameOffset, int nameEndOffset) {
        super(scope, name);
        this.name = name;
        this.offsets.setNameOffset(nameOffset);
        this.offsets.setStartingOffset(startingOffset);
        this.setNameEndOffset(nameEndOffset);
    }

    public String getName() {
        return this.name;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public Iterator getEnumerators() {
        return Collections.unmodifiableList(this.enumerators).iterator();
    }

    public void addEnumerator(IASTEnumerator enumerator) {
        this.enumerators.add(enumerator);
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptEnumerationSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }
}

