/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryElement;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.SourceMapper;
import org.eclipse.cdt.internal.core.model.SourceRange;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BinaryElement
extends CElement
implements IBinaryElement,
ISourceManipulation,
ISourceReference {
    long addr;

    public BinaryElement(ICElement parent, String name, int type, long a) {
        super(parent, name, type);
        this.addr = a;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws CModelException {
        throw new CModelException(new CModelStatus(976, this));
    }

    public String getSource() throws CModelException {
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null) {
            try {
                IResource res = tu.getResource();
                if (res != null && res instanceof IFile) {
                    StringBuffer buffer = Util.getContent((IFile)res);
                    return buffer.substring(this.getStartPos(), this.getStartPos() + this.getLength());
                }
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
        }
        return "";
    }

    public ISourceRange getSourceRange() throws CModelException {
        return new SourceRange(this.getStartPos(), this.getLength(), this.getIdStartPos(), this.getIdLength(), this.getStartLine(), this.getEndLine());
    }

    public ITranslationUnit getTranslationUnit() {
        ITranslationUnit tu = null;
        CModelManager mgr = CModelManager.getDefault();
        ICElement parent = this.getParent();
        if (parent != null) {
            String lastSegment;
            ICProject cproject;
            SourceMapper mapper;
            IPath path = parent.getPath();
            if (path != null && path.isAbsolute()) {
                ICElement e;
                IFile res = mgr.getCModel().getWorkspace().getRoot().getFileForLocation(path);
                if (res != null && res.exists() && res.getType() == 1 && (e = CModelManager.getDefault().create((IResource)res)) instanceof ITranslationUnit) {
                    tu = (ITranslationUnit)e;
                }
            } else {
                path = new Path("");
            }
            if (tu == null && (mapper = mgr.getSourceMapper(cproject = this.getCProject())) != null && (lastSegment = path.lastSegment()) != null) {
                tu = mapper.findTranslationUnit(lastSegment);
            }
        }
        return tu;
    }

    protected CElementInfo createElementInfo() {
        return new CElementInfo(this);
    }

    public IResource getResource() {
        return null;
    }

    public long getAddress() throws CModelException {
        return this.addr;
    }

    public IBinary getBinary() {
        ICElement current = this;
        do {
            if (!(current instanceof IBinary)) continue;
            return (IBinary)current;
        } while ((current = current.getParent()) != null);
        return null;
    }
}

