/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsProvider;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.PEArchive;
import org.eclipse.cdt.utils.coff.parser.BinaryObject;
import org.eclipse.cdt.utils.coff.parser.Symbol;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends BinaryObject {
    PEArchive.ARHeader header;

    public ARMember(IPath p, PEArchive.ARHeader h, ICygwinToolsProvider provider) throws IOException {
        super(p, h.getPE(), provider);
        this.header = h;
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null && this.header != null) {
            try {
                stream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }

    protected PE getPE() throws IOException {
        if (this.header != null) {
            return this.header.getPE();
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected void addSymbols(Coff.Symbol[] peSyms, byte[] table, Addr2line addr2line, CPPFilt cppfilt, CygPath cypath, List list) {
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isPointer() || peSyms[i].isArray()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                Symbol sym = new Symbol(this);
                sym.type = peSyms[i].isFunction() ? 1 : 2;
                sym.name = name;
                sym.addr = peSyms[i].n_value;
                list.add(sym);
            }
            ++i;
        }
    }
}

