/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.ui.dialogs.MakeTargetDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;

public class AddBuildTargetAction
extends Action {
    MakefileContentOutlinePage fOutliner;
    static final ITargetRule[] EMPTY_TARGET_RULES = new ITargetRule[0];

    public AddBuildTargetAction(MakefileContentOutlinePage outliner) {
        super("Add To Build Target");
        this.setDescription("Add To Build Target");
        this.setToolTipText("Add To Build Target");
        this.fOutliner = outliner;
    }

    public void run() {
        IMakeTargetManager manager = MakeCorePlugin.getDefault().getTargetManager();
        IFile file = this.getFile();
        Shell shell = this.fOutliner.getControl().getShell();
        ITargetRule[] rules = this.getTargetRules(this.fOutliner.getSelection());
        if (file != null && rules.length > 0 && shell != null) {
            StringBuffer sbBuildName = new StringBuffer();
            StringBuffer sbMakefileTarget = new StringBuffer();
            int i = 0;
            while (i < rules.length) {
                String name = rules[i].getTarget().toString().trim();
                if (sbBuildName.length() == 0) {
                    sbBuildName.append(name);
                } else {
                    sbBuildName.append('_').append(name);
                }
                if (sbMakefileTarget.length() == 0) {
                    sbMakefileTarget.append(name);
                } else {
                    sbMakefileTarget.append(' ').append(name);
                }
                ++i;
            }
            String buildName = sbBuildName.toString();
            String makefileTarget = sbMakefileTarget.toString();
            IMakeTarget target = manager.findTarget(file.getParent(), buildName);
            if (target == null) {
                try {
                    String[] ids = manager.getTargetBuilders(file.getProject());
                    if (ids.length > 0) {
                        target = manager.createTarget(file.getProject(), buildName, ids[0]);
                        target.setBuildTarget(makefileTarget);
                        manager.addTarget(file.getParent(), target);
                    }
                }
                catch (CoreException e) {
                    MakeUIPlugin.errorDialog(shell, "Internal Error", "", e);
                    target = null;
                }
            }
            if (target != null) {
                try {
                    MakeTargetDialog dialog = new MakeTargetDialog(shell, target);
                    dialog.open();
                }
                catch (CoreException e) {
                    MakeUIPlugin.errorDialog(shell, "Internal Error", "", e);
                }
            }
        }
    }

    public boolean canActionBeAdded(ISelection selection) {
        ITargetRule[] rules = this.getTargetRules(selection);
        int i = 0;
        while (i < rules.length) {
            IFile file = this.getFile();
            if (file == null) {
                return false;
            }
            if (!MakeCorePlugin.getDefault().getTargetManager().hasTargetBuilder(file.getProject())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IFile getFile() {
        Object input = this.fOutliner.getInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private ITargetRule[] getTargetRules(ISelection sel) {
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() > 0) {
            ArrayList<Object> targets = new ArrayList<Object>(list.size());
            Object[] elements = list.toArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof ITargetRule) {
                    targets.add(elements[i]);
                }
                ++i;
            }
            return targets.toArray(EMPTY_TARGET_RULES);
        }
        return EMPTY_TARGET_RULES;
    }
}

