/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;

public class WordPartDetector {
    String wordPart = "";
    int offset;

    public WordPartDetector(ITextViewer viewer, int documentOffset) {
        this.offset = documentOffset - 1;
        int endOffset = documentOffset;
        try {
            IDocument doc = viewer.getDocument();
            int bottom = viewer.getBottomIndexEndOffset();
            int top = viewer.getTopIndexStartOffset();
            while (this.offset >= top && this.isMakefileLetter(doc.getChar(this.offset))) {
                --this.offset;
            }
            while (endOffset < bottom && this.isMakefileLetter(doc.getChar(endOffset))) {
                ++endOffset;
            }
            ++this.offset;
            this.wordPart = viewer.getDocument().get(this.offset, endOffset - this.offset);
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getString() {
        return this.wordPart;
    }

    public int getOffset() {
        return this.offset;
    }

    boolean isMakefileLetter(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.';
    }
}

