/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileSimpleMacroRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class MakefileMacroScanner
extends RuleBasedScanner {
    private String buffer;
    private static final String[] DELIMITERS = new String[]{"\r", "\n", "\r\n"};
    public static final String tokenText = "text";
    public static final String tokenMacro = "macro";
    public static final String tokenOther = "other";

    public MakefileMacroScanner(String buffer) {
        this.buffer = buffer;
        this.fOffset = 0;
        Token tText = new Token((Object)tokenText);
        Token tMacro = new Token((Object)tokenMacro);
        Token tOther = new Token((Object)tokenOther);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new PatternRule("\"", "\"", (IToken)tText, '\\', true));
        rules.add(new PatternRule("'", "'", (IToken)tText, '\\', true));
        rules.add((Object)new MakefileSimpleMacroRule((IToken)tMacro));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char character) {
                return Character.isWhitespace(character);
            }
        }));
        WordRule wRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return this.isWordStart(c);
            }

            public boolean isWordStart(char c) {
                return (short)c != -1 && !Character.isSpaceChar(c);
            }
        }, (IToken)tOther);
        rules.add(wRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
        this.setRange(null, 0, buffer.length());
    }

    public int getColumn() {
        return this.fOffset;
    }

    public int read() {
        int c = this.fOffset == this.buffer.length() ? -1 : (int)this.buffer.charAt(this.fOffset);
        ++this.fOffset;
        return c;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fDocument = document;
        this.fOffset = offset;
        this.fRangeEnd = offset + length;
        this.fDelimiters = new char[DELIMITERS.length][];
        int i = 0;
        while (i < DELIMITERS.length) {
            this.fDelimiters[i] = DELIMITERS[i].toCharArray();
            ++i;
        }
    }
}

