/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

class CViewDropAdapter
extends PluginDropAdapter
implements IOverwriteQuery {
    protected boolean isCanceled = false;
    protected boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    private static final int typeMask = 3;
    static /* synthetic */ Class class$0;

    public void dragEnter(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.detail == 16) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    protected IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.ui", 0, message, exception);
    }

    protected IStatus error(String message) {
        return this.error(message, null);
    }

    protected IStatus error(IResource source, String message) {
        if (this.getCurrentOperation() == 1) {
            return this.error("Can Not Copy", null);
        }
        return this.error("Can Not Move", null);
    }

    protected IContainer getActualTarget(IResource mouseTarget) {
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            return mouseTarget.getParent();
        }
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    protected Display getDisplay() {
        return this.getViewer().getControl().getDisplay();
    }

    protected Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    protected IStatus info(String message) {
        return new Status(1, "org.eclipse.ui", 0, message, null);
    }

    public CViewDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    protected void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    protected IStatus multiStatus(List problems, String message) {
        IStatus[] children = new IStatus[problems.size()];
        problems.toArray(children);
        if (children.length == 1) {
            return children[0];
        }
        return new MultiStatus("org.eclipse.ui", 0, children, message, null);
    }

    protected IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, "Ok", null);
    }

    protected void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = "Error";
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        if (selection == null || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator iterator = structuredSelection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            IResource resource = null;
            if (object instanceof IResource) {
                resource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource == null || (resource.getType() & 3) == 0) continue;
            resources.add(resource);
        }
        IResource[] result = new IResource[resources.size()];
        resources.toArray(result);
        return result;
    }

    public boolean performDrop(Object data) {
        this.isCanceled = false;
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || data == null) {
            return false;
        }
        boolean result = false;
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = this.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])data;
        } else if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(data);
            result = status.isOK();
        } else {
            result = super.performDrop(data);
        }
        if (resources != null) {
            status = this.getCurrentOperation() == 1 ? this.performResourceCopy(this.getShell(), resources) : this.performResourceMove(resources);
        }
        this.openError(status);
        return result;
    }

    private IStatus performFileDrop(Object data) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, "ProblemI mporting", null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        Object obj = this.getCurrentTarget();
        IResource res = null;
        if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            res = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        final IContainer target = this.getActualTarget(res);
        final String[] names = (String[])data;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                CViewDropAdapter.this.getShell().forceActive();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(CViewDropAdapter.this.getShell());
                operation.copyFiles(names, target);
            }
        });
        return problems;
    }

    private IStatus performResourceCopy(Shell shell, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, "Problems Moving", null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        Object obj = this.getCurrentTarget();
        IResource res = null;
        if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            res = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        IContainer target = this.getActualTarget(res);
        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
        operation.copyResources(sources, target);
        return problems;
    }

    private IStatus performResourceMove(IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, "Problems Moving", null);
        this.mergeStatus(problems, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        Object obj = this.getCurrentTarget();
        IResource res = null;
        if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            res = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        IContainer target = this.getActualTarget(res);
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), "Move Resource Action", "Move Resource Action");
        sources = checker.checkReadOnlyResources(sources);
        MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
        operation.copyResources(sources, target);
        return problems;
    }

    public String queryOverwrite(String pathString) {
        final String[] returnCode = new String[]{"CANCEL"};
        final String msg = String.valueOf(pathString) + " " + CUIPlugin.getResourceString("CViewDragNDrop.txt");
        final String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(CViewDropAdapter.this.getShell(), "Question", null, msg, 3, options, 0);
                dialog.open();
                int returnVal = dialog.getReturnCode();
                String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
                returnCode[0] = returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
            }
        });
        return returnCode[0];
    }

    public boolean validateDrop(Object target, int dragOperation, TransferData transferType) {
        if (dragOperation != 0) {
            this.lastValidOperation = dragOperation;
        }
        if (FileTransfer.getInstance().isSupportedType(transferType) && this.lastValidOperation != 1) {
            return false;
        }
        if (super.validateDrop(target, dragOperation, transferType)) {
            return true;
        }
        return this.validateTarget(target, transferType).isOK();
    }

    private IStatus validateTarget(Object target, TransferData transferType) {
        if (target instanceof IAdaptable) {
            IResource r;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((r = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                return this.info("Target Must Be Resource");
            }
            target = r;
        }
        if (!(target instanceof IResource)) {
            return this.info("Target Must Be Resource");
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return this.error("Can Not Drop Into Closed Project");
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return this.error("Resources Can Not Be Siblings");
        }
        String message = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources == null) {
                message = "Drop Operation Error Other";
            } else {
                Object operation = this.lastValidOperation == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                message = operation.validateDestination(destination, selectedResources);
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return this.error(message);
        }
        return this.ok();
    }
}

