/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTElaboratedTypeSpecifier
extends ASTSymbol
implements IASTElaboratedTypeSpecifier {
    private List references;
    private final boolean isForwardDeclaration;
    private final ASTClassKind kind;
    private final ASTQualifiedNamedElement qualifiedName;
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTReferenceStore store;

    public ASTElaboratedTypeSpecifier(ISymbol checkSymbol, ASTClassKind kind, int startingOffset, int nameOffset, int nameEndOffset, int endOffset, List references, boolean isDecl) {
        super(checkSymbol);
        this.kind = kind;
        this.setStartingOffset(startingOffset);
        this.setNameOffset(nameOffset);
        this.setNameEndOffset(nameEndOffset);
        this.setEndingOffset(endOffset);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), checkSymbol.getName());
        this.store = new ASTReferenceStore(references);
        this.isForwardDeclaration = isDecl;
        this.references = references;
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public ASTClassKind getClassKind() {
        return this.kind;
    }

    public boolean isResolved() throws ASTNotImplementedException {
        return !this.getSymbol().isForwardDeclaration();
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        if (this.isForwardDeclaration) {
            try {
                requestor.acceptElaboratedForewardDeclaration(this);
            }
            catch (Exception exception) {}
        }
        this.store.processReferences(requestor);
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public List getReferences() {
        return this.references;
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }

    public IASTNode.LookupResult lookup(String prefix, IASTNode.LookupKind kind) {
        return null;
    }
}

