/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ContainerSymbol
extends BasicSymbol
implements IContainerSymbol {
    private LinkedList _usingDirectives;
    private HashMap _containedSymbols;
    static /* synthetic */ Class class$0;

    protected ContainerSymbol(ParserSymbolTable table, String name) {
        super(table, name);
    }

    protected ContainerSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    protected ContainerSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        ContainerSymbol copy = (ContainerSymbol)super.clone();
        copy._usingDirectives = this._usingDirectives != null ? (LinkedList)this._usingDirectives.clone() : null;
        copy._containedSymbols = this._containedSymbols != null ? (HashMap)this._containedSymbols.clone() : null;
        return copy;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addSymbol(ISymbol obj) throws ParserSymbolTableException {
        void var2_4;
        ContainerSymbol containerSymbol = this;
        if (obj.getType() == TypeInfo.t_enumerator && containerSymbol.getType() == TypeInfo.t_enumeration) {
            obj.setTypeSymbol(containerSymbol);
            IContainerSymbol iContainerSymbol = containerSymbol.getContainingSymbol();
        }
        if (this.getType() == TypeInfo.t_template && (obj.getType() == TypeInfo.t_class || obj.getType() == TypeInfo.t_function) && this.getContainedSymbols() != null) {
            this.getContainedSymbols().size();
        }
        Map declarations = var2_4.getContainedSymbols();
        boolean unnamed = obj.getName().equals("");
        Object origObj = null;
        obj.setContainingSymbol((IContainerSymbol)var2_4);
        origObj = declarations.get(obj.getName());
        if (origObj != null) {
            boolean validOverride;
            ISymbol origDecl = null;
            LinkedList<ISymbol> origList = null;
            if (origObj instanceof ISymbol) {
                origDecl = (ISymbol)origObj;
            } else {
                Class<?> clazz = origObj.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("[Ljava.util.LinkedList;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz != clazz2) throw new ParserSymbolTableException(-1);
                origList = (LinkedList<ISymbol>)origObj;
            }
            boolean bl = validOverride = origList == null ? ParserSymbolTable.isValidOverload(origDecl, obj) : ParserSymbolTable.isValidOverload(origList, obj);
            if (!unnamed && !validOverride) throw new ParserSymbolTableException(3);
            if (origList == null) {
                origList = new LinkedList<ISymbol>();
                origList.add(origDecl);
                origList.add(obj);
                declarations.remove(origDecl);
                declarations.put(obj.getName(), origList);
            } else {
                origList.add(obj);
            }
        } else {
            declarations.put(obj.getName(), obj);
        }
        obj.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
        AddSymbolCommand command = new AddSymbolCommand(obj, (IContainerSymbol)var2_4);
        this.getSymbolTable().pushCommand(command);
    }

    public boolean hasUsingDirectives() {
        return this._usingDirectives != null && !this._usingDirectives.isEmpty();
    }

    public List getUsingDirectives() {
        if (this._usingDirectives == null) {
            this._usingDirectives = new LinkedList();
        }
        return this._usingDirectives;
    }

    public void addUsingDirective(IContainerSymbol namespace) throws ParserSymbolTableException {
        if (namespace.getType() != TypeInfo.t_namespace) {
            throw new ParserSymbolTableException(5);
        }
        ISymbol alias = namespace.getTypeSymbol();
        if (alias != null && alias.isType(TypeInfo.t_namespace)) {
            namespace = (IContainerSymbol)alias;
        }
        List usingDirectives = this.getUsingDirectives();
        usingDirectives.add(namespace);
        AddUsingDirectiveCommand command = new AddUsingDirectiveCommand(this, namespace);
        this.getSymbolTable().pushCommand(command);
    }

    public ISymbol addUsingDeclaration(String name) throws ParserSymbolTableException {
        return this.addUsingDeclaration(name, null);
    }

    public ISymbol addUsingDeclaration(String name, IContainerSymbol declContext) throws ParserSymbolTableException {
        ISymbol obj;
        ParserSymbolTable.LookupData data;
        block7: {
            data = new ParserSymbolTable.LookupData(name, TypeInfo.t_any, null);
            if (declContext != null) {
                data.qualified = true;
                data.templateInstance = declContext.getTemplateInstance();
                ParserSymbolTable.lookup(data, declContext);
            } else {
                ParserSymbolTable.lookup(data, this);
            }
            obj = null;
            try {
                obj = ParserSymbolTable.resolveAmbiguities(data);
            }
            catch (ParserSymbolTableException e) {
                if (e.reason == 7) break block7;
                throw e;
            }
        }
        if (data.foundItems == null) {
            throw new ParserSymbolTableException(5);
        }
        BasicSymbol clone = null;
        int size = obj == null ? data.foundItems.size() : 1;
        Iterator iter = data.foundItems.iterator();
        int i = size;
        while (i > 0) {
            ISymbol iSymbol = obj = obj != null && size == 1 ? obj : (ISymbol)iter.next();
            if (!ParserSymbolTable.okToAddUsingDeclaration(obj, this)) {
                throw new ParserSymbolTableException(5);
            }
            clone = (BasicSymbol)obj.clone();
            this.addSymbol(clone);
            --i;
        }
        return size == 1 ? clone : null;
    }

    public Map getContainedSymbols() {
        if (this._containedSymbols == null) {
            this._containedSymbols = new HashMap();
        }
        return this._containedSymbols;
    }

    public ISymbol elaboratedLookup(TypeInfo.eType type, String name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, type, this.getTemplateInstance());
        ParserSymbolTable.lookup(data, this);
        return ParserSymbolTable.resolveAmbiguities(data);
    }

    public ISymbol lookup(String name) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_any, this.getTemplateInstance());
        ParserSymbolTable.lookup(data, this);
        return ParserSymbolTable.resolveAmbiguities(data);
    }

    public ISymbol lookupMemberForDefinition(String name) throws ParserSymbolTableException {
        ISymbol symbol;
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_any, this.getTemplateInstance());
        data.qualified = true;
        IContainerSymbol container = this;
        if (container.isType(TypeInfo.t_namespace) && (symbol = container.getTypeSymbol()) != null && symbol.isType(TypeInfo.t_namespace)) {
            container = (IContainerSymbol)symbol;
        }
        ParserSymbolTable.lookupInContained(data, container);
        return ParserSymbolTable.resolveAmbiguities(data);
    }

    public IContainerSymbol lookupNestedNameSpecifier(String name) throws ParserSymbolTableException {
        return this.lookupNestedNameSpecifier(name, this);
    }

    private IContainerSymbol lookupNestedNameSpecifier(String name, IContainerSymbol inSymbol) throws ParserSymbolTableException {
        ISymbol foundSymbol = null;
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_namespace, this.getTemplateInstance());
        data.upperType = TypeInfo.t_union;
        ParserSymbolTable.lookupInContained(data, inSymbol);
        if (data.foundItems != null) {
            foundSymbol = ParserSymbolTable.resolveAmbiguities(data);
        }
        if (foundSymbol == null && inSymbol.getContainingSymbol() != null) {
            foundSymbol = this.lookupNestedNameSpecifier(name, inSymbol.getContainingSymbol());
        }
        if (foundSymbol instanceof IContainerSymbol) {
            return (IContainerSymbol)foundSymbol;
        }
        return null;
    }

    public ISymbol qualifiedLookup(String name) throws ParserSymbolTableException {
        return this.qualifiedLookup(name, TypeInfo.t_any);
    }

    public ISymbol qualifiedLookup(String name, TypeInfo.eType t) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, t, this.getTemplateInstance());
        data.qualified = true;
        ParserSymbolTable.lookup(data, this);
        return ParserSymbolTable.resolveAmbiguities(data);
    }

    public IParameterizedSymbol unqualifiedFunctionLookup(String name, List parameters) throws ParserSymbolTableException {
        HashSet associated = new HashSet();
        int size = parameters == null ? 0 : parameters.size();
        Iterator iter = parameters == null ? null : parameters.iterator();
        TypeInfo param = null;
        ISymbol paramType = null;
        int i = size;
        while (i > 0) {
            param = (TypeInfo)iter.next();
            paramType = ParserSymbolTable.getFlatTypeInfo(param).getTypeSymbol();
            if (paramType != null) {
                TypeInfo.PtrOp op;
                ParserSymbolTable.getAssociatedScopes(paramType, associated);
                if (param.hasPtrOperators() && param.getPtrOperators().size() == 1 && (op = (TypeInfo.PtrOp)param.getPtrOperators().iterator().next()).getType() == TypeInfo.PtrOp.t_pointer && paramType.getContainingSymbol().isType(TypeInfo.t_class, TypeInfo.t_union)) {
                    ParserSymbolTable.getAssociatedScopes(paramType.getContainingSymbol(), associated);
                }
            }
            --i;
        }
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_function, this.getTemplateInstance());
        data.parameters = parameters == null ? new LinkedList() : parameters;
        data.associated = associated;
        ParserSymbolTable.lookup(data, this);
        ISymbol found = ParserSymbolTable.resolveAmbiguities(data);
        if (found == null || found.getContainingSymbol().getType() != TypeInfo.t_class) {
            if (found != null) {
                data.foundItems.add(found);
            }
            Object[] scopes = ((AbstractCollection)associated).toArray();
            size = associated.size();
            int i2 = 0;
            while (i2 < size) {
                IContainerSymbol associatedScope = (IContainerSymbol)scopes[i2];
                if (associated.contains(associatedScope)) {
                    data.qualified = true;
                    data.ignoreUsingDirectives = true;
                    ParserSymbolTable.lookup(data, associatedScope);
                }
                ++i2;
            }
            found = ParserSymbolTable.resolveAmbiguities(data);
        }
        if (found instanceof IParameterizedSymbol) {
            return (IParameterizedSymbol)found;
        }
        return null;
    }

    public IParameterizedSymbol memberFunctionLookup(String name, List parameters) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_function, this.getTemplateInstance());
        data.parameters = parameters == null ? new LinkedList() : parameters;
        ParserSymbolTable.lookup(data, this);
        return (IParameterizedSymbol)ParserSymbolTable.resolveAmbiguities(data);
    }

    public IParameterizedSymbol qualifiedFunctionLookup(String name, List parameters) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_function, this.getTemplateInstance());
        data.qualified = true;
        data.parameters = parameters == null ? new LinkedList() : parameters;
        ParserSymbolTable.lookup(data, this);
        return (IParameterizedSymbol)ParserSymbolTable.resolveAmbiguities(data);
    }

    public TemplateInstance templateLookup(String name, List arguments) throws ParserSymbolTableException {
        ParserSymbolTable.LookupData data = new ParserSymbolTable.LookupData(name, TypeInfo.t_any, this.getTemplateInstance());
        data.parameters = arguments;
        ParserSymbolTable.lookup(data, this);
        ISymbol found = ParserSymbolTable.resolveAmbiguities(data);
        if (found.isType(TypeInfo.t_template)) {
            return ((IParameterizedSymbol)found).instantiate(arguments);
        }
        return null;
    }

    public TemplateInstance instantiate(List arguments) throws ParserSymbolTableException {
        List paramList;
        int numParams;
        if (this.getType() != TypeInfo.t_template) {
            return null;
        }
        IParameterizedSymbol template = null;
        if (template == null) {
            template = (IParameterizedSymbol)((Object)this);
        }
        int n = numParams = (paramList = template.getParameterList()) != null ? paramList.size() : 0;
        if (numParams == 0) {
            return null;
        }
        HashMap<ISymbol, Object> map = new HashMap<ISymbol, Object>();
        Iterator paramIter = paramList.iterator();
        Iterator argIter = arguments.iterator();
        ISymbol param = null;
        TypeInfo arg = null;
        int i = 0;
        while (i < numParams) {
            param = (ISymbol)paramIter.next();
            if (argIter.hasNext()) {
                arg = (TypeInfo)argIter.next();
                map.put(param, arg);
            } else {
                Object obj = param.getTypeInfo().getDefault();
                if (obj != null && obj instanceof TypeInfo) {
                    map.put(param, obj);
                } else {
                    throw new ParserSymbolTableException(4);
                }
            }
            ++i;
        }
        if (template.getContainedSymbols().size() != 1) {
            throw new ParserSymbolTableException(4);
        }
        Iterator iter = template.getContainedSymbols().keySet().iterator();
        IContainerSymbol symbol = (IContainerSymbol)template.getContainedSymbols().get(iter.next());
        TemplateInstance instance = new TemplateInstance(this.getSymbolTable(), symbol, map);
        return instance;
    }

    private static class AddSymbolCommand
    extends ParserSymbolTable.Command {
        private ISymbol _symbol;
        private IContainerSymbol _context;

        AddSymbolCommand(ISymbol newDecl, IContainerSymbol context) {
            this._symbol = newDecl;
            this._context = context;
        }

        public void undoIt() {
            Object obj = this._context.getContainedSymbols().get(this._symbol.getName());
            if (obj instanceof LinkedList) {
                LinkedList list = (LinkedList)obj;
                ListIterator iter = list.listIterator();
                int size = list.size();
                ISymbol item = null;
                int i = 0;
                while (i < size) {
                    item = (ISymbol)iter.next();
                    if (item == this._symbol) {
                        iter.remove();
                        break;
                    }
                    ++i;
                }
                if (list.size() == 1) {
                    this._context.getContainedSymbols().remove(this._symbol.getName());
                    this._context.getContainedSymbols().put(this._symbol.getName(), list.getFirst());
                }
            } else if (obj instanceof BasicSymbol) {
                this._context.getContainedSymbols().remove(this._symbol.getName());
            }
        }
    }

    private static class AddUsingDirectiveCommand
    extends ParserSymbolTable.Command {
        private IContainerSymbol _decl;
        private IContainerSymbol _namespace;

        public AddUsingDirectiveCommand(IContainerSymbol container, IContainerSymbol namespace) {
            this._decl = container;
            this._namespace = namespace;
        }

        public void undoIt() {
            this._decl.getUsingDirectives().remove(this._namespace);
        }
    }
}

