/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.search.matching.OrPattern;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchResultCollector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;

public class CSearchOperation
implements IRunnableWithProgress,
ICSearchConstants {
    private CSearchResultCollector _collector;
    private IWorkspace _workspace;
    private ICSearchScope _scope;
    private String _stringPattern;
    private String _scopeDescription;
    private boolean _caseSensitive;
    private ICSearchConstants.LimitTo _limitTo;
    private List _searchFor;

    public CSearchOperation(IWorkspace workspace, String pattern, boolean caseSensitive, List searchFor, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String scopeDescription, CSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this._stringPattern = pattern;
        this._caseSensitive = caseSensitive;
        this._searchFor = searchFor;
    }

    public CSearchOperation(IWorkspace workspace, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String scopeDescription, CSearchResultCollector collector) {
        this._workspace = workspace;
        this._limitTo = limitTo;
        this._scope = scope;
        this._scopeDescription = scopeDescription;
        this._collector = collector;
        this._collector.setOperation(this);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        this._collector.setProgressMonitor(monitor);
        SearchEngine engine = new SearchEngine(CUIPlugin.getSharedWorkingCopies());
        OrPattern pattern = null;
        if (this._searchFor.size() > 1) {
            OrPattern orPattern = new OrPattern();
            Iterator iter = this._searchFor.iterator();
            while (iter.hasNext()) {
                ICSearchConstants.SearchFor element = (ICSearchConstants.SearchFor)iter.next();
                orPattern.addPattern(SearchEngine.createSearchPattern((String)this._stringPattern, (ICSearchConstants.SearchFor)element, (ICSearchConstants.LimitTo)this._limitTo, (boolean)this._caseSensitive));
            }
            pattern = orPattern;
        } else {
            Iterator iter = this._searchFor.iterator();
            pattern = SearchEngine.createSearchPattern((String)this._stringPattern, (ICSearchConstants.SearchFor)((ICSearchConstants.SearchFor)iter.next()), (ICSearchConstants.LimitTo)this._limitTo, (boolean)this._caseSensitive);
        }
        engine.search(this._workspace, (ICSearchPattern)pattern, this._scope, (ICSearchResultCollector)this._collector, false);
    }

    public String getSingularLabel() {
        String desc = null;
        desc = this._stringPattern;
        Object[] args = new String[]{desc, this._scopeDescription};
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CSearchMessages.getFormattedString("CSearchOperation.singularDeclarationsPostfix", args);
        }
        if (this._limitTo == ICSearchConstants.REFERENCES) {
            return CSearchMessages.getFormattedString("CSearchOperation.singularReferencesPostfix", args);
        }
        return CSearchMessages.getFormattedString("CSearchOperation.singularOccurrencesPostfix", args);
    }

    public String getPluralLabelPattern() {
        String desc = null;
        desc = this._stringPattern;
        Object[] args = new String[]{desc, "{0}", this._scopeDescription};
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CSearchMessages.getFormattedString("CSearchOperation.pluralDeclarationsPostfix", args);
        }
        if (this._limitTo == ICSearchConstants.REFERENCES) {
            return CSearchMessages.getFormattedString("CSearchOperation.pluralReferencesPostfix", args);
        }
        return CSearchMessages.getFormattedString("CSearchOperation.pluralOccurrencesPostfix", args);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return CPluginImages.DESC_OBJS_SEARCH_REF;
    }
}

