/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;

public class CDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fPathsButton;
    private Combo fVariableFormatCombo;
    private Combo fExpressionFormatCombo;
    private Combo fRegisterFormatCombo;
    private Button fAutoDisassemblyButton;
    private IntegerFieldEditor fMaxNumberOfInstructionsText;
    private static final int NUMBER_OF_DIGITS = 3;
    private static int[] fFormatIds;
    private static String[] fFormatLabels;
    private PropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[3];
        nArray[1] = 4;
        nArray[2] = 1;
        fFormatIds = nArray;
        fFormatLabels = new String[]{"Natural", "Hexadecimal", "Decimal"};
    }

    public CDebugPreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        this.setDescription("General settings for C/C++ Debugging.");
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)ICDebugHelpContextIds.C_DEBUG_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createViewSettingPreferences(composite);
        this.createSpacer(composite, 1);
        this.createDisassemblySettingPreferences(composite);
        this.setValues();
        return composite;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        return ControlFactory.createGroup((Composite)parent, (String)labelText, (int)numColumns);
    }

    private void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fPathsButton.setSelection(store.getBoolean(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS));
        this.fAutoDisassemblyButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_AUTO_DISASSEMBLY));
        this.getMaxNumberOfInstructionsText().setStringValue(new Integer(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS)).toString());
        this.fVariableFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT)));
        this.fExpressionFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fRegisterFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    public void init(IWorkbench workbench) {
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new PropertyChangeListener();
        }
        return this.fPropertyChangeListener;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES, false);
        store.setDefault(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS, true);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_AUTO_DISASSEMBLY, false);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS, 100);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT, 0);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT, 0);
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT, 0);
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
    }

    private void createViewSettingPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, "Opened view default settings");
        this.fPathsButton = this.createCheckButton(comp, "Show full &paths");
        Composite formatComposite = ControlFactory.createCompositeEx((Composite)comp, (int)2, (int)0);
        ((GridLayout)formatComposite.getLayout()).makeColumnsEqualWidth = true;
        this.fVariableFormatCombo = this.createComboBox(formatComposite, "Default variable format:", fFormatLabels, fFormatLabels[0]);
        this.fExpressionFormatCombo = this.createComboBox(formatComposite, "Default expression format:", fFormatLabels, fFormatLabels[0]);
        this.fRegisterFormatCombo = this.createComboBox(formatComposite, "Default register format:", fFormatLabels, fFormatLabels[0]);
    }

    private void createDisassemblySettingPreferences(Composite parent) {
        Composite comp = this.createGroupComposite(parent, 1, "Disassembly options");
        this.fAutoDisassemblyButton = this.createCheckButton(comp, "Automatically switch to &disassembly mode");
        this.createMaxNumberOfInstructionsField(comp);
    }

    private void createMaxNumberOfInstructionsField(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)2);
        this.fMaxNumberOfInstructionsText = new IntegerFieldEditor(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS, "Maximum number of instructions: ", composite, 3);
        GridData data = (GridData)this.fMaxNumberOfInstructionsText.getTextControl(composite).getLayoutData();
        data.horizontalAlignment = 1;
        data.widthHint = this.convertWidthInCharsToPixels(4);
        this.fMaxNumberOfInstructionsText.setPreferencePage((PreferencePage)this);
        this.fMaxNumberOfInstructionsText.setValidateStrategy(0);
        this.fMaxNumberOfInstructionsText.setValidRange(1, 999);
        String minValue = Integer.toString(1);
        String maxValue = Integer.toString(999);
        this.fMaxNumberOfInstructionsText.setErrorMessage(MessageFormat.format("The valid value range is [{0},{1}].", minValue, maxValue));
        this.fMaxNumberOfInstructionsText.load();
        this.fMaxNumberOfInstructionsText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    CDebugPreferencePage.this.setValid(CDebugPreferencePage.this.getMaxNumberOfInstructionsText().isValid());
                }
            }
        });
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private Combo createComboBox(Composite parent, String label, String[] items, String selection) {
        ControlFactory.createLabel((Composite)parent, (String)label);
        Combo combo = ControlFactory.createSelectCombo((Composite)parent, (String[])items, (String)selection);
        combo.setLayoutData((Object)new GridData());
        return combo;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        this.storeValues();
        if (this.getPropertyChangeListener().hasStateChanged()) {
            this.refreshViews();
        }
        CDebugUIPlugin.getDefault().savePluginPreferences();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void refreshViews() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IWorkbenchWindow[] windows = CDebugUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                IWorkbenchPage page = null;
                int i = 0;
                while (i < windows.length) {
                    page = windows[i].getActivePage();
                    if (page != null) {
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.ExpressionView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.VariableView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.cdt.debug.ui.RegitersView");
                    }
                    ++i;
                }
            }
        });
    }

    protected void refreshViews(IWorkbenchPage page, String viewID) {
        IViewPart part = page.findView(viewID);
        if (part != null) {
            Viewer viewer;
            IDebugView adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.debug.ui.IDebugView;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)part.getAdapter((Class)clazz)) != null && (viewer = adapter.getViewer()) instanceof StructuredViewer) {
                ((StructuredViewer)viewer).refresh();
            }
        }
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS, this.fPathsButton.getSelection());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_AUTO_DISASSEMBLY, this.fAutoDisassemblyButton.getSelection());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS, this.getMaxNumberOfInstructionsText().getIntValue());
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT, CDebugPreferencePage.getFormatId(this.fVariableFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT, CDebugPreferencePage.getFormatId(this.fExpressionFormatCombo.getSelectionIndex()));
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT, CDebugPreferencePage.getFormatId(this.fRegisterFormatCombo.getSelectionIndex()));
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fPathsButton.setSelection(store.getDefaultBoolean(ICDebugPreferenceConstants.PREF_SHOW_FULL_PATHS));
        this.fAutoDisassemblyButton.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean(ICDebugConstants.PREF_AUTO_DISASSEMBLY));
        this.getMaxNumberOfInstructionsText().setStringValue(new Integer(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS)).toString());
        this.fVariableFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT)));
        this.fExpressionFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fRegisterFormatCombo.select(CDebugPreferencePage.getFormatIndex(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    private static int getFormatId(int index) {
        return index >= 0 && index < fFormatIds.length ? fFormatIds[index] : fFormatIds[0];
    }

    private static int getFormatIndex(int id) {
        int i = 0;
        while (i < fFormatIds.length) {
            if (fFormatIds[i] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected IntegerFieldEditor getMaxNumberOfInstructionsText() {
        return this.fMaxNumberOfInstructionsText;
    }

    protected class PropertyChangeListener
    implements IPropertyChangeListener {
        private boolean fHasStateChanged = false;

        protected PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES)) {
                this.fHasStateChanged = true;
            } else if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_CHAR_VALUES)) {
                this.fHasStateChanged = true;
            }
        }

        protected boolean hasStateChanged() {
            return this.fHasStateChanged;
        }
    }
}

