/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.search.AcceptMatchOperation;
import org.eclipse.cdt.internal.core.search.CSearchScope;
import org.eclipse.cdt.internal.core.search.CWorkspaceScope;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.matching.MatchLocator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SearchEngine
implements ICSearchConstants {
    public static boolean VERBOSE = false;
    private IWorkingCopy[] workingCopies = null;

    public SearchEngine() {
    }

    public SearchEngine(IWorkingCopy[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    public static ICSearchScope createWorkspaceScope() {
        return new CWorkspaceScope();
    }

    public static ICSearchScope createCSearchScope(ICElement[] elements) {
        return SearchEngine.createCSearchScope(elements, true);
    }

    public static ICSearchScope createCSearchScope(ICElement[] elements, boolean includeReferencedProjects) {
        CSearchScope scope = new CSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            ICElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof ICProject) {
                        scope.add((ICProject)element, includeReferencedProjects, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return scope;
    }

    public static ICSearchScope createCFileSearchScope(IFile sourceFile, ArrayList elements) {
        CSearchScope scope = new CSearchScope();
        new HashSet(2);
        if (sourceFile != null) {
            scope.addFile(sourceFile.getFullPath(), sourceFile.getProject());
            IPath rootPath = CCorePlugin.getWorkspace().getRoot().getLocation();
            int segCount = CCorePlugin.getWorkspace().getRoot().getLocation().segmentCount();
            if (elements != null) {
                Iterator i = ((AbstractList)elements).iterator();
                while (i.hasNext()) {
                    Path tempPath = new Path((String)i.next());
                    if (rootPath.isPrefixOf((IPath)tempPath)) {
                        IFile tempFile = CCorePlugin.getWorkspace().getRoot().getFile((IPath)tempPath);
                        IPath finalPath = tempFile.getFullPath().removeFirstSegments(segCount);
                        tempFile = CCorePlugin.getWorkspace().getRoot().getFile(finalPath);
                        scope.addFile(tempFile.getFullPath(), tempFile.getProject());
                        continue;
                    }
                    scope.addFile((IPath)tempPath, null);
                }
            }
        }
        return scope;
    }

    public static ICSearchPattern createSearchPattern(String stringPattern, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, boolean isCaseSensitive) {
        int mode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        return CSearchPattern.createPattern(stringPattern, searchFor, limitTo, mode, isCaseSensitive);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(IWorkspace workspace, ICSearchPattern pattern, ICSearchScope scope, ICSearchResultCollector collector, boolean excludeLocalDeclarations) {
        AcceptMatchOperation acceptMatchOp2;
        if (VERBOSE) {
            System.out.println("Searching for " + pattern + " in " + scope);
        }
        if (pattern == null) {
            return;
        }
        collector.aboutToStart();
        ArrayList matches = new ArrayList();
        try {
            IProgressMonitor progressMonitor = collector.getProgressMonitor();
            if (progressMonitor != null) {
                progressMonitor.beginTask(Util.bind("engine.searching"), 100);
            }
            PathCollector pathCollector = new PathCollector();
            CModelManager modelManager = CModelManager.getDefault();
            IndexManager indexManager = modelManager.getIndexManager();
            SubProgressMonitor subMonitor = progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 5);
            indexManager.performConcurrentJob(new PatternSearchJob((CSearchPattern)pattern, scope, pathCollector, indexManager), 3, (IProgressMonitor)subMonitor, null);
            subMonitor = progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 95);
            MatchLocator matchLocator = new MatchLocator(pattern, collector, scope, (IProgressMonitor)subMonitor);
            matchLocator.setShouldExcludeLocalDeclarations(excludeLocalDeclarations);
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            matchLocator.locateMatches(pathCollector.getPaths(), workspace, this.workingCopies, matches);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            AcceptMatchOperation acceptMatchOp2 = new AcceptMatchOperation(collector, matches);
            try {
                CCorePlugin.getWorkspace().run((IWorkspaceRunnable)acceptMatchOp2, null);
                throw throwable;
            }
            catch (CoreException coreException) {}
            throw throwable;
        }
        {
            Object var13_15 = null;
            acceptMatchOp2 = new AcceptMatchOperation(collector, matches);
        }
        try {}
        catch (CoreException coreException) {
            return;
        }
        CCorePlugin.getWorkspace().run((IWorkspaceRunnable)acceptMatchOp2, null);
    }
}

