/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.WorkingCopyInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkingCopy
extends TranslationUnit
implements IWorkingCopy {
    protected IBufferFactory bufferFactory;
    protected int useCount = 1;

    public WorkingCopy(ICElement parent, IFile file, IBufferFactory bufferFactory) {
        super(parent, file);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager() : bufferFactory;
    }

    public WorkingCopy(ICElement parent, IPath path, IBufferFactory bufferFactory) {
        super(parent, path);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager() : bufferFactory;
    }

    public void commit(boolean force, IProgressMonitor monitor) throws CModelException {
        ITranslationUnit original = this.getOriginalElement();
        if (original.exists()) {
            CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
            this.runOperation(op, monitor);
        } else {
            String contents = this.getSource();
            if (contents == null) {
                return;
            }
            try {
                byte[] bytes = contents.getBytes();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                IFile originalRes = (IFile)original.getResource();
                if (originalRes.exists()) {
                    originalRes.setContents((InputStream)stream, force ? 3 : 2, null);
                } else {
                    originalRes.create((InputStream)stream, force, monitor);
                }
            }
            catch (CoreException e) {
                throw new CModelException(e);
            }
        }
    }

    protected CElementInfo createElementInfo() {
        return new WorkingCopyInfo(this);
    }

    public void destroy() {
        if (--this.useCount > 0) {
            return;
        }
        try {
            this.close();
            ITranslationUnit originalElement = this.getOriginalElement();
            if (!this.getParent().exists()) {
                ((TranslationUnit)originalElement).close();
            }
            CModelManager manager = CModelManager.getDefault();
            Map sharedWorkingCopies = manager.sharedWorkingCopies;
            Map perFactoryWorkingCopies = (Map)sharedWorkingCopies.get(this.bufferFactory);
            if (perFactoryWorkingCopies != null) {
                perFactoryWorkingCopies.remove(originalElement);
            }
        }
        catch (CModelException cModelException) {}
    }

    public boolean exists() {
        return this.useCount != 0;
    }

    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public ITranslationUnit getOriginalElement() {
        return new TranslationUnit(this.getParent(), this.getFile());
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return this;
    }

    public IWorkingCopy getWorkingCopy() {
        return this;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) {
        return this;
    }

    public boolean isBasedOn(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        return ((TranslationUnitInfo)this.getElementInfo()).fTimestamp == ((IFile)resource).getModificationStamp();
    }

    public boolean isWorkingCopy() {
        return true;
    }

    public void open(IProgressMonitor pm) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(pm);
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IBuffer originalBuffer;
            block8: {
                ITranslationUnit original = this.getOriginalElement();
                originalBuffer = null;
                try {
                    originalBuffer = original.getBuffer();
                }
                catch (CModelException e) {
                    if (e.getCModelStatus().doesNotExist()) break block8;
                    throw e;
                }
            }
            if (originalBuffer != null) {
                char[] originalContents = originalBuffer.getCharacters();
                if (originalContents != null) {
                    buffer.setContents((char[])originalContents.clone());
                }
            } else {
                buffer.setContents(new char[0]);
            }
        }
        this.getBufferManager().addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public IMarker[] reconcile() throws CModelException {
        this.reconcile(false, null);
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 143->146)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void restore() throws CModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        TranslationUnit original = (TranslationUnit)this.getOriginalElement();
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        buffer.setContents(original.getContents());
        this.updateTimeStamp(original);
        this.makeConsistent(null);
    }

    public void save(IProgressMonitor pm, boolean force) throws CModelException {
        if (this.isReadOnly()) {
            throw new CModelException(new CModelStatus(976, this));
        }
        this.reconcile();
    }

    protected void updateTimeStamp(TranslationUnit original) throws CModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new CModelException(new CModelStatus(995));
        }
        ((TranslationUnitInfo)this.getElementInfo()).fTimestamp = timeStamp;
    }
}

