/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.ArgumentObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIPType;
import org.eclipse.cdt.debug.mi.core.command.MIStackListArguments;
import org.eclipse.cdt.debug.mi.core.command.MIStackListLocals;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIPTypeInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIStackListLocalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class VariableManager
extends SessionObject
implements ICDIVariableManager {
    int MAX_STACK_DEPTH = 200;
    List variableList;
    boolean autoupdate = true;
    MIVarChange[] noChanges = new MIVarChange[0];

    public VariableManager(Session session) {
        super(session);
        this.variableList = Collections.synchronizedList(new ArrayList());
    }

    public Variable getVariable(String varName) {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getMIVar().getVarName().equals(varName)) {
                return vars[i];
            }
            Variable v = vars[i].getChild(varName);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    Variable findVariable(VariableObject v) throws CDIException {
        ICDIStackFrame stack = v.getStackFrame();
        String name = v.getName();
        int position = v.getPosition();
        int depth = v.getStackDepth();
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getName().equals(name) && vars[i].getCastingArrayStart() == v.getCastingArrayStart() && vars[i].getCastingArrayEnd() == v.getCastingArrayEnd() && (vars[i].getCastingType() == null && v.getCastingType() == null || vars[i].getCastingType() != null && v.getCastingType() != null && vars[i].getCastingType().equals(v.getCastingType()))) {
                ICDIStackFrame frame = vars[i].getStackFrame();
                if (stack == null && frame == null) {
                    return vars[i];
                }
                if (frame != null && stack != null && frame.equals(stack) && vars[i].getPosition() == position && vars[i].getStackDepth() == depth) {
                    return vars[i];
                }
            }
            ++i;
        }
        return null;
    }

    Variable[] getVariables() {
        return this.variableList.toArray(new Variable[0]);
    }

    public void checkType(String type) throws CDIException {
        block4: {
            if (type != null && type.length() > 0) {
                try {
                    MISession mi = ((Session)this.getSession()).getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    MIPType ptype = factory.createMIPType(type);
                    mi.postCommand(ptype);
                    MIPTypeInfo info = ptype.getMIPtypeInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    break block4;
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
            }
            throw new CDIException("Unknown type");
        }
    }

    void removeMIVar(MIVar miVar) throws CDIException {
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            mi.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public void removeVariable(String varName) throws CDIException {
        Variable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].getMIVar().getVarName().equals(varName)) {
                this.variableList.remove(vars[i]);
                this.removeMIVar(vars[i].getMIVar());
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public ICDIArgument createArgument(ICDIArgumentObject a) throws CDIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 242->245)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIArgumentObject[] getArgumentObjects(ICDIStackFrame frame) throws CDIException {
        ArrayList<ArgumentObject> argObjects = new ArrayList<ArgumentObject>();
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        ICDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        frame.getThread().setCurrentStackFrame(frame, false);
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                int depth = frame.getThread().getStackFrameCount();
                int level = frame.getLevel();
                int miLevel = depth - level;
                MIStackListArguments listArgs = factory.createMIStackListArguments(false, miLevel, miLevel);
                MIArg[] args = null;
                mi.postCommand(listArgs);
                MIStackListArgumentsInfo info = listArgs.getMIStackListArgumentsInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                MIFrame[] miFrames = info.getMIFrames();
                if (miFrames != null && miFrames.length == 1) {
                    args = miFrames[0].getArgs();
                }
                if (args != null) {
                    ICDITarget tgt = frame.getThread().getTarget();
                    int i = 0;
                    while (i < args.length) {
                        ArgumentObject arg = new ArgumentObject(tgt, args[i].getName(), frame, args.length - i, level);
                        argObjects.add(arg);
                        ++i;
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            currentThread.setCurrentStackFrame(currentFrame);
            throw throwable;
        }
        {
            Object var19_22 = null;
        }
        currentThread.setCurrentStackFrame(currentFrame);
        return argObjects.toArray(new ICDIArgumentObject[0]);
    }

    public ICDIVariableObject getGlobalVariableObject(String filename, String function, String name) throws CDIException {
        if (filename == null) {
            filename = new String();
        }
        if (function == null) {
            function = new String();
        }
        if (name == null) {
            name = new String();
        }
        StringBuffer buffer = new StringBuffer();
        if (filename.length() > 0) {
            buffer.append('\'').append(filename).append('\'').append("::");
        }
        if (function.length() > 0) {
            buffer.append(function).append("::");
        }
        buffer.append(name);
        ICDITarget target = this.getSession().getCurrentTarget();
        return new VariableObject(target, buffer.toString(), null, 0, 0);
    }

    public ICDIVariableObject getVariableObjectAsArray(ICDIVariableObject object, int start, int length) throws CDIException {
        VariableObject obj = null;
        if (object instanceof VariableObject) {
            obj = (VariableObject)object;
        }
        if (obj != null) {
            VariableObject vo = new VariableObject(obj.getTarget(), obj.getName(), obj.getFullName(), obj.getStackFrame(), obj.getPosition(), obj.getStackDepth());
            vo.setCastingArrayStart(obj.getCastingArrayStart() + start);
            vo.setCastingArrayEnd(length);
            return vo;
        }
        throw new CDIException("Unknown variable object");
    }

    public ICDIVariableObject getVariableObjectAsType(ICDIVariableObject object, String type) throws CDIException {
        VariableObject obj = null;
        if (object instanceof VariableObject) {
            obj = (VariableObject)object;
        }
        if (obj != null) {
            this.checkType(type);
            VariableObject vo = new VariableObject(obj.getTarget(), obj.getName(), obj.getFullName(), obj.getStackFrame(), obj.getPosition(), obj.getStackDepth());
            String casting = obj.getCastingType();
            if (casting != null && casting.length() > 0) {
                type = "(" + type + ")" + "(" + casting + " )";
            }
            vo.setCastingType(type);
            return vo;
        }
        throw new CDIException("Unknown variable object");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIVariableObject[] getLocalVariableObjects(ICDIStackFrame frame) throws CDIException {
        ArrayList<VariableObject> varObjects = new ArrayList<VariableObject>();
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIThread currentThread = currentTarget.getCurrentThread();
        ICDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        frame.getThread().setCurrentStackFrame(frame, false);
        try {
            try {
                MISession mi = session.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                int level = frame.getLevel();
                MIArg[] args = null;
                MIStackListLocals locals = factory.createMIStackListLocals(false);
                mi.postCommand(locals);
                MIStackListLocalsInfo info = locals.getMIStackListLocalsInfo();
                if (info == null) {
                    throw new CDIException("No answer");
                }
                args = info.getLocals();
                if (args != null) {
                    ICDITarget tgt = frame.getThread().getTarget();
                    int i = 0;
                    while (i < args.length) {
                        VariableObject varObj = new VariableObject(tgt, args[i].getName(), frame, args.length - i, level);
                        varObjects.add(varObj);
                        ++i;
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            currentThread.setCurrentStackFrame(currentFrame, false);
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        currentThread.setCurrentStackFrame(currentFrame, false);
        return varObjects.toArray(new ICDIVariableObject[0]);
    }

    public ICDIVariableObject[] getVariableObjects(ICDIStackFrame frame) throws CDIException {
        ICDIVariableObject[] locals = this.getLocalVariableObjects(frame);
        ICDIArgumentObject[] args = this.getArgumentObjects(frame);
        ICDIVariableObject[] vars = new ICDIVariableObject[locals.length + args.length];
        System.arraycopy(locals, 0, vars, 0, locals.length);
        System.arraycopy(args, 0, vars, locals.length, args.length);
        return vars;
    }

    /*
     * Exception decompiling
     */
    public ICDIVariable createVariable(ICDIVariableObject v) throws CDIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 219->222)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void destroyVariable(ICDIVariable var) throws CDIException {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            MIVarDeletedEvent del = new MIVarDeletedEvent(variable.getMIVar().getVarName());
            Session session = (Session)this.getSession();
            MISession mi = session.getMISession();
            mi.fireEvent(del);
        }
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean update) {
        this.autoupdate = update;
    }

    public void update() throws CDIException {
        ICDIThread currentThread;
        int high = 0;
        int low = 0;
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>();
        Session session = (Session)this.getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        Variable[] vars = this.getVariables();
        ICDITarget currentTarget = session.getCurrentTarget();
        ICDIStackFrame[] frames = null;
        ICDIStackFrame currentStack = null;
        if (currentTarget != null && (currentThread = currentTarget.getCurrentThread()) != null) {
            currentStack = currentThread.getCurrentStackFrame();
            if (currentStack != null) {
                high = currentStack.getLevel();
            }
            if (high > 0) {
                --high;
            }
            if ((low = high - this.MAX_STACK_DEPTH) < 0) {
                low = 0;
            }
            frames = currentThread.getStackFrames(low, high);
        }
        int i = 0;
        while (i < vars.length) {
            Variable variable = vars[i];
            if (this.isVariableNeedsToBeUpdate(variable, currentStack, frames, low)) {
                String varName = variable.getMIVar().getVarName();
                MIVarChange[] changes = this.noChanges;
                MIVarUpdate update = factory.createMIVarUpdate(varName);
                try {
                    mi.postCommand(update);
                    MIVarUpdateInfo info = update.getMIVarUpdateInfo();
                    if (info == null) {
                        throw new CDIException("No answer");
                    }
                    changes = info.getMIVarChanges();
                }
                catch (MIException mIException) {
                    eventList.add(new MIVarDeletedEvent(varName));
                }
                int j = 0;
                while (j < changes.length) {
                    String n = changes[j].getVarName();
                    if (changes[j].isInScope()) {
                        eventList.add(new MIVarChangedEvent(n));
                    } else {
                        eventList.add(new MIVarDeletedEvent(n));
                    }
                    ++j;
                }
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    boolean isVariableNeedsToBeUpdate(Variable variable, ICDIStackFrame current, ICDIStackFrame[] frames, int low) throws CDIException {
        ICDIStackFrame varStack = variable.getStackFrame();
        boolean inScope = false;
        if (current == null || frames == null) {
            return false;
        }
        if (varStack == null) {
            return true;
        }
        if (varStack.equals(current)) {
            return true;
        }
        if (varStack.getLevel() >= low) {
            int i = 0;
            while (i < frames.length) {
                if (varStack.equals(frames[i])) {
                    inScope = true;
                }
                ++i;
            }
        } else {
            inScope = true;
        }
        return !inScope;
    }
}

