/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.StandardCElementLabelProvider;
import org.eclipse.cdt.internal.ui.cview.CLibFilter;
import org.eclipse.cdt.internal.ui.cview.CPatternFilter;
import org.eclipse.cdt.internal.ui.cview.CViewDropAdapter;
import org.eclipse.cdt.internal.ui.cview.CViewFrameSource;
import org.eclipse.cdt.internal.ui.cview.CViewSorter;
import org.eclipse.cdt.internal.ui.cview.CollapseAllAction;
import org.eclipse.cdt.internal.ui.cview.FilterSelectionAction;
import org.eclipse.cdt.internal.ui.cview.ShowLibrariesAction;
import org.eclipse.cdt.internal.ui.drag.DelegatingDragAdapter;
import org.eclipse.cdt.internal.ui.drag.FileTransferDragAdapter;
import org.eclipse.cdt.internal.ui.drag.LocalSelectionTransferDragAdapter;
import org.eclipse.cdt.internal.ui.drag.ResourceTransferDragAdapter;
import org.eclipse.cdt.internal.ui.drag.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.editor.FileSearchAction;
import org.eclipse.cdt.internal.ui.editor.FileSearchActionInWorkingSet;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.SearchDialogAction;
import org.eclipse.cdt.internal.ui.preferences.CPluginPreferencePage;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CLocalSelectionTransfer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.OpenSystemEditorAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.UpAction;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class CView
extends ViewPart
implements IMenuListener,
ISetSelectionTarget,
IPropertyChangeListener,
IShowInTarget {
    ProblemTreeViewer viewer;
    IMemento memento;
    AddBookmarkAction addBookmarkAction;
    CopyResourceAction copyResourceAction;
    DeleteResourceAction deleteResourceAction;
    OpenFileAction openFileAction;
    OpenSystemEditorAction openSystemEditorAction;
    PropertyDialogAction propertyDialogAction;
    RefreshAction refreshAction;
    RenameResourceAction renameResourceAction;
    MoveResourceAction moveResourceAction;
    CloseResourceAction closeProjectAction;
    OpenResourceAction openProjectAction;
    BuildAction buildAction;
    BuildAction rebuildAction;
    OpenIncludeAction openIncludeAction;
    BackAction backAction;
    ForwardAction forwardAction;
    GoIntoAction goIntoAction;
    UpAction upAction;
    WorkingSetFilterActionGroup wsFilterActionGroup;
    FrameList frameList;
    CViewFrameSource frameSource;
    CPatternFilter patternFilter = new CPatternFilter();
    FilterSelectionAction patternFilterAction;
    CLibFilter clibFilter = new CLibFilter();
    ShowLibrariesAction clibFilterAction;
    ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    ActionContributionItem[] adjustWorkingSetContributions = new ActionContributionItem[5];
    CollapseAllAction collapseAllAction;
    FileSearchAction fFileSearchAction;
    FileSearchActionInWorkingSet fFileSearchActionInWorkingSet;
    SearchDialogAction fSearchDialogAction;
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_FILTERS = "filters";
    static final String TAG_FILTER = "filter";
    static final String TAG_SHOWLIBRARIES = "showLibraries";
    static final String TAG_WORKINGSET = "workingSet";
    final String WORKING_GROUP_MARKER = "workingSetGroup";
    final String WORKING_GROUP_MARKER_END = "end-workingSetGroup";
    final String BUILD_GROUP_MARKER = "buildGroup";
    final String BUILD_GROUP_MARKER_END = "end-buildGroup";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

        private void doViewerUpdate() {
            CView.this.viewer.getControl().setRedraw(false);
            CView.this.viewer.refresh();
            CView.this.viewer.getControl().setRedraw(true);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getProperty();
            if (prop == null) {
                return;
            }
            if (prop.equals("changeWorkingSet")) {
                CView.this.workingSetFilter.setWorkingSet((IWorkingSet)ev.getNewValue());
                this.doViewerUpdate();
            } else if (prop.equals("workingSetContentChange")) {
                if (ev.getOldValue() instanceof IWorkingSet && CView.this.workingSetFilter.getWorkingSet() != null && CView.this.workingSetFilter.getWorkingSet().equals(ev.getOldValue())) {
                    this.doViewerUpdate();
                }
            } else if (prop.equals("workingSetRemove") && ev.getOldValue() instanceof IWorkingSet && CView.this.workingSetFilter.getWorkingSet() != null && CView.this.workingSetFilter.getWorkingSet().equals(ev.getOldValue())) {
                CView.this.workingSetFilter.setWorkingSet(null);
                this.doViewerUpdate();
            }
        }
    };
    private ITreeViewerListener expansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Control ctrl;
            Object element = event.getElement();
            if (element instanceof IParent && (ctrl = CView.this.viewer.getControl()) != null && !ctrl.isDisposed()) {
                ctrl.getDisplay().asyncExec(new Runnable(this, element){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ Object val$element;
                    {
                        this.this$1 = var1_1;
                        this.val$element = object;
                    }

                    public void run() {
                        Control ctrl = 3.access$0(this.this$1).viewer.getControl();
                        if (ctrl != null && !ctrl.isDisposed()) {
                            3.access$0(this.this$1).viewer.expandToLevel(this.val$element, 1);
                        }
                    }
                });
            }
        }

        static /* synthetic */ CView access$0(3 var0) {
            return var0.CView.this;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void selectReveal(ISelection selection) {
        IStructuredSelection ssel = this.convertSelectionToCElement(selection);
        if (!ssel.isEmpty()) {
            this.getResourceViewer().setSelection((ISelection)ssel, true);
        }
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        IAdaptable element = (IAdaptable)s.getFirstElement();
        IEditorPart part = null;
        try {
            part = EditorUtility.openInEditor(element);
            if (part != null) {
                IWorkbenchPage page = this.getSite().getPage();
                page.bringToTop((IWorkbenchPart)part);
                if (element instanceof ISourceReference) {
                    EditorUtility.revealInEditor(part, (ICElement)element);
                }
            }
        }
        catch (Exception exception) {}
        if (part == null && this.viewer.isExpandable(element)) {
            this.viewer.setExpandedState(element, !this.viewer.getExpandedState(element));
        }
    }

    void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.deleteResourceAction.isEnabled()) {
            IStructuredSelection isel = this.deleteResourceAction.getStructuredSelection();
            Object[] array = isel.toArray();
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof IBinaryContainer || array[i] instanceof IArchiveContainer) {
                    return;
                }
                ++i;
            }
            this.deleteResourceAction.run();
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    void initFrameList() {
        this.frameSource = new CViewFrameSource(this);
        this.frameList = new FrameList((IFrameSource)this.frameSource);
        this.frameSource.connectTo(this.frameList);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jface.viewers.ISelectionProvider;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.viewer;
        }
        return super.getAdapter(key);
    }

    void initDragAndDrop() {
        int ops = 3;
        Transfer[] dragTransfers = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), CLocalSelectionTransfer.getInstance(), PluginTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new ResourceTransferDragAdapter((ISelectionProvider)this.viewer), new LocalSelectionTransferDragAdapter((ISelectionProvider)this.viewer), new FileTransferDragAdapter((ISelectionProvider)this.viewer)};
        this.viewer.addDragSupport(ops, dragTransfers, new DelegatingDragAdapter((ISelectionProvider)this.viewer, dragListeners));
        Transfer[] dropTransfers = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), LocalSelectionTransfer.getInstance(), PluginTransfer.getInstance()};
        this.viewer.addDropSupport(ops, dropTransfers, (DropTargetListener)new CViewDropAdapter((StructuredViewer)this.viewer));
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(TAG_SHOWLIBRARIES, true);
    }

    void initFilterFromPreferences() {
        CUIPlugin plugin = CUIPlugin.getDefault();
        boolean show = plugin.getPreferenceStore().getBoolean(TAG_SHOWLIBRARIES);
        this.getLibraryFilter().setShowLibraries(show);
    }

    void initRefreshKey() {
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    CView.this.refreshAction.selectionChanged((IStructuredSelection)CView.this.viewer.getSelection());
                    if (CView.this.refreshAction.isEnabled()) {
                        CView.this.refreshAction.run();
                    }
                }
            }
        });
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(sel);
        this.updateActions(sel);
        this.updateGlobalActions(sel);
        this.goIntoAction.update();
        this.linkToEditor(sel);
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.viewer.setUseHashlookup(true);
        CElementContentProvider provider = this.createContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.setLabelDecorator(PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        CUIPlugin.getDefault().getProblemMarkerManager().addListener(this.viewer);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.initFrameList();
        this.initRefreshKey();
        this.updateTitle();
        this.initDragAndDrop();
        this.viewer.addFilter(this.patternFilter);
        this.viewer.addFilter((ViewerFilter)this.workingSetFilter);
        this.viewer.setSorter(new CViewSorter());
        if (this.memento != null) {
            this.restoreFilters();
        } else {
            this.initFilterFromPreferences();
        }
        this.viewer.setInput(CoreModel.getDefault().getCModel());
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        control.setMenu(menu);
        this.makeActions();
        IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        wsmanager.addPropertyChangeListener(this.workingSetListener);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CView.this.handleDoubleClick(event);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CView.this.handleSelectionChanged(event);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CView.this.handleKeyPressed(e);
            }
        });
        this.viewer.addTreeListener(this.expansionListener);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        this.fillActionBars();
    }

    protected ProblemTreeViewer createViewer(Composite parent) {
        return new ProblemTreeViewer(parent, 770);
    }

    protected CElementContentProvider createContentProvider() {
        boolean showCUChildren = CPluginPreferencePage.showCompilationUnitChildren();
        return new CElementContentProvider(showCUChildren, true);
    }

    protected StandardCElementLabelProvider createLabelProvider() {
        return new StandardCElementLabelProvider();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.viewer != null) {
            this.viewer.removeTreeListener(this.expansionListener);
            CUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.viewer);
        }
        IWorkspace workspace = CUIPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.closeProjectAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.openProjectAction);
        IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
        wsmanager.removePropertyChangeListener(this.workingSetListener);
        super.dispose();
    }

    void editorActivated(IEditorPart editor) {
        IFileEditorInput fileInput;
        IFile file;
        CoreModel factory;
        ICElement celement;
        if (!CPluginPreferencePage.isLinkToEditor()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (celement = (factory = CoreModel.getDefault()).create(file = (fileInput = (IFileEditorInput)input).getFile())) != null) {
            StructuredSelection newSelection = new StructuredSelection((Object)celement);
            if (!this.viewer.getSelection().equals(newSelection)) {
                this.viewer.setSelection((ISelection)newSelection);
            }
        }
    }

    CLibFilter getLibraryFilter() {
        return this.clibFilter;
    }

    CPatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    void makeActions() {
        Shell shell = this.getViewSite().getShell();
        this.openIncludeAction = new OpenIncludeAction((ISelectionProvider)this.viewer);
        this.openFileAction = new OpenFileAction(this.getSite().getPage());
        this.openSystemEditorAction = new OpenSystemEditorAction(this.getSite().getPage());
        this.refreshAction = new RefreshAction(shell);
        this.buildAction = new BuildAction(shell, 10);
        this.rebuildAction = new BuildAction(shell, 6);
        this.moveResourceAction = new MoveResourceAction(shell);
        this.copyResourceAction = new CopyResourceAction(shell);
        this.renameResourceAction = new RenameResourceAction(shell, this.viewer.getTree());
        this.deleteResourceAction = new DeleteResourceAction(shell);
        IWorkspace workspace = CUIPlugin.getWorkspace();
        this.openProjectAction = new OpenResourceAction(shell);
        workspace.addResourceChangeListener((IResourceChangeListener)this.openProjectAction, 1);
        this.closeProjectAction = new CloseResourceAction(shell);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeProjectAction, 1);
        this.patternFilterAction = new FilterSelectionAction(shell, this, "Filters...");
        this.clibFilterAction = new ShowLibrariesAction(shell, this, "Show Referenced Libs");
        this.wsFilterActionGroup = new WorkingSetFilterActionGroup(this.getViewSite().getShell(), this.workingSetListener);
        this.goIntoAction = new GoIntoAction(this.frameList);
        this.backAction = new BackAction(this.frameList);
        this.forwardAction = new ForwardAction(this.frameList);
        this.upAction = new UpAction(this.frameList);
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                CView.this.viewer.addSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return CView.this.convertSelection(CView.this.viewer.getSelection());
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                CView.this.viewer.removeSelectionChangedListener(listener);
            }

            public void setSelection(ISelection selection) {
                CView.this.viewer.setSelection(selection);
            }
        });
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("delete", (IAction)this.deleteResourceAction);
        actionBars.setGlobalActionHandler("bookmark", (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler("refresh", (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler("buildProject", (IAction)this.buildAction);
        actionBars.setGlobalActionHandler("rebuildProject", (IAction)this.rebuildAction);
        actionBars.setGlobalActionHandler("openProject", (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler("closeProject", (IAction)this.closeProjectAction);
        this.collapseAllAction = new CollapseAllAction(this);
        this.fFileSearchAction = new FileSearchAction((ISelectionProvider)this.viewer);
        this.fFileSearchActionInWorkingSet = new FileSearchActionInWorkingSet((ISelectionProvider)this.viewer);
        this.fSearchDialogAction = new SearchDialogAction((ISelectionProvider)this.viewer, this.getViewSite().getWorkbenchWindow());
    }

    void updateActions(IStructuredSelection selection) {
        this.copyResourceAction.selectionChanged(selection);
        this.refreshAction.selectionChanged(selection);
        this.moveResourceAction.selectionChanged(selection);
        this.openFileAction.selectionChanged(selection);
        this.openSystemEditorAction.selectionChanged(selection);
        this.propertyDialogAction.selectionChanged(selection);
        this.renameResourceAction.selectionChanged(selection);
    }

    void updateGlobalActions(IStructuredSelection selection) {
        this.deleteResourceAction.selectionChanged(selection);
        this.addBookmarkAction.selectionChanged(selection);
        this.copyResourceAction.selectionChanged(selection);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("copy", (IAction)this.copyResourceAction);
        actionBars.updateActionBars();
        this.renameResourceAction.selectionChanged(selection);
        this.refreshAction.selectionChanged(selection);
        this.buildAction.selectionChanged(selection);
        this.rebuildAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
    }

    IStructuredSelection convertSelection(ISelection s) {
        ArrayList<IResource> converted = new ArrayList<IResource>();
        if (s instanceof StructuredSelection) {
            Object[] elements = ((StructuredSelection)s).toArray();
            int i = 0;
            while (i < elements.length) {
                Object e = elements[i];
                if (e instanceof IAdaptable) {
                    IResource r;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((r = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        converted.add(r);
                    }
                }
                ++i;
            }
        }
        return new StructuredSelection(converted.toArray());
    }

    IStructuredSelection convertSelectionToCElement(ISelection s) {
        ArrayList<ICElement> converted = new ArrayList<ICElement>();
        if (s instanceof StructuredSelection) {
            Object[] elements = ((StructuredSelection)s).toArray();
            int i = 0;
            while (i < elements.length) {
                Object e = elements[i];
                if (e instanceof IAdaptable) {
                    ICElement c;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[Lorg.eclipse.cdt.core.model.ICElement;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((c = (ICElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                        converted.add(c);
                    }
                }
                ++i;
            }
        }
        return new StructuredSelection(converted.toArray());
    }

    public void menuAboutToShow(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            new NewWizardMenu(menu, this.getSite().getWorkbenchWindow(), false);
            menu.add((IContributionItem)new Separator("additions"));
            menu.add((IContributionItem)new Separator("additions-end"));
            return;
        }
        this.updateActions(this.convertSelection((ISelection)selection));
        this.addNewMenu(menu, selection);
        menu.add((IContributionItem)new Separator());
        this.addOpenMenu(menu, selection);
        menu.add((IContributionItem)new Separator());
        this.addBuildMenu(menu, selection);
        menu.add((IContributionItem)new Separator());
        this.addRefreshMenu(menu, selection);
        menu.add((IContributionItem)new Separator());
        this.addIOMenu(menu, selection);
        menu.add((IContributionItem)new Separator());
        this.addBookMarkMenu(menu, selection);
        menu.add((IContributionItem)new Separator());
        this.addSearchMenu(menu, selection);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        this.addPropertyMenu(menu, selection);
    }

    void addNewMenu(IMenuManager menu, IStructuredSelection selection) {
        MenuManager newMenu = new MenuManager("New");
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IResource resource = (IResource)element.getAdapter((Class)clazz);
        newMenu.add((IAction)this.goIntoAction);
        new NewWizardMenu((IMenuManager)newMenu, this.getSite().getWorkbenchWindow(), false);
        menu.add((IContributionItem)newMenu);
        if (resource == null) {
            return;
        }
        menu.add((IContributionItem)new Separator());
        if (selection.size() == 1 && resource instanceof IContainer) {
            menu.add((IAction)this.goIntoAction);
        }
        MenuManager gotoMenu = new MenuManager("GoTo");
        menu.add((IContributionItem)gotoMenu);
        if (this.viewer.isExpandable(element)) {
            gotoMenu.add((IAction)this.backAction);
            gotoMenu.add((IAction)this.forwardAction);
            gotoMenu.add((IAction)this.upAction);
        }
    }

    void addOpenMenu(IMenuManager menu, IStructuredSelection selection) {
        IResource resource;
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (resource instanceof IFile) {
            menu.add((IAction)this.openFileAction);
        }
        this.fillOpenWithMenu(menu, selection);
        this.fillOpenToMenu(menu, selection);
    }

    void addBuildMenu(IMenuManager menu, IStructuredSelection selection) {
        IResource resource;
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
            return;
        }
        menu.add((IContributionItem)new GroupMarker("buildGroup"));
        if (resource instanceof IProject && this.hasBuilder((IProject)resource)) {
            this.buildAction.selectionChanged(selection);
            menu.add((IAction)this.buildAction);
            this.rebuildAction.selectionChanged(selection);
            menu.add((IAction)this.rebuildAction);
        }
        menu.add((IContributionItem)new GroupMarker("end-buildGroup"));
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    void addRefreshMenu(IMenuManager menu, IStructuredSelection selection) {
        menu.add((IAction)this.refreshAction);
    }

    void addIOMenu(IMenuManager menu, IStructuredSelection selection) {
        IResource resource;
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
            return;
        }
        menu.add((IContributionItem)new Separator());
        if (resource instanceof IProject) {
            menu.add((IAction)this.closeProjectAction);
        }
        if (resource instanceof IFile || resource instanceof IFolder) {
            menu.add((IAction)this.copyResourceAction);
            menu.add((IAction)this.moveResourceAction);
        }
        if (!(element instanceof IArchiveContainer) && !(element instanceof IBinaryContainer)) {
            menu.add((IAction)this.renameResourceAction);
            menu.add((IAction)this.deleteResourceAction);
        }
    }

    void addBookMarkMenu(IMenuManager menu, IStructuredSelection selection) {
        IResource resource;
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (resource instanceof IFile) {
            menu.add((IAction)this.addBookmarkAction);
        }
    }

    void addPropertyMenu(IMenuManager menu, IStructuredSelection selection) {
        this.propertyDialogAction.selectionChanged(this.convertSelection((ISelection)selection));
        if (this.propertyDialogAction.isApplicableForSelection()) {
            menu.add((IAction)this.propertyDialogAction);
        }
    }

    void fillOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        IResource resource;
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (selection.size() != 1) {
            return;
        }
        if (!(resource instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager("Open With");
        submenu.add((IContributionItem)new OpenWithMenu(this.getSite().getPage(), (IAdaptable)((IFile)resource)));
        menu.add((IContributionItem)submenu);
    }

    void fillOpenToMenu(IMenuManager menu, IStructuredSelection selection) {
        IResource resource;
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (selection.size() != 1) {
            return;
        }
        if (!(resource instanceof IContainer)) {
            return;
        }
        menu.add((IAction)new OpenInNewWindowAction(this.getSite().getWorkbenchWindow(), (IAdaptable)resource));
    }

    String getToolTipText(Object element) {
        if (element instanceof IResource) {
            IPath path = ((IResource)element).getFullPath();
            if (path.isRoot()) {
                return "CVIEW";
            }
            return path.makeRelative().toString();
        }
        return ((ILabelProvider)this.viewer.getLabelProvider()).getText(element);
    }

    String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof IResource) {
                return ((IResource)o).getFullPath().makeRelative().toString();
            }
            if (o instanceof ICElement) {
                IResource res;
                ICElement celement = (ICElement)o;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((res = (IResource)celement.getAdapter((Class)clazz)) != null) {
                    return res.getFullPath().toString();
                }
                if (celement.getElementType() == 30) {
                    if (celement instanceof IBinaryContainer) {
                        ICProject cproj = celement.getCProject();
                        if (cproj != null) {
                            return cproj.getPath() + " - binaries";
                        }
                    } else if (celement instanceof IArchiveContainer) {
                        ICProject cproj = celement.getCProject();
                        if (cproj != null) {
                            return cproj.getPath() + " - archives";
                        }
                    } else if (celement instanceof IBinaryModule) {
                        IBinary bin = ((IBinaryModule)celement).getBinary();
                        return bin.getPath() + ":" + celement.getElementName();
                    }
                } else if (celement.getElementType() > 60) {
                    return String.valueOf(celement.getPath().toString()) + " - [" + celement.getElementName() + "]";
                }
                return celement.getElementName();
            }
            return "ItemSelected";
        }
        if (selection.size() > 1) {
            return "StatusLine";
        }
        return "";
    }

    void updateTitle() {
        Object input = this.getViewer().getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        if (input == null || input instanceof ICModel) {
            this.setTitle(viewName);
            this.setTitleToolTip("");
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.getViewer().getLabelProvider();
            String inputText = labelProvider.getText(input);
            this.setTitle(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    TreeViewer getResourceViewer() {
        return this.viewer;
    }

    void updateStatusLine(IStructuredSelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        toolBar.add((IAction)this.upAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        actionBars.updateActionBars();
        this.wsFilterActionGroup.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.patternFilterAction);
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
        StandardCElementLabelProvider cProvider = this.createLabelProvider();
        if (decorator == null) {
            this.viewer.setLabelProvider((IBaseLabelProvider)cProvider);
        } else {
            this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)cProvider, decorator));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.viewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if (event.getProperty() == "org.eclipse.cdt.ui.editor.CUChildren") {
            boolean showCUChildren = CPluginPreferencePage.showCompilationUnitChildren();
            ((CElementContentProvider)this.viewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.viewer.refresh();
        }
    }

    void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        ITranslationUnit tu;
        if (!CPluginPreferencePage.isLinkToEditor()) {
            return;
        }
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && obj instanceof ISourceReference && (tu = ((ISourceReference)obj).getTranslationUnit()) != null && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof ICElement) {
                EditorUtility.revealInEditor(part, (ICElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public Object getViewPartInput() {
        if (this.viewer != null) {
            return this.viewer.getInput();
        }
        return null;
    }

    public void collapseAll() {
        this.viewer.getControl().setRedraw(false);
        this.viewer.collapseToLevel(this.getViewPartInput(), -1);
        this.viewer.getControl().setRedraw(true);
    }

    void restoreFilters() {
        IMemento filtersMem = this.memento.getChild(TAG_FILTERS);
        if (filtersMem != null) {
            IMemento[] children = filtersMem.getChildren(TAG_FILTER);
            String[] filters = new String[children.length];
            int i = 0;
            while (i < children.length) {
                filters[i] = children[i].getString(TAG_ELEMENT);
                ++i;
            }
            this.getPatternFilter().setPatterns(filters);
        } else {
            this.getPatternFilter().setPatterns(new String[0]);
        }
        String show = this.memento.getString(TAG_SHOWLIBRARIES);
        if (show != null) {
            this.getLibraryFilter().setShowLibraries(show.equals("true"));
        } else {
            this.initFilterFromPreferences();
        }
    }

    void restoreState(IMemento memento) {
        Tree tree;
        ScrollBar bar;
        Path path;
        ICElement element;
        String p;
        int i;
        IMemento[] elementMem;
        String wsname = memento.getString(TAG_WORKINGSET);
        if (wsname != null) {
            IWorkingSetManager wsmanager = this.getViewSite().getWorkbenchWindow().getWorkbench().getWorkingSetManager();
            IWorkingSet set = wsmanager.getWorkingSet(wsname);
            this.wsFilterActionGroup.setWorkingSet(set);
        } else {
            this.wsFilterActionGroup.setWorkingSet(null);
        }
        CoreModel factory = CoreModel.getDefault();
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            ArrayList<ICElement> elements = new ArrayList<ICElement>();
            elementMem = childMem.getChildren(TAG_ELEMENT);
            i = 0;
            while (i < elementMem.length) {
                p = elementMem[i].getString(TAG_PATH);
                if (p != null && (element = factory.create((IPath)(path = new Path(p)))) != null) {
                    elements.add(element);
                }
                ++i;
            }
            this.viewer.setExpandedElements(elements.toArray());
        }
        if ((childMem = memento.getChild(TAG_SELECTION)) != null) {
            ArrayList<ICElement> list = new ArrayList<ICElement>();
            elementMem = childMem.getChildren(TAG_ELEMENT);
            i = 0;
            while (i < elementMem.length) {
                p = elementMem[i].getString(TAG_PATH);
                if (p != null && (element = factory.create((IPath)(path = new Path(p)))) != null) {
                    list.add(element);
                }
                ++i;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(list));
        }
        if ((bar = (tree = this.viewer.getTree()).getVerticalBar()) != null) {
            try {
                String posStr = memento.getString(TAG_VERTICAL_POSITION);
                int position = new Integer(posStr);
                bar.setSelection(position);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                String posStr = memento.getString(TAG_HORIZONTAL_POSITION);
                int position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void saveState(IMemento memento) {
        String wsname;
        ScrollBar bar;
        Object[] elements;
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        Tree tree = this.viewer.getTree();
        Object[] expandedElements = this.viewer.getExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            int i = 0;
            while (i < expandedElements.length) {
                Object o = expandedElements[i];
                if (!(!(o instanceof IParent) || o instanceof IArchiveContainer || o instanceof IBinaryContainer || o instanceof IBinary || o instanceof IArchive)) {
                    IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                    ICElement e = (ICElement)o;
                    IResource res = e.getResource();
                    if (res != null) {
                        elementMem.putString(TAG_PATH, res.getLocation().toOSString());
                    }
                }
                ++i;
            }
        }
        if ((elements = ((IStructuredSelection)this.viewer.getSelection()).toArray()).length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < elements.length) {
                ICElement e;
                IResource r;
                if (elements[i] instanceof ICElement && (r = (e = (ICElement)elements[i]).getResource()) != null) {
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, r.getLocation().toString());
                }
                ++i;
            }
        }
        int position = (bar = tree.getVerticalBar()) != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
        String[] filters = this.getPatternFilter().getPatterns();
        if (filters.length > 0) {
            IMemento filtersMem = memento.createChild(TAG_FILTERS);
            int i = 0;
            while (i < filters.length) {
                IMemento child = filtersMem.createChild(TAG_FILTER);
                child.putString(TAG_ELEMENT, filters[i]);
                ++i;
            }
        }
        boolean showLibraries = this.getLibraryFilter().getShowLibraries();
        String show = "true";
        if (!showLibraries) {
            show = "false";
        }
        memento.putString(TAG_SHOWLIBRARIES, show);
        if (this.workingSetFilter.getWorkingSet() != null && (wsname = this.workingSetFilter.getWorkingSet().getName()) != null) {
            memento.putString(TAG_WORKINGSET, wsname);
        }
    }

    void addSearchMenu(IMenuManager menu, IStructuredSelection selection) {
        IAdaptable element = (IAdaptable)selection.getFirstElement();
        if (element instanceof TranslationUnit || element instanceof CProject) {
            return;
        }
        MenuManager search = new MenuManager("Search", "group.search");
        if (SearchDialogAction.canActionBeAdded((ISelection)selection)) {
            search.add((IAction)this.fSearchDialogAction);
        }
        if (FileSearchAction.canActionBeAdded((ISelection)selection)) {
            MenuManager fileSearch = new MenuManager("File Search");
            fileSearch.add((IAction)this.fFileSearchAction);
            fileSearch.add((IAction)this.fFileSearchActionInWorkingSet);
            search.add((IContributionItem)fileSearch);
        }
        menu.add((IContributionItem)search);
    }

    public boolean show(ShowInContext context) {
        block6: {
            try {
                IResource res;
                IEditorInput input = (IEditorInput)context.getInput();
                if (input == null) break block6;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((res = (IResource)input.getAdapter((Class)clazz)) != null) {
                    this.selectReveal((ISelection)new StructuredSelection((Object)res));
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

