/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.GDBDebugger;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.CygwinCommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CygwinGDBDebugger
extends GDBDebugger {
    static final CygwinCommandFactory commandFactory = new CygwinCommandFactory();

    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CDIException {
        try {
            List p;
            ICDISharedLibraryManager manager = session.getSharedLibraryManager();
            if (manager instanceof SharedLibraryManager) {
                SharedLibraryManager mgr = (SharedLibraryManager)manager;
                boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
                try {
                    mgr.setStopOnSolibEvents(stopOnSolibEvents);
                    if (!stopOnSolibEvents) {
                        mgr.setStopOnSolibEvents(true);
                        mgr.setDeferredBreakpoint(true);
                    }
                }
                catch (CDIException cDIException) {}
            }
            if ((p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST)).size() > 0) {
                String[] oldPaths = manager.getSharedLibraryPaths();
                String[] paths = new String[oldPaths.length + p.size()];
                System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                manager.setSharedLibraryPaths(paths);
            }
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing shared library options: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        Session session2;
        Session session = null;
        boolean failed = false;
        try {
            try {
                session = (Session)super.createLaunchSession(config, exe);
                session.getMISession().setCommandFactory(commandFactory);
                MISession mi = session.getMISession();
                try {
                    CommandFactory factory = mi.getCommandFactory();
                    MIGDBSet set = factory.createMIGDBSet(new String[]{"new-console"});
                    mi.postCommand(set);
                    MIInfo info = set.getMIInfo();
                    if (info == null) {
                        throw new MIException("No answer");
                    }
                }
                catch (MIException mIException) {}
                this.initializeLibraries(config, session);
                session2 = session;
                Object var9_11 = null;
                if (!failed) return session2;
                if (session == null) return session2;
            }
            catch (CDIException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!failed) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        Session session2;
        Session session = null;
        boolean failed = false;
        try {
            try {
                session = (Session)super.createAttachSession(config, exe, pid);
                session.getMISession().setCommandFactory(commandFactory);
                this.initializeLibraries(config, session);
                session2 = session;
                Object var7_7 = null;
                if (!failed) return session2;
                if (session == null) return session2;
            }
            catch (CDIException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!failed) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        Session session2;
        Session session = null;
        boolean failed = false;
        try {
            try {
                session = (Session)super.createCoreSession(config, exe, corefile);
                session.getMISession().setCommandFactory(commandFactory);
                this.initializeLibraries(config, session);
                session2 = session;
                Object var7_7 = null;
                if (!failed) return session2;
                if (session == null) return session2;
            }
            catch (CDIException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!failed) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }
}

