/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTArrayModifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;

public class ASTFunction
extends ASTScope
implements IASTFunction {
    private final boolean previouslyDeclared;
    private boolean hasFunctionBody = false;
    private final IASTTemplate ownerTemplate;
    private final IASTAbstractDeclaration returnType;
    private final IASTExceptionSpecification exception;
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTQualifiedNamedElement qualifiedName;
    private final List parameters;
    protected final ASTReferenceStore references;
    private final int nameEndOffset;
    private boolean hasFunctionTryBlock = false;

    public ASTFunction(IParameterizedSymbol symbol, int nameEndOffset, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, int startOffset, int nameOffset, IASTTemplate ownerTemplate, List references, boolean previouslyDeclared, boolean hasFunctionTryBlock) {
        super(symbol);
        this.parameters = parameters;
        this.nameEndOffset = nameEndOffset;
        this.returnType = returnType;
        this.exception = exception;
        this.setStartingOffset(startOffset);
        this.setNameOffset(nameOffset);
        this.setNameEndOffset(nameEndOffset);
        this.ownerTemplate = ownerTemplate;
        this.references = new ASTReferenceStore(references);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
        this.previouslyDeclared = previouslyDeclared;
        this.hasFunctionTryBlock = hasFunctionTryBlock;
    }

    public boolean isInline() {
        return this.symbol.getTypeInfo().checkBit(1024);
    }

    public boolean isFriend() {
        return this.symbol.getTypeInfo().checkBit(16384);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(128);
    }

    public String getName() {
        return this.symbol.getName();
    }

    public IASTAbstractDeclaration getReturnType() {
        return this.returnType;
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public IASTExceptionSpecification getExceptionSpec() {
        return this.exception;
    }

    public void setHasFunctionBody(boolean b) {
        this.hasFunctionBody = true;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplate;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptFunctionDeclaration(this);
        }
        catch (Exception exception) {}
        this.functionCallbacks(requestor);
    }

    protected void functionCallbacks(ISourceElementRequestor requestor) {
        this.references.processReferences(requestor);
        this.processParameterInitializersAndArrayMods(requestor);
        if (this.getReturnType() != null) {
            this.getReturnType().acceptElement(requestor);
        }
        if (this.getExceptionSpec() != null) {
            this.getExceptionSpec().acceptElement(requestor);
        }
    }

    protected void processParameterInitializersAndArrayMods(ISourceElementRequestor requestor) {
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            IASTParameterDeclaration parm = (IASTParameterDeclaration)i.next();
            if (parm.getDefaultValue() != null) {
                parm.getDefaultValue().acceptElement(requestor);
            }
            Iterator arrays = parm.getArrayModifiers();
            while (arrays.hasNext()) {
                ((IASTArrayModifier)arrays.next()).acceptElement(requestor);
            }
        }
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterFunctionBody(this);
        }
        catch (Exception exception) {}
        this.functionCallbacks(requestor);
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public IASTCodeScope getOwnerCodeScope() {
        return this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration() instanceof IASTCodeScope ? (IASTCodeScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration()) : null;
    }

    public boolean previouslyDeclared() {
        return this.previouslyDeclared;
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }

    public void setHasFunctionTryBlock(boolean b) {
        this.hasFunctionTryBlock = b;
    }

    public boolean hasFunctionTryBlock() {
        return this.hasFunctionTryBlock;
    }

    public IASTNode.LookupResult lookup(String prefix, IASTNode.LookupKind kind) {
        return null;
    }
}

