/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class BasicSearchMatch
implements IMatch,
Comparable {
    public String name = null;
    public String parentName = null;
    public String returnType;
    public IResource resource = null;
    public IPath path = null;
    public int startOffset = 0;
    public int endOffset = 0;
    public int type = 0;
    public int visibility = 0;
    boolean isConst = false;
    boolean isVolatile = false;
    boolean isStatic = false;

    public BasicSearchMatch() {
    }

    public BasicSearchMatch(BasicSearchMatch basicMatch) {
        this.name = basicMatch.name;
        this.parentName = basicMatch.parentName;
        this.returnType = basicMatch.returnType;
        this.resource = basicMatch.resource;
        this.path = basicMatch.path;
        this.startOffset = basicMatch.startOffset;
        this.endOffset = basicMatch.endOffset;
    }

    public int hashCode() {
        String hashString = "";
        hashString = String.valueOf(hashString) + this.name;
        hashString = String.valueOf(hashString) + ":" + this.parentName;
        hashString = String.valueOf(hashString) + ":" + this.returnType;
        if (this.getLocation() != null) {
            hashString = String.valueOf(hashString) + ":" + this.getLocation().toString();
        }
        hashString = String.valueOf(hashString) + ":" + this.startOffset + ":" + this.endOffset;
        hashString = String.valueOf(hashString) + ":" + this.type + ":" + this.visibility;
        return hashString.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicSearchMatch)) {
            return false;
        }
        BasicSearchMatch match = (BasicSearchMatch)obj;
        this.getLocation();
        if (this.startOffset != match.getStartOffset() || this.endOffset != match.getEndOffset()) {
            return false;
        }
        if (this.type != match.getElementType() || this.visibility != match.getVisibility()) {
            return false;
        }
        if (this.name != null && match.getName() != null ? !this.name.equals(match.getName()) : this.name != match.getName()) {
            return false;
        }
        if (this.parentName != null && match.getParentName() != null ? !this.parentName.equals(match.getParentName()) : this.parentName != match.getParentName()) {
            return false;
        }
        if (this.returnType != null && match.getReturnType() != null ? !this.returnType.equals(match.getReturnType()) : this.returnType != match.getReturnType()) {
            return false;
        }
        IPath thisPath = this.getLocation();
        IPath matchPath = match.getLocation();
        return !(thisPath != null && matchPath != null ? !thisPath.equals((Object)matchPath) : thisPath != matchPath);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BasicSearchMatch)) {
            throw new ClassCastException();
        }
        BasicSearchMatch match = (BasicSearchMatch)o;
        String str1 = this.getLocation().toString();
        String str2 = match.getLocation().toString();
        str1 = String.valueOf(str1) + " " + this.getStartOffset() + " ";
        str2 = String.valueOf(str2) + " " + match.getStartOffset() + " ";
        str1 = String.valueOf(str1) + this.getName() + " " + this.getParentName() + " " + this.getReturnType();
        str2 = String.valueOf(str2) + match.getName() + " " + match.getParentName() + " " + this.getReturnType();
        return str1.compareTo(str2);
    }

    public int getElementType() {
        return this.type;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getLocation() {
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getType() {
        return this.type;
    }

    public void setEndOffset(int i) {
        this.endOffset = i;
    }

    public void setConst(boolean b) {
        this.isConst = b;
    }

    public void setStatic(boolean b) {
        this.isStatic = b;
    }

    public void setVolatile(boolean b) {
        this.isVolatile = b;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public void setStartOffset(int i) {
        this.startOffset = i;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setVisibility(int i) {
        this.visibility = i;
    }
}

