/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CElement
extends PlatformObject
implements ICElement {
    protected int fType;
    protected ICElement fParent;
    protected String fName;
    protected int fStartPos;
    protected int fLength;
    protected int fIdStartPos;
    protected int fIdLength;
    protected int fStartLine;
    protected int fEndLine;
    protected CElement[] empty = new CElement[0];

    protected CElement(ICElement parent, String name, int type) {
        this.fParent = parent;
        this.fName = name;
        this.fType = type;
    }

    public void setElementType(int type) {
        this.fType = type;
    }

    public void setElementName(String name) {
        this.fName = name;
    }

    public void setParent(ICElement parent) {
        this.fParent = parent;
    }

    public int getElementType() {
        return this.fType;
    }

    public String getElementName() {
        return this.fName;
    }

    public ICElement getParent() {
        return this.fParent;
    }

    public IPath getPath() {
        IResource res = this.getUnderlyingResource();
        if (res != null) {
            return res.getFullPath();
        }
        return new Path(this.getElementName());
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    public boolean isReadOnly() {
        IResource r = this.getUnderlyingResource();
        if (r != null) {
            return r.isReadOnly();
        }
        return false;
    }

    public boolean isStructureKnown() throws CModelException {
        return this.getElementInfo().isStructureKnown();
    }

    public ICModel getCModel() {
        ICElement current = this;
        do {
            if (!(current instanceof ICModel)) continue;
            return (ICModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public ICProject getCProject() {
        ICElement current = this;
        do {
            if (!(current instanceof ICProject)) continue;
            return (ICProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected void addChild(ICElement e) {
    }

    public void setPos(int startPos, int length) {
        this.fStartPos = startPos;
        this.fLength = length;
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setIdPos(int startPos, int length) {
        this.fIdStartPos = startPos;
        this.fIdLength = length;
    }

    public int getIdStartPos() {
        return this.fIdStartPos;
    }

    public int getIdLength() {
        return this.fIdLength;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public void setLines(int startLine, int endLine) {
        this.fStartLine = startLine;
        this.fEndLine = endLine;
    }

    public IResource getUnderlyingResource() {
        ICElement p;
        IResource res = this.getResource();
        if (res == null && (p = this.getParent()) != null) {
            res = p.getUnderlyingResource();
        }
        return res;
    }

    public abstract IResource getResource();

    protected abstract CElementInfo createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CElement) {
            CElement other = (CElement)o;
            if (this.fName == null || other.fName == null) {
                return false;
            }
            if (this.fName.length() == 0 || other.fName.length() == 0) {
                return false;
            }
            if (this.fType != other.fType) {
                return false;
            }
            if (this.fName.equals(other.fName)) {
                if (this.fParent != null && this.fParent.equals(other.fParent)) {
                    return true;
                }
                if (this.fParent == null && other.fParent == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public CElementInfo getElementInfo() {
        try {
            CModelManager manager;
            CModelManager cModelManager = manager = CModelManager.getDefault();
            synchronized (manager) {
                Object info = manager.getInfo(this);
                if (info == null) {
                    this.openHierarchy();
                    info = manager.getInfo(this);
                    if (info == null) {
                        throw this.newNotPresentException();
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (CElementInfo)info;
            }
        }
        catch (CModelException cModelException) {
            return null;
        }
    }

    public String toString() {
        return this.getElementName();
    }

    public String toDebugString() {
        return String.valueOf(this.getElementName()) + " " + CElement.getTypeString(this.getElementType());
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 10: {
                return "CMODEL";
            }
            case 11: {
                return "CPROJECT";
            }
            case 12: {
                return "CCONTAINER";
            }
            case 60: {
                return "TRANSLATION_UNIT";
            }
            case 71: {
                return "C_FUNCTION";
            }
            case 70: {
                return "C_FUNCTION_DECLARATION";
            }
            case 74: {
                return "C_VARIABLE";
            }
            case 75: {
                return "C_VARIABLE_DECLARATION";
            }
            case 72: {
                return "C_INCLUDE";
            }
            case 77: {
                return "C_MACRO";
            }
            case 65: {
                return "C_STRUCT";
            }
            case 64: {
                return "C_CLASS";
            }
            case 66: {
                return "C_UNION";
            }
            case 69: {
                return "C_FIELD";
            }
            case 67: {
                return "C_METHOD";
            }
        }
        return "UNKNOWN";
    }

    protected void runOperation(CModelOperation operation, IProgressMonitor monitor) throws CModelException {
        CModelManager.getDefault().runOperation(operation, monitor);
    }

    public void close() throws CModelException {
        Object info = CModelManager.getDefault().peekAtInfo(this);
        if (info != null) {
            if (this instanceof IParent) {
                ICElement[] children = ((CElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    CElement child = (CElement)children[i];
                    child.close();
                    ++i;
                }
            }
            this.closing(info);
            CModelManager.getDefault().removeInfo(this);
        }
    }

    protected void closing(Object info) throws CModelException {
    }

    protected void opening(Object info) {
    }

    public IOpenable getOpenableParent() {
        if (this.fParent instanceof IOpenable) {
            return (IOpenable)((Object)this.fParent);
        }
        return null;
    }

    protected void openHierarchy() throws CModelException {
        if (this instanceof IOpenable) {
            ((Openable)this).openWhenClosed(null);
        } else {
            Openable openableParent = (Openable)this.getOpenableParent();
            if (openableParent != null) {
                CElementInfo openableParentInfo = (CElementInfo)CModelManager.getDefault().getInfo(openableParent);
                if (openableParentInfo == null) {
                    openableParent.openWhenClosed(null);
                }
                CModelManager.getDefault().putInfo(this, this.createElementInfo());
            }
        }
    }

    protected boolean isAncestorOf(ICElement e) {
        ICElement parent = e.getParent();
        while (parent != null && !parent.equals(this)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    protected CModelException newNotPresentException() {
        return new CModelException(new CModelStatus(969, this));
    }

    protected void removeInfo() {
        Object info = CModelManager.getDefault().peekAtInfo(this);
        if (info != null) {
            if (this instanceof IParent) {
                ICElement[] children = ((CElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    CElement child = (CElement)children[i];
                    child.removeInfo();
                    ++i;
                }
            }
            CModelManager.getDefault().removeInfo(this);
        }
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.fName.hashCode(), this.fParent.hashCode());
    }

    public boolean isIdentical(CElement otherElement) {
        return this.equals(otherElement);
    }
}

