/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICPathEntry;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.ACPathEntry;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CPathEntry;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.cdt.internal.core.model.LibraryReferenceArchive;
import org.eclipse.cdt.internal.core.model.LibraryReferenceShared;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SetCPathEntriesOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CProject
extends CContainer
implements ICProject {
    protected static final String[] NO_PREREQUISITES = new String[0];
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";
    static String PATH_ENTRY = "cpathentry";
    static String PATH_ENTRY_ID = "org.eclipse.cdt.core.cpathentry";
    static String ATTRIBUTE_KIND = "kind";
    static String ATTRIBUTE_PATH = "path";
    static String ATTRIBUTE_EXPORTED = "exported";
    static String ATTRIBUTE_SOURCEPATH = "sourcepath";
    static String ATTRIBUTE_ROOTPATH = "roopath";
    static String ATTRIBUTE_PREFIXMAPPING = "prefixmapping";
    static String ATTRIBUTE_EXCLUDING = "excluding";
    static String ATTRIBUTE_RECUSIVE = "recusive";
    static String ATTRIBUTE_OUTPUT = "output";
    static String ATTRIBUTE_INCLUDE = "include";
    static String ATTRIBUTE_SYSTEM = "system";
    static String ATTRIBUTE_NAME = "name";
    static String ATTRIBUTE_VALUE = "value";
    static String ATTRIBUTE_ID = "id";
    static String VALUE_TRUE = "true";

    public CProject(ICElement parent, IProject project) {
        super(parent, (IResource)project, 11);
    }

    public IBinaryContainer getBinaryContainer() {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    public IArchiveContainer getArchiveContainer() {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    public IProject getProject() {
        return this.getUnderlyingResource().getProject();
    }

    public ICElement findElement(IPath path) throws CModelException {
        ICElement celem = null;
        if (path.isAbsolute()) {
            celem = CModelManager.getDefault().create(path);
        } else {
            IProject project = this.getProject();
            if (project != null) {
                IPath p = project.getFullPath().append(path);
                celem = CModelManager.getDefault().create(p);
            }
        }
        if (celem == null) {
            CModelStatus status = new CModelStatus(979, path);
            throw new CModelException(status);
        }
        return celem;
    }

    public static boolean hasCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public ILibraryReference[] getLibraryReferences() throws CModelException {
        ArrayList<LibraryReference> list = new ArrayList<LibraryReference>(5);
        IBinaryParser binParser = null;
        try {
            binParser = CCorePlugin.getDefault().getBinaryParser(this.getProject());
        }
        catch (CoreException coreException) {}
        ICPathEntry[] entries = this.getResolvedCPathEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 1) {
                ILibraryEntry entry = (ILibraryEntry)entries[i];
                Parent lib = null;
                if (binParser != null) {
                    try {
                        IBinaryParser.IBinaryFile bin = binParser.getBinary(entry.getLibraryPath());
                        lib = bin.getType() == 8 ? new LibraryReferenceArchive((ICElement)this, entry, (IBinaryParser.IBinaryArchive)bin) : new LibraryReferenceShared((ICElement)this, entry, bin);
                    }
                    catch (IOException iOException) {
                        lib = new LibraryReference(this, entry);
                    }
                }
                if (lib != null) {
                    list.add((LibraryReference)lib);
                }
            }
            ++i;
        }
        return list.toArray(new ILibraryReference[0]);
    }

    public String[] getRequiredProjectNames() throws CModelException {
        return this.projectPrerequisites(this.getResolvedCPathEntries());
    }

    public String[] projectPrerequisites(ICPathEntry[] entries) throws CModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            if (entries[i].getEntryKind() == 2) {
                IProjectEntry entry = (IProjectEntry)entries[i];
                prerequisites.add(entry.getProjectPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size != 0) {
            String[] result = new String[size];
            prerequisites.toArray(result);
            return result;
        }
        return NO_PREREQUISITES;
    }

    public String getOption(String optionName, boolean inheritCCoreOptions) {
        if (CModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(optionName)) {
                return inheritCCoreOptions ? CCorePlugin.getOption(optionName) : null;
            }
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritCCoreOptions) {
        String propertyName;
        int i;
        HashMap options = inheritCCoreOptions ? CCorePlugin.getOptions() : new HashMap(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet optionNames = CModelManager.OptionNames;
        if (inheritCCoreOptions) {
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            i = 0;
            while (i < defaultPropertyNames.length) {
                propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName).trim());
                }
                ++i;
            }
        }
        String[] propertyNames = preferences.propertyNames();
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            if (optionNames.contains(propertyName)) {
                options.put(propertyName, preferences.getString(propertyName).trim());
            }
            ++i;
        }
        return options;
    }

    public void setOption(String optionName, String optionValue) {
        if (!CModelManager.OptionNames.contains(optionName)) {
            return;
        }
        Preferences preferences = this.getPreferences();
        preferences.setDefault(optionName, CUSTOM_DEFAULT_OPTION_VALUE);
        preferences.setValue(optionName, optionValue);
        this.savePreferences(preferences);
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            Iterator keys = newOptions.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!CModelManager.OptionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    private Preferences getPreferences() {
        Preferences preferences = new Preferences();
        Iterator iter = CModelManager.OptionNames.iterator();
        while (iter.hasNext()) {
            String qualifiedName = (String)iter.next();
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = this.resource.getPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName));
            }
            catch (CoreException coreException) {}
            if (value == null) continue;
            preferences.setValue(qualifiedName, value);
        }
        return preferences;
    }

    private void savePreferences(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        Iterator iter = CModelManager.OptionNames.iterator();
        while (iter.hasNext()) {
            String qualifiedName = (String)iter.next();
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = preferences.getString(qualifiedName);
                if (value != null && !value.equals(preferences.getDefaultString(qualifiedName))) {
                    this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), value);
                    continue;
                }
                this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void setPreferences(Preferences preferences) {
    }

    public ICPathEntry[] getResolvedCPathEntries() throws CModelException {
        return this.getRawCPathEntries();
    }

    public ICPathEntry[] getRawCPathEntries() throws CModelException {
        ArrayList<ICPathEntry> pathEntries = new ArrayList<ICPathEntry>();
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.getProject());
            Element element = cdesc.getProjectData(PATH_ENTRY_ID);
            NodeList list = element.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node childNode = list.item(i);
                if (childNode.getNodeType() == 1 && childNode.getNodeName().equals(PATH_ENTRY)) {
                    pathEntries.add(this.decodeCPathEntry((Element)childNode));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return pathEntries.toArray(new ICPathEntry[0]);
    }

    public void setRawCPathEntries(ICPathEntry[] newEntries, IProgressMonitor monitor) throws CModelException {
        try {
            SetCPathEntriesOperation op = new SetCPathEntriesOperation(this, this.getRawCPathEntries(), newEntries);
            this.runOperation(op, monitor);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    ICPathEntry decodeCPathEntry(Element element) throws CModelException {
        char[][] patterns;
        int patternCount;
        IPath projectPath = this.getProject().getFullPath();
        String kindAttr = element.getAttribute(ATTRIBUTE_KIND);
        int kind = CPathEntry.kindFromString(kindAttr);
        boolean isExported = false;
        if (element.hasAttribute(ATTRIBUTE_EXPORTED)) {
            isExported = element.getAttribute(ATTRIBUTE_EXPORTED).equals(VALUE_TRUE);
        }
        String pathAttr = element.getAttribute(ATTRIBUTE_PATH);
        Path path = new Path(pathAttr);
        if (kind != 4 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path sourceAttachmentPath = element.hasAttribute(ATTRIBUTE_SOURCEPATH) ? new Path(element.getAttribute(ATTRIBUTE_SOURCEPATH)) : null;
        Path sourceAttachmentRootPath = element.hasAttribute(ATTRIBUTE_ROOTPATH) ? new Path(element.getAttribute(ATTRIBUTE_ROOTPATH)) : null;
        Path sourceAttachmentPrefixMapping = element.hasAttribute(ATTRIBUTE_PREFIXMAPPING) ? new Path(element.getAttribute(ATTRIBUTE_PREFIXMAPPING)) : null;
        String exclusion = element.getAttribute(ATTRIBUTE_EXCLUDING);
        IPath[] exclusionPatterns = ACPathEntry.NO_EXCLUSION_PATTERNS;
        if (!exclusion.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        boolean isRecursive = false;
        if (element.hasAttribute(ATTRIBUTE_RECUSIVE)) {
            isRecursive = element.getAttribute(ATTRIBUTE_RECUSIVE).equals(VALUE_TRUE);
        }
        switch (kind) {
            case 2: {
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                return CoreModel.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IPath)sourceAttachmentPrefixMapping, isExported);
            }
            case 3: {
                IPath outputLocation = element.hasAttribute(ATTRIBUTE_OUTPUT) ? projectPath.append(element.getAttribute(ATTRIBUTE_OUTPUT)) : null;
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(this.getElementName())) {
                    return CoreModel.newSourceEntry((IPath)path, outputLocation, isRecursive, exclusionPatterns);
                }
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 5: {
                Path includePath = element.hasAttribute(ATTRIBUTE_INCLUDE) ? new Path(element.getAttribute(ATTRIBUTE_INCLUDE)) : null;
                boolean isSystemInclude = false;
                if (element.hasAttribute(ATTRIBUTE_SYSTEM)) {
                    isSystemInclude = element.getAttribute(ATTRIBUTE_SYSTEM).equals(VALUE_TRUE);
                }
                return CoreModel.newIncludeEntry((IPath)path, (IPath)includePath, isSystemInclude, isRecursive, exclusionPatterns, isExported);
            }
            case 7: {
                String macroName = element.getAttribute(ATTRIBUTE_NAME);
                String macroValue = element.getAttribute(ATTRIBUTE_VALUE);
                return CoreModel.newMacroEntry((IPath)path, macroName, macroValue, isRecursive, exclusionPatterns, isExported);
            }
            case 6: {
                String id = element.getAttribute(ATTRIBUTE_ID);
                return CoreModel.newContainerEntry(id, isExported);
            }
        }
        CModelStatus status = new CModelStatus(4, "CPathEntry: unknown kind (" + kindAttr + ")");
        throw new CModelException(status);
    }

    void encodeCPathEntries(Document doc, Element configRootElement, ICPathEntry[] entries) {
        this.getProject().getFullPath();
        int i = 0;
        while (i < entries.length) {
            IPath path;
            Element element = doc.createElement(PATH_ENTRY);
            configRootElement.appendChild(element);
            int kind = entries[i].getEntryKind();
            element.setAttribute(ATTRIBUTE_KIND, CPathEntry.kindToString(kind));
            if (entries[i] instanceof ACPathEntry) {
                ACPathEntry entry = (ACPathEntry)entries[i];
                IPath[] exclusionPatterns = entry.getExclusionPatterns();
                if (exclusionPatterns.length > 0) {
                    StringBuffer excludeRule = new StringBuffer(10);
                    int j = 0;
                    int max = exclusionPatterns.length;
                    while (j < max) {
                        if (j > 0) {
                            excludeRule.append('|');
                        }
                        excludeRule.append(exclusionPatterns[j]);
                        ++j;
                    }
                    element.setAttribute(ATTRIBUTE_EXCLUDING, excludeRule.toString());
                }
                if (entry.isRecursive()) {
                    element.setAttribute(ATTRIBUTE_RECUSIVE, VALUE_TRUE);
                }
            }
            if (kind == 3) {
                ISourceEntry source = (ISourceEntry)entries[i];
                path = source.getSourcePath();
                element.setAttribute(ATTRIBUTE_PATH, path.toString());
                IPath output = source.getOutputLocation();
                if (output != null && output.isEmpty()) {
                    element.setAttribute(ATTRIBUTE_OUTPUT, output.toString());
                }
            } else if (kind == 1) {
                ILibraryEntry lib = (ILibraryEntry)entries[i];
                path = lib.getLibraryPath();
                element.setAttribute(ATTRIBUTE_PATH, path.toString());
                if (lib.getSourceAttachmentPath() != null) {
                    element.setAttribute(ATTRIBUTE_SOURCEPATH, lib.getSourceAttachmentPath().toString());
                }
                if (lib.getSourceAttachmentRootPath() != null) {
                    element.setAttribute(ATTRIBUTE_ROOTPATH, lib.getSourceAttachmentRootPath().toString());
                }
                if (lib.getSourceAttachmentPrefixMapping() != null) {
                    element.setAttribute(ATTRIBUTE_PREFIXMAPPING, lib.getSourceAttachmentPrefixMapping().toString());
                }
            } else if (kind == 2) {
                IProjectEntry pentry = (IProjectEntry)entries[i];
                path = pentry.getProjectPath();
                element.setAttribute(ATTRIBUTE_PATH, path.toString());
            } else if (kind == 5) {
                IIncludeEntry include = (IIncludeEntry)entries[i];
                path = include.getResourcePath();
                element.setAttribute(ATTRIBUTE_PATH, path.toString());
                IPath includePath = include.getIncludePath();
                element.setAttribute(ATTRIBUTE_INCLUDE, includePath.toString());
                if (include.isSystemInclude()) {
                    element.setAttribute(ATTRIBUTE_SYSTEM, VALUE_TRUE);
                }
            } else if (kind == 7) {
                IMacroEntry macro = (IMacroEntry)entries[i];
                path = macro.getResourcePath();
                element.setAttribute(ATTRIBUTE_PATH, path.toString());
                element.setAttribute(ATTRIBUTE_NAME, macro.getMacroName());
                element.setAttribute(ATTRIBUTE_VALUE, macro.getMacroValue());
            } else if (kind == 6) {
                IContainerEntry container = (IContainerEntry)entries[i];
                element.setAttribute(ATTRIBUTE_ID, container.getId());
            }
            if (entries[i].isExported()) {
                element.setAttribute(ATTRIBUTE_EXPORTED, VALUE_TRUE);
            }
            ++i;
        }
    }
}

