/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class IncludePattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[] decodedSimpleName;

    public IncludePattern(char[] name, int matchMode, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.simpleName = name;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int cfr_ignored_0 = word.length;
        int firstSlash = CharOperation.indexOf('/', word, 0);
        this.decodedSimpleName = CharOperation.subarray(word, firstSlash + 1, -1);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                requestor.acceptIncludeDeclaration(path, this.decodedSimpleName);
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestIncludePrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        return this.simpleName == null || this.matchesName(this.simpleName, this.decodedSimpleName);
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        return 0;
    }
}

