/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.IOException;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsProvider;
import org.eclipse.cdt.utils.coff.parser.BinaryFile;
import org.eclipse.cdt.utils.coff.parser.PEParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CygwinPEParser
extends PEParser
implements IBinaryParser,
ICygwinToolsProvider {
    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        IBinaryParser.IBinaryFile binary = super.getBinary(path);
        if (binary instanceof BinaryFile) {
            ((BinaryFile)binary).setToolsProvider(this);
        }
        return binary;
    }

    public String getFormat() {
        return "Cygwin PE";
    }

    public IPath getAddr2LinePath() {
        ICExtensionReference ref = this.getExtensionReference();
        String value = ref.getExtensionData("addr2line");
        if (value == null || value.length() == 0) {
            value = "addr2line";
        }
        return new Path(value);
    }

    public IPath getCPPFiltPath() {
        ICExtensionReference ref = this.getExtensionReference();
        String value = ref.getExtensionData("c++filt");
        if (value == null || value.length() == 0) {
            value = "c++filt";
        }
        return new Path(value);
    }

    public IPath getCygPathPath() {
        ICExtensionReference ref = this.getExtensionReference();
        String value = ref.getExtensionData("cygpath");
        if (value == null || value.length() == 0) {
            value = "cygpath";
        }
        return new Path(value);
    }

    public Addr2line getAddr2Line(IPath execFile) {
        IPath addr2LinePath = this.getAddr2LinePath();
        Addr2line addr2line = null;
        if (addr2LinePath != null && !addr2LinePath.isEmpty()) {
            try {
                addr2line = new Addr2line(addr2LinePath.toOSString(), execFile.toOSString());
            }
            catch (IOException iOException) {}
        }
        return addr2line;
    }

    public CPPFilt getCPPFilt() {
        IPath cppFiltPath = this.getCPPFiltPath();
        CPPFilt cppfilt = null;
        if (cppFiltPath != null && !cppFiltPath.isEmpty()) {
            try {
                cppfilt = new CPPFilt(cppFiltPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return cppfilt;
    }

    public CygPath getCygPath() {
        IPath cygPathPath = this.getCygPathPath();
        CygPath cygpath = null;
        if (cygPathPath != null && !cygPathPath.isEmpty()) {
            try {
                cygpath = new CygPath(cygPathPath.toOSString());
            }
            catch (IOException iOException) {}
        }
        return cygpath;
    }
}

