/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.internal.ui.IMIHelpContextIds;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class MIPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IntegerFieldEditor fDebugTimeoutText;
    IntegerFieldEditor fLaunchTimeoutText;

    public MIPreferencePage() {
        this.setPreferenceStore(MIUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("General settings for GDB MI.");
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMIHelpContextIds.MI_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createCommunicationPreferences(composite);
        this.setValues();
        return composite;
    }

    private Composite createGroupComposite(Composite parent, int numColumns, String labelText) {
        return ControlFactory.createGroup((Composite)parent, (String)labelText, (int)numColumns);
    }

    private void setValues() {
        this.fDebugTimeoutText.setStringValue(new Integer(MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_TIMEOUT)).toString());
        this.fLaunchTimeoutText.setStringValue(new Integer(MIPlugin.getDefault().getPluginPreferences().getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT)).toString());
    }

    public boolean performOk() {
        this.storeValues();
        MIUIPlugin.getDefault().savePluginPreferences();
        MIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fDebugTimeoutText.setStringValue(new Integer(10000).toString());
        this.fLaunchTimeoutText.setStringValue(new Integer(30000).toString());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void createCommunicationPreferences(Composite composite) {
        Composite comp = this.createGroupComposite(composite, 1, "Communication");
        Composite spacingComposite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        spacingComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        spacingComposite.setLayoutData((Object)data);
        this.fDebugTimeoutText = this.createTimeoutField(IMIConstants.PREF_REQUEST_TIMEOUT, "&Debugger timeout (ms):", spacingComposite);
        this.fDebugTimeoutText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    MIPreferencePage.this.setValid(MIPreferencePage.this.fDebugTimeoutText.isValid());
                }
            }
        });
        this.fLaunchTimeoutText = this.createTimeoutField(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, "&Launch &timeout (ms):", spacingComposite);
        this.fLaunchTimeoutText.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    MIPreferencePage.this.setValid(MIPreferencePage.this.fLaunchTimeoutText.isValid());
                }
            }
        });
    }

    private void storeValues() {
        MIPlugin.getDefault().getPluginPreferences().setValue(IMIConstants.PREF_REQUEST_TIMEOUT, this.fDebugTimeoutText.getIntValue());
        MIPlugin.getDefault().getPluginPreferences().setValue(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT, this.fLaunchTimeoutText.getIntValue());
    }

    private IntegerFieldEditor createTimeoutField(String preference, String label, Composite parent) {
        IntegerFieldEditor toText = new IntegerFieldEditor(preference, label, parent);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(10);
        toText.getTextControl(parent).setLayoutData((Object)data);
        toText.setPreferenceStore(MIUIPlugin.getDefault().getPreferenceStore());
        toText.setPreferencePage((PreferencePage)this);
        toText.setValidateStrategy(0);
        toText.setValidRange(100, Integer.MAX_VALUE);
        String minValue = Integer.toString(100);
        String maxValue = Integer.toString(Integer.MAX_VALUE);
        toText.setErrorMessage(MessageFormat.format("The valid value range is [{0},{1}].", minValue, maxValue));
        toText.load();
        return toText;
    }
}

