/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.parser.Backtrack;
import org.eclipse.cdt.core.parser.EndOfFile;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryException;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.BranchTracker;
import org.eclipse.cdt.internal.core.parser.ContextException;
import org.eclipse.cdt.internal.core.parser.ContextStack;
import org.eclipse.cdt.internal.core.parser.IProblemFactory;
import org.eclipse.cdt.internal.core.parser.IScannerContext;
import org.eclipse.cdt.internal.core.parser.MacroDescriptor;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ScannerContext;
import org.eclipse.cdt.internal.core.parser.ScannerProblemFactory;
import org.eclipse.cdt.internal.core.parser.Token;

public class Scanner
implements IScanner {
    protected final IParserLogService log;
    private static final String SCRATCH = "<scratch>";
    private Reader backupReader;
    private IProblemFactory problemFactory = new ScannerProblemFactory();
    private static final int NOCHAR = -1;
    private static final String TEXT = "<text>";
    private static final String START = "<initial reader>";
    private static final String EXPRESSION = "<expression>";
    private static final String PASTING = "<pasting>";
    private static final String DEFINED = "defined";
    private static final String _PRAGMA = "_Pragma";
    private static final String POUND_DEFINE = "#define ";
    private ContextStack contextStack = null;
    private IScannerContext lastContext = null;
    private IScannerInfo originalConfig;
    private List includePathNames = new ArrayList();
    private List includePaths = new ArrayList();
    private Hashtable definitions = new Hashtable();
    private StringBuffer storageBuffer = null;
    private int count = 0;
    private static HashMap cppKeywords = new HashMap();
    private static HashMap cKeywords = new HashMap();
    private static HashMap ppDirectives = new HashMap();
    private IToken currentToken = null;
    private IToken cachedToken = null;
    private boolean passOnToClient = true;
    private BranchTracker branches = new BranchTracker();
    private boolean enableDigraphReplacement = true;
    private boolean enableTrigraphReplacement = true;
    private boolean enableTrigraphReplacementInStrings = true;
    private boolean throwExceptionOnBadCharacterRead = false;
    private boolean atEOF = false;
    private boolean tokenizingMacroReplacementList = false;
    private final ParserMode mode;
    protected static endOfMacroTokenException endOfMacroToken = new endOfMacroTokenException();
    protected static final Hashtable emptyMap;
    protected Hashtable holderMap = null;
    protected boolean forInclusion = false;
    private ParserLanguage language = ParserLanguage.CPP;
    private final ISourceElementRequestor requestor;
    private IASTFactory astFactory = null;

    static {
        cppKeywords.put("and", new Integer(54));
        cppKeywords.put("and_eq", new Integer(55));
        cppKeywords.put("asm", new Integer(56));
        cppKeywords.put("auto", new Integer(57));
        cppKeywords.put("bitand", new Integer(58));
        cppKeywords.put("bitor", new Integer(59));
        cppKeywords.put("bool", new Integer(60));
        cppKeywords.put("break", new Integer(61));
        cppKeywords.put("case", new Integer(62));
        cppKeywords.put("catch", new Integer(63));
        cppKeywords.put("char", new Integer(64));
        cppKeywords.put("class", new Integer(65));
        cppKeywords.put("compl", new Integer(66));
        cppKeywords.put("const", new Integer(67));
        cppKeywords.put("const_cast", new Integer(69));
        cppKeywords.put("continue", new Integer(70));
        cppKeywords.put("default", new Integer(71));
        cppKeywords.put("delete", new Integer(72));
        cppKeywords.put("do", new Integer(73));
        cppKeywords.put("double", new Integer(74));
        cppKeywords.put("dynamic_cast", new Integer(75));
        cppKeywords.put("else", new Integer(76));
        cppKeywords.put("enum", new Integer(77));
        cppKeywords.put("explicit", new Integer(78));
        cppKeywords.put("export", new Integer(79));
        cppKeywords.put("extern", new Integer(80));
        cppKeywords.put("false", new Integer(81));
        cppKeywords.put("float", new Integer(82));
        cppKeywords.put("for", new Integer(83));
        cppKeywords.put("friend", new Integer(84));
        cppKeywords.put("goto", new Integer(85));
        cppKeywords.put("if", new Integer(86));
        cppKeywords.put("inline", new Integer(87));
        cppKeywords.put("int", new Integer(88));
        cppKeywords.put("long", new Integer(89));
        cppKeywords.put("mutable", new Integer(90));
        cppKeywords.put("namespace", new Integer(91));
        cppKeywords.put("new", new Integer(92));
        cppKeywords.put("not", new Integer(93));
        cppKeywords.put("not_eq", new Integer(94));
        cppKeywords.put("operator", new Integer(95));
        cppKeywords.put("or", new Integer(96));
        cppKeywords.put("or_eq", new Integer(97));
        cppKeywords.put("private", new Integer(98));
        cppKeywords.put("protected", new Integer(99));
        cppKeywords.put("public", new Integer(100));
        cppKeywords.put("register", new Integer(101));
        cppKeywords.put("reinterpret_cast", new Integer(102));
        cppKeywords.put("return", new Integer(103));
        cppKeywords.put("short", new Integer(104));
        cppKeywords.put("signed", new Integer(108));
        cppKeywords.put("sizeof", new Integer(105));
        cppKeywords.put("static", new Integer(106));
        cppKeywords.put("static_cast", new Integer(107));
        cppKeywords.put("struct", new Integer(109));
        cppKeywords.put("switch", new Integer(110));
        cppKeywords.put("template", new Integer(111));
        cppKeywords.put("this", new Integer(112));
        cppKeywords.put("throw", new Integer(113));
        cppKeywords.put("true", new Integer(114));
        cppKeywords.put("try", new Integer(115));
        cppKeywords.put("typedef", new Integer(116));
        cppKeywords.put("typeid", new Integer(117));
        cppKeywords.put("typename", new Integer(118));
        cppKeywords.put("union", new Integer(119));
        cppKeywords.put("unsigned", new Integer(120));
        cppKeywords.put("using", new Integer(121));
        cppKeywords.put("virtual", new Integer(122));
        cppKeywords.put("void", new Integer(123));
        cppKeywords.put("volatile", new Integer(124));
        cppKeywords.put("wchar_t", new Integer(125));
        cppKeywords.put("while", new Integer(126));
        cppKeywords.put("xor", new Integer(127));
        cppKeywords.put("xor_eq", new Integer(128));
        ppDirectives.put("#define", new Integer(0));
        ppDirectives.put("#undef", new Integer(1));
        ppDirectives.put("#if", new Integer(2));
        ppDirectives.put("#ifdef", new Integer(3));
        ppDirectives.put("#ifndef", new Integer(4));
        ppDirectives.put("#else", new Integer(5));
        ppDirectives.put("#endif", new Integer(6));
        ppDirectives.put("#include", new Integer(7));
        ppDirectives.put("#line", new Integer(8));
        ppDirectives.put("#error", new Integer(9));
        ppDirectives.put("#pragma", new Integer(10));
        ppDirectives.put("#elif", new Integer(12));
        ppDirectives.put("#", new Integer(11));
        cKeywords.put("auto", new Integer(57));
        cKeywords.put("break", new Integer(61));
        cKeywords.put("case", new Integer(62));
        cKeywords.put("char", new Integer(64));
        cKeywords.put("const", new Integer(67));
        cKeywords.put("continue", new Integer(70));
        cKeywords.put("default", new Integer(71));
        cKeywords.put("delete", new Integer(72));
        cKeywords.put("do", new Integer(73));
        cKeywords.put("double", new Integer(74));
        cKeywords.put("else", new Integer(76));
        cKeywords.put("enum", new Integer(77));
        cKeywords.put("extern", new Integer(80));
        cKeywords.put("float", new Integer(82));
        cKeywords.put("for", new Integer(83));
        cKeywords.put("goto", new Integer(85));
        cKeywords.put("if", new Integer(86));
        cKeywords.put("inline", new Integer(87));
        cKeywords.put("int", new Integer(88));
        cKeywords.put("long", new Integer(89));
        cKeywords.put("register", new Integer(101));
        cKeywords.put("restrict", new Integer(137));
        cKeywords.put("return", new Integer(103));
        cKeywords.put("short", new Integer(104));
        cKeywords.put("signed", new Integer(108));
        cKeywords.put("sizeof", new Integer(105));
        cKeywords.put("static", new Integer(106));
        cKeywords.put("struct", new Integer(109));
        cKeywords.put("switch", new Integer(110));
        cKeywords.put("typedef", new Integer(116));
        cKeywords.put("union", new Integer(119));
        cKeywords.put("unsigned", new Integer(120));
        cKeywords.put("void", new Integer(123));
        cKeywords.put("volatile", new Integer(124));
        cKeywords.put("while", new Integer(126));
        cKeywords.put("_Bool", new Integer(134));
        cKeywords.put("_Complex", new Integer(135));
        cKeywords.put("_Imaginary", new Integer(136));
        emptyMap = new Hashtable();
    }

    protected void handleProblem(int problemID, String argument, int beginningOffset, boolean warning, boolean error) throws ScannerException {
        this.handleProblem(problemID, argument, beginningOffset, warning, error, true);
    }

    protected void handleProblem(int problemID, String argument, int beginningOffset, boolean warning, boolean error, boolean extra) throws ScannerException {
        IProblem p;
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (argument != null) {
            String[] attributes = this.problemFactory.getRequiredAttributesForId(problemID);
            arguments.put(attributes[0], argument);
        }
        if (!this.requestor.acceptProblem(p = this.problemFactory.createProblem(problemID, beginningOffset, this.getCurrentOffset(), this.contextStack.getCurrentLineNumber(), this.getCurrentFile().toCharArray(), arguments, warning, error)) && extra) {
            throw new ScannerException(p);
        }
    }

    public Scanner(Reader reader, String filename, IScannerInfo info, ISourceElementRequestor requestor, ParserMode parserMode, ParserLanguage language, IParserLogService log) {
        this.log = log;
        this.requestor = requestor;
        this.mode = parserMode;
        this.language = language;
        this.astFactory = ParserFactory.createASTFactory(this.mode, language);
        this.backupReader = reader;
        this.contextStack = new ContextStack(log);
        try {
            this.contextStack.push(new ScannerContext().initialize(new StringReader("\n"), START, 0, null), requestor);
            if (filename == null) {
                this.contextStack.push(new ScannerContext().initialize(reader, TEXT, 1, null), requestor);
            } else {
                this.contextStack.push(new ScannerContext().initialize(reader, filename, 1, null), requestor);
            }
        }
        catch (ContextException contextException) {}
        this.originalConfig = info;
        if (info.getDefinedSymbols() != null) {
            this.definitions.putAll(info.getDefinedSymbols());
        }
        if (info.getIncludePaths() != null) {
            this.overwriteIncludePath(info.getIncludePaths());
        }
    }

    public void addIncludePath(String includePath) {
        this.includePathNames.add(includePath);
        this.includePaths.add(new File(includePath));
    }

    public void overwriteIncludePath(String[] newIncludePaths) {
        if (newIncludePaths == null) {
            return;
        }
        this.includePathNames = null;
        this.includePaths = null;
        this.includePathNames = new ArrayList();
        this.includePaths = new ArrayList();
        int i = 0;
        while (i < newIncludePaths.length) {
            this.includePathNames.add(newIncludePaths[i]);
            ++i;
        }
        Iterator i2 = this.includePathNames.iterator();
        while (i2.hasNext()) {
            String path = (String)i2.next();
            this.includePaths.add(new File(path));
        }
    }

    public void addDefinition(String key, IMacroDescriptor macro) {
        this.definitions.put(key, macro);
    }

    public void addDefinition(String key, String value) {
        this.definitions.put(key, value);
    }

    public final Object getDefinition(String key) {
        return this.definitions.get(key);
    }

    public final String[] getIncludePaths() {
        return (String[])this.includePathNames.toArray();
    }

    protected boolean skipOverWhitespace() throws ScannerException {
        int c = this.getChar();
        boolean result = false;
        while (c != -1 && (c == 32 || c == 9)) {
            c = this.getChar();
            result = true;
        }
        if (c != -1) {
            this.ungetChar(c);
        }
        return result;
    }

    protected String getRestOfPreprocessorLine() throws ScannerException {
        StringBuffer buffer;
        block11: {
            buffer = new StringBuffer();
            this.skipOverWhitespace();
            int c = this.getChar();
            boolean inString = false;
            boolean inChar = false;
            while (true) {
                if (c != 10 && c != 13 && c != 92 && c != 47 && (c != 34 || c == 34 && inChar) && (c != 39 || c == 39 && inString) && c != -1) {
                    buffer.append((char)c);
                    c = this.getChar(true);
                    continue;
                }
                if (c == 47) {
                    if (inString || inChar) {
                        buffer.append((char)c);
                        c = this.getChar(true);
                        continue;
                    }
                    int next = this.getChar();
                    if (next == 47) {
                        this.skipOverSinglelineComment();
                        break block11;
                    }
                    if (next == 42) {
                        if (!this.skipOverMultilineComment()) {
                            c = this.getChar(true);
                            continue;
                        }
                        break block11;
                    }
                    buffer.append((char)c);
                    c = next;
                    continue;
                }
                if (c == 34) {
                    inString = !inString;
                    buffer.append((char)c);
                    c = this.getChar(true);
                    continue;
                }
                if (c == 39) {
                    inChar = !inChar;
                    buffer.append((char)c);
                    c = this.getChar(true);
                    continue;
                }
                if (c != 92) break;
                c = this.getChar(true);
                if (c == 13) {
                    c = this.getChar(true);
                    if (c != 10) continue;
                    c = this.getChar(true);
                    continue;
                }
                if (c == 10) {
                    c = this.getChar(true);
                    continue;
                }
                buffer.append('\\');
                if (c != 34 && c != 39) continue;
                buffer.append((char)c);
                c = this.getChar(true);
            }
            this.ungetChar(c);
        }
        return buffer.toString();
    }

    protected void skipOverTextUntilNewline() throws ScannerException {
        while (true) {
            switch (this.getChar()) {
                case -1: 
                case 10: {
                    return;
                }
                case 92: {
                    this.getChar();
                }
            }
        }
    }

    private void setCurrentToken(IToken t) {
        if (this.currentToken != null) {
            this.currentToken.setNext(t);
        }
        this.currentToken = t;
    }

    protected void resetStorageBuffer() {
        if (this.storageBuffer != null) {
            this.storageBuffer = null;
        }
    }

    protected IToken newToken(int t, String i, IScannerContext c) {
        this.setCurrentToken(new Token(t, i, c));
        return this.currentToken;
    }

    protected IToken newToken(int t, String i) {
        this.setCurrentToken(new Token(t, i));
        return this.currentToken;
    }

    protected String getNextIdentifier() throws ScannerException {
        StringBuffer buffer = new StringBuffer();
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
            buffer.append((char)c);
            c = this.getChar();
            while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                buffer.append((char)c);
                c = this.getChar();
            }
        }
        this.ungetChar(c);
        return buffer.toString();
    }

    protected void handleInclusion(String fileName, boolean useIncludePaths, int nameOffset, int beginOffset, int endOffset) throws ScannerException {
        FileReader inclusionReader = null;
        String newPath = null;
        if (useIncludePaths) {
            Iterator iter = this.includePaths.iterator();
            while (iter.hasNext()) {
                File includeFile;
                File pathFile = (File)iter.next();
                String path = pathFile.getPath();
                if (!pathFile.exists() && path.indexOf(34) != -1) {
                    StringTokenizer tokenizer = new StringTokenizer(path, "\"");
                    StringBuffer buffer = new StringBuffer(path.length());
                    while (tokenizer.hasMoreTokens()) {
                        buffer.append(tokenizer.nextToken());
                    }
                    pathFile = new File(buffer.toString());
                }
                if (!pathFile.isDirectory() || !(includeFile = new File(newPath = String.valueOf(pathFile.getPath()) + File.separatorChar + fileName)).exists() || !includeFile.isFile()) continue;
                try {
                    inclusionReader = new FileReader(includeFile);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            if (inclusionReader == null) {
                this.handleProblem(0x2000002, fileName, beginOffset, false, true, true);
            }
        } else {
            String currentFilename = this.contextStack.getCurrentContext().getFilename();
            File currentIncludeFile = new File(currentFilename);
            String parentDirectory = currentIncludeFile.getParentFile().getAbsolutePath();
            currentIncludeFile = null;
            newPath = String.valueOf(parentDirectory) + File.separatorChar + fileName;
            File includeFile = new File(newPath);
            if (includeFile.exists() && includeFile.isFile()) {
                try {
                    inclusionReader = new FileReader(includeFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.handleInclusion(fileName, true, nameOffset, beginOffset, endOffset);
                }
            } else {
                this.handleInclusion(fileName, true, nameOffset, beginOffset, endOffset);
            }
        }
        if (inclusionReader != null) {
            IASTInclusion inclusion = null;
            try {
                inclusion = this.astFactory.createInclusion(fileName, newPath, !useIncludePaths, beginOffset, nameOffset, nameOffset + fileName.length(), endOffset);
            }
            catch (Exception exception) {}
            try {
                this.contextStack.updateContext(inclusionReader, newPath, 2, inclusion, this.requestor);
            }
            catch (ContextException e1) {
                this.handleProblem(e1.getId(), fileName, beginOffset, false, true, true);
            }
        }
    }

    public void setTokenizingMacroReplacementList(boolean mr) {
        this.tokenizingMacroReplacementList = mr;
    }

    private int getChar() throws ScannerException {
        return this.getChar(false);
    }

    private int getChar(boolean insideString) throws ScannerException {
        int c = -1;
        this.lastContext = this.contextStack.getCurrentContext();
        if (this.contextStack.getCurrentContext() == null) {
            return c;
        }
        c = this.accountForUndo(c);
        int baseOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 1;
        if (this.enableTrigraphReplacement && (!insideString || this.enableTrigraphReplacementInStrings)) {
            this.enableTrigraphReplacement = false;
            if (c == 63) {
                c = this.getChar(insideString);
                if (c == 63) {
                    c = this.getChar(insideString);
                    switch (c) {
                        case 40: {
                            this.expandDefinition("??(", "[", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 41: {
                            this.expandDefinition("??)", "]", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 60: {
                            this.expandDefinition("??<", "{", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 62: {
                            this.expandDefinition("??>", "}", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 61: {
                            this.expandDefinition("??=", "#", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 47: {
                            this.expandDefinition("??/", "\\", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 39: {
                            this.expandDefinition("??'", "^", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 33: {
                            this.expandDefinition("??!", "|", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 45: {
                            this.expandDefinition("??-", "~", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        default: {
                            this.ungetChar(c);
                            this.ungetChar(63);
                            c = 63;
                            break;
                        }
                    }
                } else {
                    this.ungetChar(c);
                    c = 63;
                }
            }
            this.enableTrigraphReplacement = true;
        }
        if (!insideString) {
            if (c == 92) {
                c = this.getChar(false);
                if (c == 13) {
                    c = this.getChar(false);
                    if (c == 10) {
                        c = this.getChar(false);
                    }
                } else if (c == 10) {
                    c = this.getChar(false);
                } else {
                    this.ungetChar(c);
                    c = 92;
                }
            } else if (this.enableDigraphReplacement) {
                this.enableDigraphReplacement = false;
                if (c == 60) {
                    c = this.getChar(false);
                    if (c == 37) {
                        this.expandDefinition("<%", "{", baseOffset);
                        c = this.getChar(false);
                    } else if (c == 58) {
                        this.expandDefinition("<:", "[", baseOffset);
                        c = this.getChar(false);
                    } else {
                        this.ungetChar(c);
                        c = 60;
                    }
                } else if (c == 58) {
                    c = this.getChar(false);
                    if (c == 62) {
                        this.expandDefinition(":>", "]", baseOffset);
                        c = this.getChar(false);
                    } else {
                        this.ungetChar(c);
                        c = 58;
                    }
                } else if (c == 37) {
                    c = this.getChar(false);
                    if (c == 62) {
                        this.expandDefinition("%>", "}", baseOffset);
                        c = this.getChar(false);
                    } else if (c == 58) {
                        this.expandDefinition("%:", "#", baseOffset);
                        c = this.getChar(false);
                    } else {
                        this.ungetChar(c);
                        c = 37;
                    }
                }
                this.enableDigraphReplacement = true;
            }
        }
        return c;
    }

    protected int accountForUndo(int c) {
        boolean done;
        do {
            done = true;
            if (this.contextStack.getCurrentContext().undoStackSize() != 0) {
                c = this.contextStack.getCurrentContext().popUndo();
                continue;
            }
            try {
                c = this.contextStack.getCurrentContext().read();
                if (c != -1) continue;
                if (!this.contextStack.rollbackContext(this.requestor)) {
                    c = -1;
                    break;
                }
                done = false;
            }
            catch (IOException iOException) {
                if (!this.contextStack.rollbackContext(this.requestor)) {
                    c = -1;
                    continue;
                }
                done = false;
            }
        } while (!done);
        return c;
    }

    private void ungetChar(int c) throws ScannerException {
        this.contextStack.getCurrentContext().pushUndo(c);
        try {
            this.contextStack.undoRollback(this.lastContext, this.requestor);
        }
        catch (ContextException e) {
            this.handleProblem(e.getId(), this.contextStack.getCurrentContext().getFilename(), this.getCurrentOffset(), false, true, true);
        }
    }

    protected boolean lookAheadForTokenPasting() throws ScannerException {
        int c = this.getChar();
        if (c == 35) {
            c = this.getChar();
            if (c == 35) {
                return true;
            }
            this.ungetChar(c);
        }
        this.ungetChar(c);
        return false;
    }

    protected void consumeUntilOutOfMacroExpansion() throws ScannerException {
        while (this.contextStack.getCurrentContext().getKind() == 3) {
            this.getChar();
        }
    }

    public IToken nextToken() throws ScannerException, EndOfFile {
        return this.nextToken(true, false);
    }

    public IToken nextToken(boolean pasting) throws ScannerException, EndOfFile {
        return this.nextToken(pasting, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IToken nextToken(boolean pasting, boolean lookingForNextAlready) throws ScannerException, EndOfFile {
        if (this.cachedToken != null) {
            this.setCurrentToken(this.cachedToken);
            this.cachedToken = null;
            return this.currentToken;
        }
        ++this.count;
        possibleWideLiteral = true;
        wideLiteral = false;
        c = this.getChar();
        while (c != -1) {
            block184: {
                block185: {
                    block183: {
                        block182: {
                            block181: {
                                block180: {
                                    block175: {
                                        block179: {
                                            block177: {
                                                block178: {
                                                    block176: {
                                                        block174: {
                                                            if (!this.passOnToClient) {
                                                                while (c != -1 && c != 35) {
                                                                    c = this.getChar();
                                                                    if (c != 47) continue;
                                                                    c = this.getChar();
                                                                    if (c == 47) {
                                                                        this.skipOverSinglelineComment();
                                                                        c = this.getChar();
                                                                        continue;
                                                                    }
                                                                    if (c != 42) continue;
                                                                    this.skipOverMultilineComment();
                                                                    c = this.getChar();
                                                                }
                                                                if (c == -1) continue;
                                                            }
                                                            if (c == 32 || c == 13 || c == 9 || c == 10) {
                                                                c = this.getChar();
                                                                continue;
                                                            }
                                                            if (c == 76 && possibleWideLiteral) {
                                                                oldChar = c;
                                                                c = this.getChar();
                                                                if (c != 34 && c != 39) {
                                                                    this.ungetChar(c);
                                                                    c = oldChar;
                                                                    possibleWideLiteral = false;
                                                                    continue;
                                                                }
                                                                wideLiteral = true;
                                                                continue;
                                                            }
                                                            if (c != 34) break block174;
                                                            beginOffset = this.getCurrentOffset();
                                                            buff = new StringBuffer();
                                                            beforePrevious = -1;
                                                            previous = c;
                                                            c = this.getChar(true);
                                                            break block175;
                                                        }
                                                        if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90) && c != 95) break block176;
                                                        baseOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 1;
                                                        buff = new StringBuffer();
                                                        buff.append((char)c);
                                                        c = this.getChar();
                                                        if (true) ** GOTO lbl320
                                                    }
                                                    if ((c < 48 || c > 57) && c != 46) break block177;
                                                    beginOffset = this.getCurrentOffset();
                                                    buff = pasting ? (this.storageBuffer != null ? this.storageBuffer : new StringBuffer()) : new StringBuffer();
                                                    hex = false;
                                                    floatingPoint = c == 46;
                                                    firstCharZero = c == 48;
                                                    buff.append((char)c);
                                                    c = this.getChar();
                                                    if (firstCharZero || !floatingPoint || c >= 48 && c <= 57) break block178;
                                                    if (buff.toString().equals(".")) {
                                                        if (c == 42) {
                                                            return this.newToken(49, ".*", this.contextStack.getCurrentContext());
                                                        }
                                                        if (c != 46) {
                                                            this.ungetChar(c);
                                                            return this.newToken(50, ".", this.contextStack.getCurrentContext());
                                                        }
                                                        if (this.getChar() == 46) {
                                                            return this.newToken(48, "...");
                                                        }
                                                        this.handleProblem(0x1000004, null, beginOffset, false, true, true);
                                                    }
                                                    ** GOTO lbl362
                                                }
                                                if (c != 120) ** GOTO lbl362
                                                if (!firstCharZero) {
                                                    this.handleProblem(0x1000005, null, beginOffset, false, true, true);
                                                    c = this.getChar();
                                                    continue;
                                                }
                                                buff.append((char)c);
                                                hex = true;
                                                c = this.getChar();
                                                if (true) ** GOTO lbl362
                                            }
                                            if (c != 35) break block179;
                                            beginningOffset = this.contextStack.getCurrentContext().getOffset() - 1;
                                            buff = new StringBuffer();
                                            buff.append((char)c);
                                            skipped = this.skipOverWhitespace();
                                            c = this.getChar();
                                            if (c == 35) {
                                                if (skipped == false) return this.newToken(-6, "##");
                                                this.handleProblem(0x2000006, "#  #", beginningOffset, false, true, true);
                                            } else if (this.tokenizingMacroReplacementList) {
                                                this.ungetChar(c);
                                                return this.newToken(-7, "#");
                                            }
                                            ** GOTO lbl440
                                        }
                                        block22 : switch (c) {
                                            case 39: {
                                                return this.processCharacterLiteral(c, wideLiteral);
                                            }
                                            case 58: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 58: {
                                                        return this.newToken(3, "::", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(4, ":", this.contextStack.getCurrentContext());
                                            }
                                            case 59: {
                                                return this.newToken(5, ";", this.contextStack.getCurrentContext());
                                            }
                                            case 44: {
                                                return this.newToken(6, ",", this.contextStack.getCurrentContext());
                                            }
                                            case 63: {
                                                return this.newToken(7, "?", this.contextStack.getCurrentContext());
                                            }
                                            case 40: {
                                                return this.newToken(8, "(", this.contextStack.getCurrentContext());
                                            }
                                            case 41: {
                                                return this.newToken(9, ")", this.contextStack.getCurrentContext());
                                            }
                                            case 91: {
                                                return this.newToken(10, "[", this.contextStack.getCurrentContext());
                                            }
                                            case 93: {
                                                return this.newToken(11, "]", this.contextStack.getCurrentContext());
                                            }
                                            case 123: {
                                                return this.newToken(12, "{", this.contextStack.getCurrentContext());
                                            }
                                            case 125: {
                                                return this.newToken(13, "}", this.contextStack.getCurrentContext());
                                            }
                                            case 43: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(14, "+=", this.contextStack.getCurrentContext());
                                                    }
                                                    case 43: {
                                                        return this.newToken(15, "++", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(16, "+", this.contextStack.getCurrentContext());
                                            }
                                            case 45: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(17, "-=", this.contextStack.getCurrentContext());
                                                    }
                                                    case 45: {
                                                        return this.newToken(18, "--", this.contextStack.getCurrentContext());
                                                    }
                                                    case 62: {
                                                        c = this.getChar();
                                                        switch (c) {
                                                            case 42: {
                                                                return this.newToken(19, "->*", this.contextStack.getCurrentContext());
                                                            }
                                                        }
                                                        this.ungetChar(c);
                                                        return this.newToken(20, "->", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(21, "-", this.contextStack.getCurrentContext());
                                            }
                                            case 42: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(22, "*=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(23, "*", this.contextStack.getCurrentContext());
                                            }
                                            case 37: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(24, "%=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(25, "%", this.contextStack.getCurrentContext());
                                            }
                                            case 94: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(26, "^=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(27, "^", this.contextStack.getCurrentContext());
                                            }
                                            case 38: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(28, "&=", this.contextStack.getCurrentContext());
                                                    }
                                                    case 38: {
                                                        return this.newToken(29, "&&", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(30, "&", this.contextStack.getCurrentContext());
                                            }
                                            case 124: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(31, "|=", this.contextStack.getCurrentContext());
                                                    }
                                                    case 124: {
                                                        return this.newToken(32, "||", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(33, "|", this.contextStack.getCurrentContext());
                                            }
                                            case 126: {
                                                return this.newToken(34, "~", this.contextStack.getCurrentContext());
                                            }
                                            case 33: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(35, "!=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(36, "!", this.contextStack.getCurrentContext());
                                            }
                                            case 61: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 61: {
                                                        return this.newToken(37, "==", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(38, "=", this.contextStack.getCurrentContext());
                                            }
                                            case 60: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 60: {
                                                        c = this.getChar();
                                                        switch (c) {
                                                            case 61: {
                                                                return this.newToken(47, "<<=", this.contextStack.getCurrentContext());
                                                            }
                                                        }
                                                        this.ungetChar(c);
                                                        return this.newToken(40, "<<", this.contextStack.getCurrentContext());
                                                    }
                                                    case 61: {
                                                        return this.newToken(41, "<=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                if (this.forInclusion == false) return this.newToken(42, "<", this.contextStack.getCurrentContext());
                                                this.temporarilyReplaceDefinitionsMap();
                                                return this.newToken(42, "<", this.contextStack.getCurrentContext());
                                            }
                                            case 62: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 62: {
                                                        c = this.getChar();
                                                        switch (c) {
                                                            case 61: {
                                                                return this.newToken(43, ">>=", this.contextStack.getCurrentContext());
                                                            }
                                                        }
                                                        this.ungetChar(c);
                                                        return this.newToken(44, ">>", this.contextStack.getCurrentContext());
                                                    }
                                                    case 61: {
                                                        return this.newToken(45, ">=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                if (this.forInclusion == false) return this.newToken(46, ">", this.contextStack.getCurrentContext());
                                                this.restoreDefinitionsMap();
                                                return this.newToken(46, ">", this.contextStack.getCurrentContext());
                                            }
                                            case 46: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 46: {
                                                        c = this.getChar();
                                                        switch (c) {
                                                            case 46: {
                                                                return this.newToken(48, "...", this.contextStack.getCurrentContext());
                                                            }
                                                        }
                                                        throw Parser.endOfFile;
                                                    }
                                                    case 42: {
                                                        return this.newToken(49, ".*", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(50, ".", this.contextStack.getCurrentContext());
                                            }
                                            case 47: {
                                                c = this.getChar();
                                                switch (c) {
                                                    case 47: {
                                                        this.skipOverSinglelineComment();
                                                        c = this.getChar();
                                                        break block22;
                                                    }
                                                    case 42: {
                                                        this.skipOverMultilineComment();
                                                        c = this.getChar();
                                                        break block22;
                                                    }
                                                    case 61: {
                                                        return this.newToken(51, "/=", this.contextStack.getCurrentContext());
                                                    }
                                                }
                                                this.ungetChar(c);
                                                return this.newToken(52, "/", this.contextStack.getCurrentContext());
                                            }
                                            default: {
                                                this.handleProblem(0x1000001, new Character((char)c).toString(), this.getCurrentOffset(), false, true, this.throwExceptionOnBadCharacterRead);
                                                c = 32;
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    while (c != 34 || previous == 92 && beforePrevious != 92) {
                                        if (c == 10 && (previous != 92 || beforePrevious == 92)) {
                                            this.handleProblem(0x1000002, null, beginOffset, false, true, true);
                                        }
                                        if (c == -1) break;
                                        buff.append((char)c);
                                        beforePrevious = previous;
                                        previous = c;
                                        c = this.getChar(true);
                                    }
                                    if (c == -1) break block180;
                                    type = wideLiteral != false ? 131 : 130;
                                    returnToken = this.newToken(type, buff.toString(), this.contextStack.getCurrentContext());
                                    if (lookingForNextAlready) break block181;
                                    next = null;
                                    try {
                                        next = this.nextToken(true, true);
                                    }
                                    catch (EndOfFile v0) {
                                        next = null;
                                    }
                                    if (true) ** GOTO lbl310
                                }
                                this.handleProblem(0x1000002, null, beginOffset, false, true, true);
                                continue;
                                do {
                                    returnToken.setImage(String.valueOf(returnToken.getImage()) + next.getImage());
                                    returnToken.setNext(null);
                                    this.currentToken = returnToken;
                                    try {
                                        next = this.nextToken(true, true);
                                    }
                                    catch (EndOfFile v1) {
                                        next = null;
                                    }
lbl310:
                                    // 4 sources

                                } while (next != null && next.getType() == returnToken.getType());
                                this.cachedToken = next;
                            }
                            this.currentToken = returnToken;
                            returnToken.setNext(null);
                            return returnToken;
                            do {
                                buff.append((char)c);
                                c = this.getChar();
lbl320:
                                // 2 sources

                            } while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95);
                            this.ungetChar(c);
                            ident = buff.toString();
                            if (ident.equals("defined")) {
                                return this.newToken(2, this.handleDefinedMacro());
                            }
                            if (ident.equals("_Pragma") && this.language == ParserLanguage.C) {
                                this.handlePragmaOperator();
                                c = this.getChar();
                                continue;
                            }
                            mapping = this.definitions.get(ident);
                            if (mapping != null && this.contextStack.shouldExpandDefinition("#define " + ident)) {
                                this.expandDefinition(ident, mapping, baseOffset);
                                c = this.getChar();
                                continue;
                            }
                            tokenTypeObject = this.language == ParserLanguage.CPP ? Scanner.cppKeywords.get(ident) : Scanner.cKeywords.get(ident);
                            tokenType = 1;
                            if (tokenTypeObject != null) {
                                tokenType = (Integer)tokenTypeObject;
                            }
                            if (pasting == false) return this.newToken(tokenType, ident, this.contextStack.getCurrentContext());
                            if (this.lookAheadForTokenPasting()) {
                                if (this.storageBuffer == null) {
                                    this.storageBuffer = buff;
                                } else {
                                    this.storageBuffer.append(ident);
                                }
                                c = this.getChar();
                                continue;
                            }
                            if (this.storageBuffer == null) return this.newToken(tokenType, ident, this.contextStack.getCurrentContext());
                            this.storageBuffer.append(ident);
                            try {
                                this.contextStack.updateContext(new StringReader(this.storageBuffer.toString()), "<pasting>", 3, null, this.requestor);
                            }
                            catch (ContextException e) {
                                this.handleProblem(e.getId(), this.contextStack.getCurrentContext().getFilename(), this.getCurrentOffset(), false, true, true);
                            }
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                            do {
                                buff.append((char)c);
                                c = this.getChar();
lbl362:
                                // 4 sources

                            } while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70));
                            if (c == 46) {
                                buff.append((char)c);
                                floatingPoint = true;
                                c = this.getChar();
                                while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                                    buff.append((char)c);
                                    c = this.getChar();
                                }
                            }
                            if (c != 101 && c != 69 && (!hex || c != 112 && c != 80)) break block182;
                            if (!floatingPoint) {
                                floatingPoint = true;
                            }
                            buff.append((char)c);
                            c = this.getChar();
                            if (c != 43 && c != 45) ** GOTO lbl410
                            buff.append((char)c);
                            c = this.getChar();
                            if (true) ** GOTO lbl410
                        }
                        if (!floatingPoint) break block183;
                        if (c == 108 || c == 76 || c == 102 || c == 70) {
                            c = this.getChar();
                        }
                        break block184;
                    }
                    if (c != 117 && c != 85) break block185;
                    c = this.getChar();
                    if (c == 108 || c == 76) {
                        c = this.getChar();
                    }
                    if (c == 108 || c == 76) {
                        c = this.getChar();
                    }
                    break block184;
                }
                if (c == 108 || c == 76) {
                    c = this.getChar();
                    if (c == 108 || c == 76) {
                        c = this.getChar();
                    }
                    if (c == 117 || c == 85) {
                        c = this.getChar();
                    }
                }
                break block184;
                do {
                    buff.append((char)c);
                    c = this.getChar();
lbl410:
                    // 3 sources

                } while (c >= 48 && c <= 57);
                if (c == 108 || c == 76 || c == 102 || c == 70) {
                    buff.append((char)c);
                    c = this.getChar();
                }
            }
            this.ungetChar(c);
            if (pasting) {
                if (this.lookAheadForTokenPasting()) {
                    this.storageBuffer = buff;
                    c = this.getChar();
                    continue;
                }
                if (this.storageBuffer != null) {
                    try {
                        this.contextStack.updateContext(new StringReader(buff.toString()), "<pasting>", 3, null, this.requestor);
                    }
                    catch (ContextException e) {
                        this.handleProblem(e.getId(), this.contextStack.getCurrentContext().getFilename(), this.getCurrentOffset(), false, true, true);
                    }
                    this.storageBuffer = null;
                    c = this.getChar();
                    continue;
                }
            }
            result = buff.toString();
            if (floatingPoint && result.equals(".")) {
                tokenType = 50;
                return this.newToken(tokenType, result, this.contextStack.getCurrentContext());
            }
            tokenType = floatingPoint != false ? 129 : 2;
            return this.newToken(tokenType, result, this.contextStack.getCurrentContext());
lbl-1000:
            // 1 sources

            {
                buff.append((char)c);
                c = this.getChar();
lbl440:
                // 3 sources

                ** while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95)
            }
lbl441:
            // 1 sources

            this.ungetChar(c);
            token = buff.toString();
            directive = Scanner.ppDirectives.get(token);
            if (directive == null) {
                this.handleProblem(0x2000006, "#" + token, beginningOffset, false, true, true);
                continue;
            }
            type = (Integer)directive;
            switch (type) {
                case 0: {
                    if (!this.passOnToClient) {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        ** break;
                    }
                    this.poundDefine(beginningOffset);
                    c = this.getChar();
                    ** break;
                }
                case 7: {
                    if (!this.passOnToClient) {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        ** break;
                    }
                    this.poundInclude(beginningOffset);
                    c = this.getChar();
                    ** break;
                }
                case 1: {
                    if (!this.passOnToClient) {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        ** break;
                    }
                    this.skipOverWhitespace();
                    toBeUndefined = this.getNextIdentifier();
                    this.definitions.remove(toBeUndefined);
                    this.skipOverTextUntilNewline();
                    c = this.getChar();
                    ** break;
                }
                case 2: {
                    currentOffset = this.getCurrentOffset();
                    expression = this.getRestOfPreprocessorLine();
                    expressionEvalResult = false;
                    try {
                        expressionEvalResult = this.evaluateExpression(expression, currentOffset);
                    }
                    catch (ScannerException v2) {}
                    this.passOnToClient = this.branches.poundif(expressionEvalResult);
                    c = this.getChar();
                    ** break;
                }
                case 3: {
                    this.skipOverWhitespace();
                    definition = this.getNextIdentifier();
                    mapping = this.definitions.get(definition);
                    if (mapping == null) {
                        this.passOnToClient = this.branches.poundif(false);
                        this.skipOverTextUntilNewline();
                        ** break;
                    }
                    this.passOnToClient = this.branches.poundif(true);
                    c = this.getChar();
                    ** break;
                }
                case 6: {
                    restOfLine = this.getRestOfPreprocessorLine().trim();
                    if (!restOfLine.equals("")) {
                        this.handleProblem(0x2000006, "#endif " + restOfLine, beginningOffset, false, true, true);
                    }
                    this.passOnToClient = this.branches.poundendif();
                    c = this.getChar();
                    ** break;
                }
                case 4: {
                    this.skipOverWhitespace();
                    def = this.getNextIdentifier();
                    map = this.definitions.get(def);
                    if (map != null) {
                        this.skipOverTextUntilNewline();
                        this.passOnToClient = this.branches.poundif(false);
                        ** break;
                    }
                    this.passOnToClient = this.branches.poundif(true);
                    c = this.getChar();
                    ** break;
                }
                case 5: {
                    try {
                        this.passOnToClient = this.branches.poundelse();
                    }
                    catch (EmptyStackException v3) {
                        this.handleProblem(0x2000004, token, beginningOffset, false, true, true);
                    }
                    this.skipOverTextUntilNewline();
                    c = this.getChar();
                    ** break;
                }
                case 12: {
                    co = this.getCurrentOffset();
                    elsifExpression = this.getRestOfPreprocessorLine().trim();
                    if (elsifExpression.equals("")) {
                        this.handleProblem(0x2000006, "#elif", beginningOffset, false, true, true);
                    }
                    elsifResult = false;
                    elsifResult = this.evaluateExpression(elsifExpression, co);
                    try {
                        this.passOnToClient = this.branches.poundelif(elsifResult);
                    }
                    catch (EmptyStackException v4) {
                        this.handleProblem(0x2000004, String.valueOf(token) + ' ' + elsifExpression, beginningOffset, false, true, true);
                    }
                    c = this.getChar();
                    ** break;
                }
                case 8: {
                    this.skipOverTextUntilNewline();
                    c = this.getChar();
                    ** break;
                }
                case 9: {
                    if (!this.passOnToClient) {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        ** break;
                    }
                    this.handleProblem(0x2000001, this.getRestOfPreprocessorLine(), beginningOffset, false, true, true);
                    c = this.getChar();
                    ** break;
                }
                case 10: {
                    this.skipOverTextUntilNewline();
                    c = this.getChar();
                    ** break;
                }
                case 11: {
                    remainderOfLine = this.getRestOfPreprocessorLine().trim();
                    if (!remainderOfLine.equals("")) {
                        this.handleProblem(0x2000006, "# " + remainderOfLine, beginningOffset, false, true, true);
                    }
                    c = this.getChar();
                    ** break;
                }
            }
            this.handleProblem(0x2000006, "#" + token, beginningOffset, false, true, true);
            ** break;
lbl567:
            // 20 sources

        }
        if (this.getDepth() == 0) throw Parser.endOfFile;
        if (this.atEOF != false) throw Parser.endOfFile;
        this.atEOF = true;
        this.handleProblem(0x1000006, null, this.getCurrentOffset(), false, true, true);
        throw Parser.endOfFile;
    }

    protected void handlePragmaOperator() throws ScannerException {
        this.getRestOfPreprocessorLine();
    }

    protected IToken processCharacterLiteral(int c, boolean wideLiteral) throws ScannerException {
        int beginOffset = this.getCurrentOffset();
        int type = wideLiteral ? 133 : 132;
        StringBuffer buffer = new StringBuffer();
        int prev = c;
        int prevPrev = c;
        c = this.getChar(true);
        while (true) {
            if (c == 10 || (c == 92 || c == 39) && prev == 92 || c == -1) {
                this.handleProblem(0x1000001, new Character((char)c).toString(), beginOffset, false, true, this.throwExceptionOnBadCharacterRead);
                c = 32;
            }
            if (c == 39 && (prev != 92 || prevPrev == 92)) break;
            buffer.append((char)c);
            prevPrev = prev;
            prev = c;
            c = this.getChar(true);
        }
        return this.newToken(type, buffer.toString(), this.contextStack.getCurrentContext());
    }

    protected String getCurrentFile() {
        return this.contextStack.getMostRelevantFileContext() != null ? this.contextStack.getMostRelevantFileContext().getFilename() : "";
    }

    protected int getCurrentOffset() {
        return this.contextStack.getMostRelevantFileContext() != null ? this.contextStack.getMostRelevantFileContext().getOffset() : -1;
    }

    public IToken nextTokenForStringizing() throws ScannerException, EndOfFile {
        int beginOffset = this.getCurrentOffset();
        int c = this.getChar();
        StringBuffer tokenImage = new StringBuffer();
        try {
            while (c != -1) {
                if (c == 32 || c == 13 || c == 9 || c == 10) {
                    if (tokenImage.length() > 0) {
                        throw endOfMacroToken;
                    }
                    c = this.getChar();
                    continue;
                }
                if (c == 34) {
                    if (tokenImage.length() > 0) {
                        throw endOfMacroToken;
                    }
                    StringBuffer buff = new StringBuffer();
                    c = this.getChar(true);
                    while (c != 34 && c != -1) {
                        buff.append((char)c);
                        c = this.getChar(true);
                    }
                    if (c != -1) {
                        return this.newToken(130, buff.toString(), this.contextStack.getCurrentContext());
                    }
                    this.handleProblem(0x1000002, null, beginOffset, false, true, true);
                    c = this.getChar();
                    continue;
                }
                block1 : switch (c) {
                    case 39: {
                        if (tokenImage.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.processCharacterLiteral(c, false);
                    }
                    case 44: {
                        if (tokenImage.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.newToken(6, ",", this.contextStack.getCurrentContext());
                    }
                    case 40: {
                        if (tokenImage.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.newToken(8, "(", this.contextStack.getCurrentContext());
                    }
                    case 41: {
                        if (tokenImage.length() > 0) {
                            throw endOfMacroToken;
                        }
                        return this.newToken(9, ")", this.contextStack.getCurrentContext());
                    }
                    case 47: {
                        if (tokenImage.length() > 0) {
                            throw endOfMacroToken;
                        }
                        c = this.getChar();
                        switch (c) {
                            case 47: {
                                this.skipOverSinglelineComment();
                                c = this.getChar();
                                break block1;
                            }
                            case 42: {
                                this.skipOverMultilineComment();
                                c = this.getChar();
                                break block1;
                            }
                        }
                        tokenImage.append('/');
                        break;
                    }
                    default: {
                        tokenImage.append((char)c);
                        c = this.getChar();
                    }
                }
            }
        }
        catch (endOfMacroTokenException endOfMacroTokenException2) {
            this.ungetChar(c);
        }
        if (tokenImage.length() > 0) {
            return this.newToken(1, tokenImage.toString(), this.contextStack.getCurrentContext());
        }
        throw Parser.endOfFile;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getDepth() {
        return this.branches.getDepth();
    }

    protected boolean evaluateExpression(String expression, int beginningOffset) throws ScannerException {
        if (this.mode == ParserMode.QUICK_PARSE) {
            return !expression.trim().equals("0");
        }
        NullSourceElementRequestor nullCallback = new NullSourceElementRequestor();
        IParser parser = null;
        try {
            IScanner trial = ParserFactory.createScanner(new StringReader(String.valueOf(expression) + ";"), EXPRESSION, new ScannerInfo(this.definitions, this.originalConfig.getIncludePaths()), ParserMode.QUICK_PARSE, this.language, nullCallback, this.log);
            parser = ParserFactory.createParser(trial, nullCallback, ParserMode.QUICK_PARSE, this.language, this.log);
        }
        catch (ParserFactoryException parserFactoryException) {}
        try {
            IASTExpression exp = parser.expression(null);
            return exp.evaluateExpression() != 0;
        }
        catch (Backtrack backtrack) {
            this.handleProblem(0x2000008, expression, beginningOffset, false, true, true);
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            this.handleProblem(0x2000008, expression, beginningOffset, false, true, true);
        }
        return true;
    }

    protected void skipOverSinglelineComment() throws ScannerException {
        StringBuffer comment = new StringBuffer("//");
        block3: while (true) {
            int c = this.getChar();
            comment.append((char)c);
            switch (c) {
                case -1: 
                case 10: {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
            break;
        }
    }

    protected boolean skipOverMultilineComment() throws ScannerException {
        int state = 0;
        boolean encounteredNewline = false;
        StringBuffer comment = new StringBuffer("/*");
        int c = this.getChar();
        comment.append((char)c);
        while (state != 2 && c != -1) {
            if (c == 10) {
                encounteredNewline = true;
            }
            switch (state) {
                case 0: {
                    if (c != 42) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    if (c == 42) break;
                    state = 0;
                }
            }
            c = this.getChar();
            comment.append((char)c);
        }
        if (c == -1) {
            this.handleProblem(0x1000006, null, this.getCurrentOffset(), false, true, true);
        }
        this.ungetChar(c);
        return encounteredNewline;
    }

    protected void poundInclude(int beginningOffset) throws ScannerException {
        this.skipOverWhitespace();
        int baseOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize();
        String includeLine = this.getRestOfPreprocessorLine();
        StringBuffer fileName = new StringBuffer();
        boolean useIncludePath = true;
        int startOffset = baseOffset;
        int endOffset = baseOffset;
        if (!includeLine.equals("")) {
            Scanner helperScanner = new Scanner(new StringReader(includeLine), null, new ScannerInfo(this.definitions, this.originalConfig.getIncludePaths()), new NullSourceElementRequestor(), this.mode, this.language, this.log);
            helperScanner.setForInclusion(true);
            IToken t = null;
            try {
                t = helperScanner.nextToken(false);
            }
            catch (EndOfFile endOfFile) {
                this.handleProblem(0x2000006, "#include " + includeLine, beginningOffset, false, true, true);
                return;
            }
            try {
                if (t.getType() == 130) {
                    fileName.append(t.getImage());
                    startOffset = baseOffset + t.getOffset();
                    endOffset = baseOffset + t.getEndOffset();
                    useIncludePath = false;
                    t = helperScanner.nextToken(false);
                    this.handleProblem(0x2000006, "#include " + includeLine, beginningOffset, false, true, true);
                    return;
                }
                if (t.getType() == 42) {
                    try {
                        t = helperScanner.nextToken(false);
                        startOffset = baseOffset + t.getOffset();
                        while (t.getType() != 46) {
                            fileName.append(t.getImage());
                            helperScanner.skipOverWhitespace();
                            int c = helperScanner.getChar();
                            if (c == 92) {
                                fileName.append('\\');
                            } else {
                                helperScanner.ungetChar(c);
                            }
                            t = helperScanner.nextToken(false);
                        }
                        endOffset = baseOffset + t.getEndOffset();
                    }
                    catch (EndOfFile endOfFile) {
                        this.handleProblem(0x2000006, "#include " + includeLine, beginningOffset, false, true, true);
                        return;
                    }
                    t = helperScanner.nextToken(false);
                    this.handleProblem(0x2000006, "#include " + includeLine, beginningOffset, false, true, true);
                    return;
                }
                this.handleProblem(0x2000006, "#include " + includeLine, beginningOffset, false, true, true);
            }
            catch (EndOfFile endOfFile) {}
        } else {
            this.handleProblem(0x2000006, "#include " + includeLine, beginningOffset, false, true, true);
        }
        String f = fileName.toString();
        if (this.mode == ParserMode.QUICK_PARSE) {
            if (this.requestor != null) {
                ISourceElementCallbackDelegate i = null;
                try {
                    i = this.astFactory.createInclusion(f, "", !useIncludePath, beginningOffset, startOffset, startOffset + f.length(), endOffset);
                }
                catch (Exception exception) {}
                if (i != null) {
                    i.enterScope(this.requestor);
                    i.exitScope(this.requestor);
                }
            }
        } else {
            this.handleInclusion(f.trim(), useIncludePath, startOffset, beginningOffset, endOffset);
        }
    }

    protected void temporarilyReplaceDefinitionsMap() {
        this.holderMap = this.definitions;
        this.definitions = emptyMap;
    }

    protected void restoreDefinitionsMap() {
        this.definitions = this.holderMap;
        this.holderMap = null;
    }

    protected void setForInclusion(boolean b) {
        this.forInclusion = b;
    }

    /*
     * Unable to fully structure code
     */
    protected void poundDefine(int beginning) throws ScannerException, EndOfFile {
        block24: {
            block26: {
                block25: {
                    block23: {
                        this.skipOverWhitespace();
                        key = this.getNextIdentifier();
                        offset = this.contextStack.getCurrentContext().getOffset() - key.length() - this.contextStack.getCurrentContext().undoStackSize();
                        previousDefinition = this.definitions.get(key);
                        c = this.getChar();
                        if (c != 40) break block23;
                        buffer = new StringBuffer();
                        c = this.getChar(true);
                        while (c != 41) {
                            if (c == 92) {
                                c = this.getChar();
                                if (c == 13) {
                                    c = this.getChar();
                                }
                                if (c == 10) {
                                    c = this.getChar();
                                    continue;
                                }
                                this.ungetChar(c);
                                this.handleProblem(0x2000005, "#define " + buffer.toString() + '\\' + (char)c, beginning, false, true, true);
                                return;
                            }
                            if (c == 13 || c == 10) {
                                this.handleProblem(0x2000005, "#define " + buffer.toString() + (char)c, beginning, false, true, true);
                                return;
                            }
                            if (c == -1) {
                                this.handleProblem(0x1000006, null, beginning, false, true, true);
                                return;
                            }
                            buffer.append((char)c);
                            c = this.getChar(true);
                        }
                        parameters = buffer.toString();
                        tokenizer = new StringTokenizer(parameters, ",");
                        parameterIdentifiers = new ArrayList<String>(tokenizer.countTokens());
                        while (tokenizer.hasMoreTokens()) {
                            parameterIdentifiers.add(tokenizer.nextToken().trim());
                        }
                        this.skipOverWhitespace();
                        macroReplacementTokens = new ArrayList<IToken>();
                        replacementString = this.getRestOfPreprocessorLine();
                        if (!replacementString.equals("")) {
                            helperScanner = null;
                            try {
                                helperScanner = ParserFactory.createScanner(new StringReader(replacementString), "<scratch>", new ScannerInfo(), this.mode, this.language, new NullSourceElementRequestor(), this.log);
                            }
                            catch (ParserFactoryException v0) {}
                            helperScanner.setTokenizingMacroReplacementList(true);
                            t = helperScanner.nextToken(false);
                            try {
                                while (true) {
                                    if (t.getType() == -7) {
                                        macroReplacementTokens.add(t);
                                        t = helperScanner.nextToken(false);
                                        index = parameterIdentifiers.indexOf(t.getImage());
                                        if (index == -1) {
                                            this.handleProblem(0x200000A, "#define " + key + " " + replacementString, beginning, false, true, true);
                                            return;
                                        }
                                    }
                                    macroReplacementTokens.add(t);
                                    t = helperScanner.nextToken(false);
                                }
                            }
                            catch (EndOfFile v1) {}
                        }
                        descriptor = new MacroDescriptor();
                        descriptor.initialize(key, parameterIdentifiers, macroReplacementTokens, String.valueOf(key) + "(" + parameters + ")");
                        this.checkValidMacroRedefinition(key, previousDefinition, descriptor, beginning);
                        this.addDefinition(key, descriptor);
                        break block24;
                    }
                    if (c != 10 && c != 13) break block25;
                    this.checkValidMacroRedefinition(key, previousDefinition, "", beginning);
                    this.addDefinition(key, "");
                    break block24;
                }
                if (c != 32 && c != 9) break block26;
                this.skipOverWhitespace();
                value = this.getRestOfPreprocessorLine();
                this.checkValidMacroRedefinition(key, previousDefinition, value, beginning);
                this.addDefinition(key, value);
                break block24;
            }
            if (c != 47) ** GOTO lbl102
            c = this.getChar();
            if (c == 47) {
                this.skipOverSinglelineComment();
                this.checkValidMacroRedefinition(key, previousDefinition, "", beginning);
                this.addDefinition(key, "");
            } else if (c == 42) {
                if (this.skipOverMultilineComment()) {
                    this.checkValidMacroRedefinition(key, previousDefinition, "", beginning);
                    this.addDefinition(key, "");
                } else {
                    value = this.getRestOfPreprocessorLine();
                    this.checkValidMacroRedefinition(key, previousDefinition, "", beginning);
                    this.addDefinition(key, value);
                }
            } else {
                this.handleProblem(0x2000005, "#define " + key + " /" + this.getRestOfPreprocessorLine(), beginning, false, true, true);
                return;
lbl102:
                // 1 sources

                this.log.traceLog("Scanner : Encountered unexpected character " + (char)c);
                this.handleProblem(0x2000005, "#define " + key + (char)c + this.getRestOfPreprocessorLine(), beginning, false, true, true);
                return;
            }
        }
        try {
            this.astFactory.createMacro(key, beginning, offset, offset + key.length(), this.contextStack.getCurrentContext().getOffset()).acceptElement(this.requestor);
        }
        catch (Exception v2) {}
    }

    /*
     * Unable to fully structure code
     */
    protected void checkValidMacroRedefinition(String key, Object previousDefinition, Object newDefinition, int beginningOffset) throws ScannerException {
        if (this.mode == ParserMode.COMPLETE_PARSE && previousDefinition != null) {
            if (newDefinition instanceof IMacroDescriptor) {
                if (previousDefinition instanceof IMacroDescriptor && ((IMacroDescriptor)previousDefinition).compatible((IMacroDescriptor)newDefinition)) {
                    return;
                }
            } else if (newDefinition instanceof String && previousDefinition instanceof String) {
                previous = new Scanner(new StringReader((String)previousDefinition), "redef-test", new ScannerInfo(), new NullSourceElementRequestor(), this.mode, this.language, this.log);
                current = new Scanner(new StringReader((String)newDefinition), "redef-test", new ScannerInfo(), new NullSourceElementRequestor(), this.mode, this.language, this.log);
                while (true) {
                    p = null;
                    c = null;
                    try {
                        p = previous.nextToken();
                        c = current.nextToken();
                        if (!c.equals(p)) break;
                        continue;
                    }
                    catch (EndOfFile v0) {
                        if (p != null && c == null) break;
                        if (p == null) ** break;
                        continue;
                        try {
                            c = current.nextToken();
                        }
                        catch (EndOfFile v1) {
                            return;
                        }
                    }
                    break;
                }
            }
            this.handleProblem(0x2000007, key, beginningOffset, false, true, true);
        }
    }

    protected Vector getMacroParameters(String params, boolean forStringizing) throws ScannerException {
        Scanner tokenizer = new Scanner(new StringReader(params), TEXT, new ScannerInfo(this.definitions, this.originalConfig.getIncludePaths()), new NullSourceElementRequestor(), this.mode, this.language, this.log);
        tokenizer.setThrowExceptionOnBadCharacterRead(false);
        Vector<String> parameterValues = new Vector<String>();
        Token t = null;
        String str = new String();
        boolean space = false;
        int nParen = 0;
        try {
            while (true) {
                int c;
                if ((c = tokenizer.getChar()) != 32 && c != 9 && c != 13 && c != 10) {
                    space = false;
                }
                if (c != -1) {
                    tokenizer.ungetChar(c);
                }
                t = (Token)(forStringizing ? tokenizer.nextTokenForStringizing() : tokenizer.nextToken(false));
                if (t.type == 8) {
                    ++nParen;
                } else if (t.type == 9) {
                    --nParen;
                } else if (t.type == 6 && nParen == 0) {
                    parameterValues.add(str);
                    str = "";
                    space = false;
                    continue;
                }
                if (space) {
                    str = String.valueOf(str) + ' ';
                }
                switch (t.type) {
                    case 130: {
                        str = String.valueOf(str) + '\"' + t.image + '\"';
                        break;
                    }
                    case 131: {
                        str = String.valueOf(str) + "L\"" + t.image + '\"';
                        break;
                    }
                    case 132: {
                        str = String.valueOf(str) + '\'' + t.image + '\'';
                        break;
                    }
                    default: {
                        str = String.valueOf(str) + t.image;
                    }
                }
                space = true;
            }
        }
        catch (EndOfFile endOfFile) {
            parameterValues.add(str);
            return parameterValues;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void expandDefinition(String symbol, Object expansion, int symbolOffset) throws ScannerException {
        if (expansion instanceof String) {
            replacementValue = (String)expansion;
            try {
                this.contextStack.updateContext(new StringReader(replacementValue), "#define " + symbol, 3, null, this.requestor, symbolOffset, symbol.length());
            }
            catch (ContextException e) {
                this.handleProblem(e.getId(), this.contextStack.getCurrentContext().getFilename(), this.getCurrentOffset(), false, true, true);
                this.consumeUntilOutOfMacroExpansion();
                return;
            }
        }
        if (!(expansion instanceof IMacroDescriptor)) ** GOTO lbl124
        macro = (IMacroDescriptor)expansion;
        this.skipOverWhitespace();
        c = this.getChar();
        if (c == 40) {
            buffer = new StringBuffer();
            bracketCount = 1;
            c = this.getChar();
            while (true) {
                if (c == 40) {
                    ++bracketCount;
                } else if (c == 41) {
                    --bracketCount;
                }
                if (bracketCount == 0 || c == -1) break;
                buffer.append((char)c);
                c = this.getChar(true);
            }
            endMacroOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 1;
            betweenTheBrackets = buffer.toString().trim();
            parameterValues = this.getMacroParameters(betweenTheBrackets, false);
            parameterValuesForStringizing = this.getMacroParameters(betweenTheBrackets, true);
            t = null;
            buffer = new StringBuffer();
            tokens = macro.getTokenizedExpansion();
            parameterNames = macro.getParameters();
            if (parameterNames.size() != parameterValues.size()) {
                this.handleProblem(0x2000009, symbol, this.getCurrentOffset(), false, true, true);
                this.consumeUntilOutOfMacroExpansion();
                return;
            }
            numberOfTokens = tokens.size();
            i = 0;
            while (i < numberOfTokens) {
                t = (Token)tokens.get(i);
                if (t.type == 1) {
                    index = parameterNames.indexOf(t.image);
                    if (index == -1) {
                        buffer.append(t.image);
                    } else {
                        buffer.append((String)parameterValues.elementAt(index));
                    }
                } else if (t.type == -7) {
                    t = (Token)tokens.get(++i);
                    index = parameterNames.indexOf(t.image);
                    if (index == -1) {
                        this.handleProblem(0x2000009, macro.getName(), this.getCurrentOffset(), false, true, true);
                        return;
                    }
                    buffer.append('\"');
                    value = (String)parameterValuesForStringizing.elementAt(index);
                    val = value.toCharArray();
                    length = value.length();
                    j = 0;
                    while (j < length) {
                        ch = val[j];
                        if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                            while (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                                ch = val[++j];
                            }
                            buffer.append(' ');
                        }
                        if (ch == '\"' || ch == '\\') {
                            buffer.append('\\');
                            buffer.append(ch);
                        } else {
                            buffer.append(ch);
                        }
                        ++j;
                    }
                    buffer.append('\"');
                } else {
                    switch (t.type) {
                        case 130: {
                            buffer.append(String.valueOf('\"') + t.image + '\"');
                            break;
                        }
                        case 131: {
                            buffer.append("L\"" + t.image + '\"');
                            break;
                        }
                        case 132: {
                            buffer.append(String.valueOf('\'') + t.image + '\'');
                            break;
                        }
                        default: {
                            buffer.append(t.image);
                        }
                    }
                }
                pastingNext = false;
                if (i != numberOfTokens - 1 && (t2 = (IToken)tokens.get(i + 1)).getType() == -6) {
                    pastingNext = true;
                    ++i;
                }
                if (t.getType() != -6 && !pastingNext && i < numberOfTokens - 1) {
                    buffer.append(" ");
                }
                ++i;
            }
            finalString = buffer.toString();
            try {
                this.contextStack.updateContext(new StringReader(finalString), "#define " + macro.getSignature(), 3, null, this.requestor, symbolOffset, endMacroOffset - symbolOffset + 1);
            }
            catch (ContextException e) {
                this.handleProblem(e.getId(), this.contextStack.getCurrentContext().getFilename(), this.getCurrentOffset(), false, true, true);
                this.consumeUntilOutOfMacroExpansion();
                return;
            }
        } else {
            this.handleProblem(0x2000009, symbol, this.getCurrentOffset(), false, true, true);
            this.consumeUntilOutOfMacroExpansion();
            return;
lbl124:
            // 1 sources

            this.log.traceLog("Unexpected class stored in definitions table. " + expansion.getClass().getName());
        }
    }

    protected String handleDefinedMacro() throws ScannerException {
        int o = this.getCurrentOffset();
        this.skipOverWhitespace();
        int c = this.getChar();
        String definitionIdentifier = null;
        if (c == 40) {
            definitionIdentifier = this.getNextIdentifier();
            this.skipOverWhitespace();
            c = this.getChar();
            if (c != 41) {
                this.handleProblem(0x2000009, "defined()", o, false, true, true);
                return "0";
            }
        } else {
            this.ungetChar(c);
            definitionIdentifier = this.getNextIdentifier();
        }
        if (this.definitions.get(definitionIdentifier) != null) {
            return "1";
        }
        return "0";
    }

    public void setLanguage(ParserLanguage value) {
        this.language = value;
    }

    public void setThrowExceptionOnBadCharacterRead(boolean throwOnBad) {
        this.throwExceptionOnBadCharacterRead = throwOnBad;
    }

    public void setASTFactory(IASTFactory f) {
        this.astFactory = f;
    }

    public int getLineNumberForOffset(int i) {
        ILineOffsetReconciler reconciler = ParserFactory.createLineOffsetReconciler(this.backupReader);
        return reconciler.getLineNumberForOffset(i);
    }

    protected static class endOfMacroTokenException
    extends Exception {
        protected endOfMacroTokenException() {
        }
    }

    public static class PreprocessorDirectives {
        public static final int DEFINE = 0;
        public static final int UNDEFINE = 1;
        public static final int IF = 2;
        public static final int IFDEF = 3;
        public static final int IFNDEF = 4;
        public static final int ELSE = 5;
        public static final int ENDIF = 6;
        public static final int INCLUDE = 7;
        public static final int LINE = 8;
        public static final int ERROR = 9;
        public static final int PRAGMA = 10;
        public static final int BLANK = 11;
        public static final int ELIF = 12;
    }
}

