/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;

public class ASTExpression
implements IASTExpression {
    private final IASTExpression.Kind kind;
    private final IASTExpression lhs;
    private final IASTExpression rhs;
    private final IASTExpression third;
    private final IASTTypeId typeId;
    private final String literal;
    private final String idExpression;
    private final IASTExpression.IASTNewExpressionDescriptor newDescriptor;

    public ASTExpression(IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression third, IASTTypeId typeId, String idExpression, String literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor) {
        this.kind = kind;
        this.lhs = lhs;
        this.rhs = rhs;
        this.third = third;
        this.typeId = typeId;
        this.literal = literal;
        this.newDescriptor = newDescriptor;
        this.idExpression = idExpression;
    }

    public IASTExpression.Kind getExpressionKind() {
        return this.kind;
    }

    public IASTExpression getLHSExpression() {
        return this.lhs;
    }

    public IASTExpression getRHSExpression() {
        return this.rhs;
    }

    public String getLiteralString() {
        return this.literal;
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return this.newDescriptor;
    }

    public IASTExpression getThirdExpression() {
        return this.third;
    }

    public int evaluateExpression() throws ExpressionEvaluationException {
        if (this.getExpressionKind() == IASTExpression.Kind.PRIMARY_INTEGER_LITERAL) {
            try {
                if (this.getLiteralString().startsWith("0x") || this.getLiteralString().startsWith("0x")) {
                    return Integer.parseInt(this.getLiteralString().substring(2), 16);
                }
                if (this.getLiteralString().startsWith("0") && this.getLiteralString().length() > 1) {
                    return Integer.parseInt(this.getLiteralString().substring(1), 8);
                }
                return Integer.parseInt(this.getLiteralString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExpressionEvaluationException();
            }
        }
        if (this.getExpressionKind() == IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION) {
            return this.getLHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() == 0 ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY) {
            return this.getLHSExpression().evaluateExpression() * this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_DIVIDE) {
            return this.getLHSExpression().evaluateExpression() / this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_MODULUS) {
            return this.getLHSExpression().evaluateExpression() % this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.ADDITIVE_PLUS) {
            return this.getLHSExpression().evaluateExpression() + this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.ADDITIVE_MINUS) {
            return this.getLHSExpression().evaluateExpression() - this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.SHIFT_LEFT) {
            return this.getLHSExpression().evaluateExpression() << this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.SHIFT_RIGHT) {
            return this.getLHSExpression().evaluateExpression() >> this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_LESSTHAN) {
            return this.getLHSExpression().evaluateExpression() < this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_GREATERTHAN) {
            return this.getLHSExpression().evaluateExpression() > this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO) {
            return this.getLHSExpression().evaluateExpression() <= this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO) {
            return this.getLHSExpression().evaluateExpression() >= this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.EQUALITY_EQUALS) {
            return this.getLHSExpression().evaluateExpression() == this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.EQUALITY_NOTEQUALS) {
            return this.getLHSExpression().evaluateExpression() != this.getRHSExpression().evaluateExpression() ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.ANDEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() & this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.EXCLUSIVEOREXPRESSION) {
            return this.getLHSExpression().evaluateExpression() ^ this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.INCLUSIVEOREXPRESSION) {
            return this.getLHSExpression().evaluateExpression() | this.getRHSExpression().evaluateExpression();
        }
        if (this.getExpressionKind() == IASTExpression.Kind.LOGICALANDEXPRESSION) {
            return this.getLHSExpression().evaluateExpression() != 0 && this.getRHSExpression().evaluateExpression() != 0 ? 1 : 0;
        }
        if (this.getExpressionKind() == IASTExpression.Kind.LOGICALOREXPRESSION) {
            return this.getLHSExpression().evaluateExpression() != 0 || this.getRHSExpression().evaluateExpression() != 0 ? 1 : 0;
        }
        throw new ExpressionEvaluationException();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void reconcileReferences() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public void purgeReferences() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }
}

