/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.parser.Enum;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.TemplateInstance;

public class TypeInfo {
    public static final int typeMask = 31;
    public static final int isAuto = 32;
    public static final int isRegister = 64;
    public static final int isStatic = 128;
    public static final int isExtern = 256;
    public static final int isMutable = 512;
    public static final int isInline = 1024;
    public static final int isVirtual = 2048;
    public static final int isExplicit = 4096;
    public static final int isTypedef = 8192;
    public static final int isFriend = 16384;
    public static final int isConst = 32768;
    public static final int isVolatile = 65536;
    public static final int isUnsigned = 131072;
    public static final int isShort = 262144;
    public static final int isLong = 524288;
    public static final int isForward = 0x100000;
    public static final int isComplex = 0x200000;
    public static final int isImaginary = 0x400000;
    public static final eType t_any = new eType(-1);
    public static final eType t_undef = new eType(0);
    public static final eType t_type = new eType(1);
    public static final eType t_namespace = new eType(2);
    public static final eType t_class = new eType(3);
    public static final eType t_struct = new eType(4);
    public static final eType t_union = new eType(5);
    public static final eType t_enumeration = new eType(6);
    public static final eType t_constructor = new eType(7);
    public static final eType t_function = new eType(8);
    public static final eType t_bool = new eType(9);
    public static final eType t_char = new eType(10);
    public static final eType t_wchar_t = new eType(11);
    public static final eType t_int = new eType(12);
    public static final eType t_float = new eType(13);
    public static final eType t_double = new eType(14);
    public static final eType t_void = new eType(15);
    public static final eType t_enumerator = new eType(16);
    public static final eType t_block = new eType(17);
    public static final eType t_template = new eType(18);
    public static final eType t_asm = new eType(19);
    public static final eType t_linkage = new eType(20);
    public static final eType t__Bool = new eType(21);
    private static final String[] _image = new String[]{"", "", "namespace", "class", "struct", "union", "enum", "", "", "bool", "char", "wchar_t", "int", "float", "double", "void", "", "", "template", "", ""};
    public static final int cvConst = 2;
    public static final int cvVolatile = 3;
    public static final int cvConstVolatile = 5;
    private int _typeInfo = 0;
    private eType _type = t_undef;
    private ISymbol _typeDeclaration;
    private boolean _hasDefaultValue = false;
    private Object _defaultValue = null;
    private LinkedList _ptrOperators;
    private LinkedList _operatorExpressions;

    public TypeInfo() {
    }

    public TypeInfo(eType type, int info, ISymbol symbol) {
        this._typeInfo = info;
        this._type = type;
        this._typeDeclaration = symbol;
    }

    public TypeInfo(eType type, int info, ISymbol symbol, PtrOp op, boolean hasDefault) {
        this._typeInfo = info;
        this._type = type;
        this._typeDeclaration = symbol;
        if (op != null) {
            this._ptrOperators = new LinkedList();
            this._ptrOperators.add(op);
        } else {
            this._ptrOperators = null;
        }
        this._hasDefaultValue = hasDefault;
    }

    public TypeInfo(eType type, int info, ISymbol symbol, PtrOp op, Object def) {
        this._typeInfo = info;
        this._type = type;
        this._typeDeclaration = symbol;
        if (op != null) {
            this._ptrOperators = new LinkedList();
            this._ptrOperators.add(op);
        } else {
            this._ptrOperators = null;
        }
        this._hasDefaultValue = true;
        this.setDefault(def);
    }

    public TypeInfo(TypeInfo info) {
        this._typeInfo = info._typeInfo;
        this._type = info._type;
        this._typeDeclaration = info._typeDeclaration;
        this._ptrOperators = info._ptrOperators == null ? null : (LinkedList)info._ptrOperators.clone();
        this._hasDefaultValue = info._hasDefaultValue;
    }

    public void setBit(boolean b, int mask) {
        this._typeInfo = b ? (this._typeInfo |= mask) : (this._typeInfo &= ~mask);
    }

    public boolean checkBit(int mask) {
        return (this._typeInfo & mask) != 0;
    }

    public void setType(eType t) {
        this._type = t;
    }

    public eType getType() {
        return this._type;
    }

    public boolean isType(eType type) {
        return this.isType(type, t_undef);
    }

    public int getTypeInfo() {
        return this._typeInfo;
    }

    public void setTypeInfo(int typeInfo) {
        this._typeInfo = typeInfo;
    }

    public boolean isType(eType type, eType upperType) {
        if (type == t_any) {
            return true;
        }
        if (upperType == t_undef) {
            return this.getType() == type;
        }
        return this.getType().compareTo(type) >= 0 && this.getType().compareTo(upperType) <= 0;
    }

    public ISymbol getTypeSymbol() {
        return this._typeDeclaration;
    }

    public void setTypeSymbol(ISymbol type) {
        this._typeDeclaration = type;
    }

    public boolean hasPtrOperators() {
        return this._ptrOperators != null && this._ptrOperators.size() > 0;
    }

    public List getPtrOperators() {
        if (this._ptrOperators == null) {
            this._ptrOperators = new LinkedList();
        }
        return this._ptrOperators;
    }

    public boolean hasSamePtrs(TypeInfo type) {
        int i;
        int size = this.getPtrOperators().size();
        int size2 = type.getPtrOperators().size();
        Iterator iter1 = this.getPtrOperators().iterator();
        Iterator iter2 = type.getPtrOperators().iterator();
        PtrOp ptr1 = null;
        PtrOp ptr2 = null;
        if (size2 < size) {
            i = size;
            while (i > size2) {
                ptr2 = (PtrOp)iter1.next();
                if (ptr2.getType() != PtrOp.t_undef) {
                    return false;
                }
                --i;
            }
            size = size2;
        } else if (size < size2) {
            i = size2;
            while (i > size) {
                ptr1 = (PtrOp)iter2.next();
                if (ptr1.getType() != PtrOp.t_undef) {
                    return false;
                }
                --i;
            }
            size2 = size;
        }
        if (size == size2) {
            if (size > 0) {
                i = size;
                while (i > 0) {
                    ptr1 = (PtrOp)iter1.next();
                    ptr2 = (PtrOp)iter2.next();
                    if (ptr1.getType() != ptr2.getType()) {
                        return false;
                    }
                    --i;
                }
            }
            return true;
        }
        return false;
    }

    public List getOperatorExpressions() {
        if (this._operatorExpressions == null) {
            this._operatorExpressions = new LinkedList();
        }
        return this._operatorExpressions;
    }

    public void applyOperatorExpressions(List ops) {
        if (ops == null || ops.isEmpty()) {
            return;
        }
        int size = ops.size();
        Iterator iter = ops.iterator();
        OperatorExpression op = null;
        int i = size;
        while (i > 0) {
            op = (OperatorExpression)iter.next();
            if (op == OperatorExpression.indirection || op == OperatorExpression.subscript) {
                ListIterator iterator;
                PtrOp last;
                if (this.hasPtrOperators() && ((last = (PtrOp)(iterator = this.getPtrOperators().listIterator(this.getPtrOperators().size())).previous()).getType() == PtrOp.t_pointer || last.getType() == PtrOp.t_array)) {
                    iterator.remove();
                }
            } else if (op == OperatorExpression.addressof) {
                PtrOp newOp = new PtrOp(PtrOp.t_pointer);
                this.addPtrOperator(newOp);
            }
            --i;
        }
    }

    public void addPtrOperator(PtrOp ptr) {
        if (this._ptrOperators == null) {
            this._ptrOperators = new LinkedList();
        }
        if (ptr != null) {
            this._ptrOperators.add(ptr);
        }
    }

    public void addPtrOperator(List ptrs) {
        if (this._ptrOperators == null) {
            this._ptrOperators = new LinkedList();
        }
        if (ptrs != null) {
            this._ptrOperators.addAll(ptrs);
        }
    }

    public void addOperatorExpression(OperatorExpression exp) {
        if (this._operatorExpressions == null) {
            this._operatorExpressions = new LinkedList();
        }
        this._operatorExpressions.add(exp);
    }

    public boolean getHasDefault() {
        return this._hasDefaultValue;
    }

    public void setHasDefault(boolean def) {
        this._hasDefaultValue = def;
    }

    public void setDefault(Object t) {
        this._defaultValue = t;
    }

    public Object getDefault() {
        return this._defaultValue;
    }

    public boolean isForwardDeclaration() {
        return this.checkBit(0x100000);
    }

    public void setIsForwardDeclaration(boolean forward) {
        this.setBit(forward, 0x100000);
    }

    public boolean canHold(TypeInfo type) {
        return this.getType().compareTo(type.getType()) >= 0;
    }

    public boolean equals(Object t) {
        int size2;
        if (t == null || !(t instanceof TypeInfo)) {
            return false;
        }
        TypeInfo type = (TypeInfo)t;
        boolean result = this._typeInfo == type._typeInfo;
        result &= this._type == type._type;
        result = this._typeDeclaration instanceof TemplateInstance ? (result &= this._typeDeclaration.equals(type._typeDeclaration)) : (this._typeDeclaration != null && type._typeDeclaration != null && this._typeDeclaration.isType(t_bool, t_void) && type._typeDeclaration.isType(t_bool, t_void) ? (result &= this._typeDeclaration.getType() == type._typeDeclaration.getType()) : (result &= this._typeDeclaration == type._typeDeclaration));
        int size1 = this._ptrOperators == null ? 0 : this._ptrOperators.size();
        int n = size2 = type._ptrOperators == null ? 0 : type._ptrOperators.size();
        if (size1 == size2) {
            if (size1 != 0) {
                Iterator iter1 = this._ptrOperators.iterator();
                Iterator iter2 = type._ptrOperators.iterator();
                PtrOp op1 = null;
                PtrOp op2 = null;
                int i = size1;
                while (i > 0) {
                    op1 = (PtrOp)iter1.next();
                    if (!op1.equals(op2 = (PtrOp)iter2.next())) {
                        return false;
                    }
                    --i;
                }
            }
        } else {
            return false;
        }
        return result;
    }

    public String toString() {
        if (this.isType(t_type)) {
            return this._typeDeclaration.getName();
        }
        return _image[this.getType().toInt()];
    }

    public static class eType
    implements Comparable {
        private int _val;

        protected eType(int v) {
            this._val = v;
        }

        public int compareTo(Object o) {
            eType t = (eType)o;
            return this._val - t._val;
        }

        public int toInt() {
            return this._val;
        }
    }

    public static class OperatorExpression
    extends Enum {
        public static final OperatorExpression indirection = new OperatorExpression(1);
        public static final OperatorExpression addressof = new OperatorExpression(0);
        public static final OperatorExpression subscript = new OperatorExpression(2);

        protected OperatorExpression(int enumValue) {
            super(enumValue);
        }
    }

    public static class PtrOp {
        public static final eType t_undef = new eType(0);
        public static final eType t_pointer = new eType(1);
        public static final eType t_reference = new eType(2);
        public static final eType t_array = new eType(3);
        public static final eType t_memberPointer = new eType(4);
        private eType type = t_undef;
        private boolean isConst = false;
        private boolean isVolatile = false;
        private ISymbol memberOf = null;

        public PtrOp(eType type) {
            this.type = type;
        }

        public PtrOp(eType type, boolean isConst, boolean isVolatile) {
            this.type = type;
            this.isConst = isConst;
            this.isVolatile = isVolatile;
        }

        public PtrOp(ISymbol memberOf, boolean isConst, boolean isVolatile) {
            this.type = t_memberPointer;
            this.isConst = isConst;
            this.isVolatile = isVolatile;
            this.memberOf = memberOf;
        }

        public PtrOp() {
        }

        public eType getType() {
            return this.type;
        }

        public void setType(eType type) {
            this.type = type;
        }

        public boolean isConst() {
            return this.isConst;
        }

        public boolean isVolatile() {
            return this.isVolatile;
        }

        public void setConst(boolean isConst) {
            this.isConst = isConst;
        }

        public void setVolatile(boolean isVolatile) {
            this.isVolatile = isVolatile;
        }

        public ISymbol getMemberOf() {
            return this.memberOf;
        }

        public void setMemberOf(ISymbol member) {
            this.memberOf = member;
        }

        public int compareCVTo(PtrOp ptr) {
            int cv1 = (this.isConst() ? 1 : 0) + (this.isVolatile() ? 1 : 0);
            int cv2 = (ptr.isConst() ? 1 : 0) + (ptr.isVolatile() ? 1 : 0);
            return cv1 - cv2;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof PtrOp)) {
                return false;
            }
            PtrOp op = (PtrOp)o;
            return this.isConst() == op.isConst() && this.isVolatile() == op.isVolatile() && this.getType() == op.getType();
        }
    }
}

