/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.BuildInfoFactory;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.IStandardBuildInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName("org.eclipse.cdt.core", "standardBuildInfo");
    private static final String ID = "org.eclipse.cdt.core.standardBuildInfo";
    public static final String INTERFACE_IDENTITY = "org.eclipse.cdt.core.StandardBuildManager";
    private static Map buildModelListeners;

    private static IStandardBuildInfo findBuildInfo(IResource resource, boolean create) throws CoreException {
        IStandardBuildInfo buildInfo = null;
        try {
            buildInfo = (IStandardBuildInfo)resource.getSessionProperty(buildInfoProperty);
        }
        catch (CoreException coreException) {}
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = StandardBuildManager.loadBuildInfo((IProject)resource);
        }
        if (buildInfo == null && create) {
            buildInfo = BuildInfoFactory.create((IProject)resource);
            try {
                ((IProject)resource).setSessionProperty(buildInfoProperty, (Object)buildInfo);
            }
            catch (CoreException coreException) {
                buildInfo = null;
            }
        }
        return buildInfo;
    }

    public static IStandardBuildInfo getBuildInfo(IProject project) throws CoreException {
        return StandardBuildManager.findBuildInfo((IResource)project, false);
    }

    public static IStandardBuildInfo getBuildInfo(IProject project, boolean create) throws CoreException {
        return StandardBuildManager.findBuildInfo((IResource)project, create);
    }

    private static synchronized Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public static void setPreprocessorSymbols(IProject project, String[] symbols) throws CoreException {
        Object[] oldSymbols;
        IStandardBuildInfo info = StandardBuildManager.getBuildInfo(project);
        if (info != null && !Arrays.equals(oldSymbols = info.getPreprocessorSymbols(), symbols)) {
            info.setPreprocessorSymbols(symbols);
            StandardBuildManager.setScannerInfoDirty(project, info);
        }
    }

    public static void setIncludePaths(IProject project, String[] paths) throws CoreException {
        Object[] oldPaths;
        IStandardBuildInfo info = StandardBuildManager.getBuildInfo(project);
        if (info != null && !Arrays.equals(oldPaths = info.getIncludePaths(), paths)) {
            info.setIncludePaths(paths);
            StandardBuildManager.setScannerInfoDirty(project, info);
        }
    }

    private static void setScannerInfoDirty(IProject project, IStandardBuildInfo info) {
        List listeners = (List)StandardBuildManager.getBuildModelListeners().get(project);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification((IResource)project, (IScannerInfo)info);
        }
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        IStandardBuildInfo info;
        try {
            info = StandardBuildManager.getBuildInfo((IProject)resource);
        }
        catch (CoreException coreException) {
            return null;
        }
        return (IScannerInfo)info;
    }

    private static IStandardBuildInfo loadBuildInfo(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
        IStandardBuildInfo buildInfo = BuildInfoFactory.create(project, descriptor.getProjectData(ID));
        project.setSessionProperty(buildInfoProperty, (Object)buildInfo);
        return buildInfo;
    }

    public static void removeBuildInfo(IResource resource) {
        try {
            resource.setSessionProperty(buildInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void saveBuildInfo(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project);
        Element rootElement = descriptor.getProjectData(ID);
        Node child = rootElement.getFirstChild();
        while (child != null) {
            rootElement.removeChild(child);
            child = rootElement.getFirstChild();
        }
        IStandardBuildInfo buildInfo = StandardBuildManager.getBuildInfo(project);
        if (buildInfo != null) {
            buildInfo.serialize(rootElement.getOwnerDocument(), rootElement);
        }
        descriptor.saveProjectData();
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = StandardBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = StandardBuildManager.getBuildModelListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }
}

