/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CopyResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.DeleteResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MoveResourceElementsOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.RenameResourceElementsOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class CModel
extends CContainer
implements ICModel {
    public CModel() {
        this(ResourcesPlugin.getWorkspace().getRoot());
    }

    public CModel(IWorkspaceRoot root) {
        super(null, (IResource)root, 10);
    }

    public ICProject getCProject(String name) {
        IProject project = this.getWorkspace().getRoot().getProject(name);
        return CModelManager.getDefault().create(project);
    }

    public ICProject[] getCProjects() {
        ArrayList list = this.getChildrenOfType(11);
        ICProject[] array = new ICProject[list.size()];
        list.toArray(array);
        return array;
    }

    public IWorkspace getWorkspace() {
        return this.getUnderlyingResource().getWorkspace();
    }

    public void copy(ICElement[] elements, ICElement[] containers, ICElement[] siblings, String[] renamings, boolean replace, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new CopyResourceElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
    }

    public void delete(ICElement[] elements, boolean force, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new DeleteResourceElementsOperation(elements, force), monitor);
    }

    public void move(ICElement[] elements, ICElement[] containers, ICElement[] siblings, String[] renamings, boolean replace, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new MoveResourceElementsOperation(elements, containers, replace), elements, siblings, renamings, monitor);
    }

    public void rename(ICElement[] elements, ICElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws CModelException {
        if (elements == null || elements[0] == null || elements[0].getElementType() > 60) {
            throw new CModelException(new CModelStatus());
        }
        this.runOperation(new RenameResourceElementsOperation(elements, destinations, renamings, force), monitor);
    }

    protected void runOperation(MultiOperation op, ICElement[] elements, ICElement[] siblings, String[] renamings, IProgressMonitor monitor) throws CModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        this.runOperation(op, monitor);
    }

    protected CElementInfo createElementInfo() {
        return new CModelInfo(this);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

