/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.sourcedependency;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class UpdateDependency
implements IJob {
    PathCollector pathCollector;
    IResource resource;

    public UpdateDependency(IResource resource) {
        this.resource = resource;
    }

    public boolean belongsTo(String jobFamily) {
        return false;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor progress) {
        if (this.resource == null) {
            return false;
        }
        PathCollector pathCollector = new PathCollector();
        ICSearchScope scope = SearchEngine.createWorkspaceScope();
        CSearchPattern pattern = CSearchPattern.createPattern(this.resource.getLocation().toOSString(), ICSearchConstants.INCLUDE, ICSearchConstants.REFERENCES, 0, true);
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, pathCollector, indexManager), 3, null, this);
        String[] iPath = pathCollector.getPaths();
        int i = 0;
        while (i < iPath.length) {
            Path pathToReindex = new Path(iPath[i]);
            IWorkspaceRoot workRoot = this.resource.getWorkspace().getRoot();
            IFile fileToReindex = workRoot.getFile((IPath)pathToReindex);
            if (fileToReindex != null && fileToReindex.exists()) {
                indexManager.addSource(fileToReindex, fileToReindex.getProject().getProject().getFullPath());
            }
            ++i;
        }
        return false;
    }

    public boolean isReadyToRun() {
        return true;
    }
}

