/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.utils.coff.PE;

public class PEArchive {
    protected String filename;
    protected RandomAccessFile rfile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    public void dispose() {
        try {
            if (this.rfile != null) {
                this.rfile.close();
                this.rfile = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] ident) {
        return ident.length >= 7 && ident[0] == 33 && ident[1] == 60 && ident[2] == 97 && ident[3] == 114 && ident[4] == 99 && ident[5] == 104 && ident[6] == 62;
    }

    public PEArchive(String filename) throws IOException {
        this.filename = filename;
        this.rfile = new RandomAccessFile(filename, "r");
        String hdr = this.rfile.readLine();
        if (hdr == null || hdr.compareTo("!<arch>") != 0) {
            this.rfile.close();
            throw new IOException("Not a valid archive file.");
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> v = new Vector<ARHeader>();
        try {
            while (this.rfile.getFilePointer() < this.rfile.length()) {
                ARHeader header = new ARHeader();
                String name = header.getObjectName();
                long pos = this.rfile.getFilePointer();
                if (name.charAt(0) != '/') {
                    v.add(header);
                }
                if (name.compareTo("//") == 0) {
                    this.strtbl_pos = pos;
                }
                if ((pos += header.getSize()) % 2L != 0L) {
                    ++pos;
                }
                this.rfile.seek(pos);
            }
        }
        catch (IOException iOException) {}
        this.headers = v.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String str, String[] set) {
        int i = 0;
        while (i < set.length) {
            if (str.compareTo(set[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] extractFiles(String outdir, String[] names) throws IOException {
        Vector<String> names_used = new Vector<String>();
        this.loadHeaders();
        int count = 0;
        int i = 0;
        while (i < this.headers.length) {
            String object_name = this.headers[i].getObjectName();
            if (names == null || this.stringInStrings(object_name, names)) {
                object_name = count + "_" + object_name;
                ++count;
                byte[] data = this.headers[i].getObjectData();
                File output = new File(outdir, object_name);
                names_used.add(object_name);
                RandomAccessFile rfile = new RandomAccessFile(output, "rw");
                rfile.write(data);
                rfile.close();
            }
            ++i;
        }
        return names_used.toArray(new String[0]);
    }

    public String[] extractFiles(String outdir) throws IOException {
        return this.extractFiles(outdir, null);
    }

    public class ARHeader {
        private String object_name;
        private String modification_time;
        private String uid;
        private String gid;
        private String mode;
        private long size;
        private long elf_offset;

        private String removeBlanks(String str) {
            while (str.charAt(str.length() - 1) == ' ') {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String nameFromStringTable(long offset) throws IOException {
            StringBuffer name = new StringBuffer(0);
            long pos = PEArchive.this.rfile.getFilePointer();
            try {
                if (PEArchive.this.strtbl_pos != -1L) {
                    byte temp;
                    PEArchive.this.rfile.seek(PEArchive.this.strtbl_pos + offset);
                    while ((temp = PEArchive.this.rfile.readByte()) != 10) {
                        name.append((char)temp);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                PEArchive.this.rfile.seek(pos);
                throw throwable;
            }
            {
                Object var7_7 = null;
            }
            PEArchive.this.rfile.seek(pos);
            return name.toString();
        }

        public ARHeader() throws IOException {
            int len;
            byte[] object_name = new byte[16];
            byte[] modification_time = new byte[12];
            byte[] uid = new byte[6];
            byte[] gid = new byte[6];
            byte[] mode = new byte[8];
            byte[] size = new byte[10];
            byte[] trailer = new byte[2];
            PEArchive.this.rfile.read(object_name);
            PEArchive.this.rfile.read(modification_time);
            PEArchive.this.rfile.read(uid);
            PEArchive.this.rfile.read(gid);
            PEArchive.this.rfile.read(mode);
            PEArchive.this.rfile.read(size);
            PEArchive.this.rfile.read(trailer);
            this.elf_offset = PEArchive.this.rfile.getFilePointer();
            this.object_name = this.removeBlanks(new String(object_name));
            this.modification_time = new String(modification_time);
            this.uid = new String(uid);
            this.gid = new String(gid);
            this.mode = new String(mode);
            this.size = Long.parseLong(this.removeBlanks(new String(size)));
            if (PEArchive.this.strtbl_pos != -1L && this.object_name.length() > 1 && this.object_name.charAt(0) == '/') {
                try {
                    long offset = Long.parseLong(this.object_name.substring(1));
                    this.object_name = this.nameFromStringTable(offset);
                }
                catch (Exception exception) {}
            }
            if ((len = this.object_name.length()) > 2 && this.object_name.charAt(len - 1) == '/') {
                this.object_name = this.object_name.substring(0, len - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public PE getPE() throws IOException {
            return new PE(PEArchive.this.filename, this.elf_offset);
        }

        public PE getPE(boolean filter_on) throws IOException {
            return new PE(PEArchive.this.filename, this.elf_offset, filter_on);
        }

        public byte[] getObjectData() throws IOException {
            byte[] temp = new byte[(int)this.size];
            PEArchive.this.rfile.seek(this.elf_offset);
            PEArchive.this.rfile.read(temp);
            return temp;
        }
    }
}

