/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsProvider;
import org.eclipse.cdt.utils.coff.Coff;
import org.eclipse.cdt.utils.coff.PE;
import org.eclipse.cdt.utils.coff.parser.BinaryFile;
import org.eclipse.cdt.utils.coff.parser.Symbol;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BinaryObject
extends BinaryFile
implements IBinaryParser.IBinaryObject {
    PE.Attribute attribute;
    IBinaryParser.ISymbol[] symbols;
    int type = 1;
    private IBinaryParser.ISymbol[] NO_SYMBOLS = new IBinaryParser.ISymbol[0];

    public BinaryObject(IPath p) throws IOException {
        super(p);
    }

    public BinaryObject(IPath p, PE pe, ICygwinToolsProvider provider) throws IOException {
        super(p);
        this.setToolsProvider(provider);
        this.loadInformation(pe);
        pe.dispose();
        this.hasChanged();
    }

    public void setType(int t) {
        this.type = t;
    }

    public IBinaryParser.ISymbol getSymbol(long addr) {
        Object[] syms = this.getSymbols();
        int insertion = Arrays.binarySearch(syms, new Long(addr));
        if (insertion > 0) {
            return syms[insertion];
        }
        if (insertion == -1) {
            return null;
        }
        insertion = -insertion - 1;
        return syms[insertion - 1];
    }

    public int getType() {
        return this.type;
    }

    public long getBSS() {
        return 0L;
    }

    public String getCPU() {
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.getCPU();
        }
        return "";
    }

    public long getData() {
        return 0L;
    }

    public String getName() {
        return this.getPath().lastSegment().toString();
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
            if (this.symbols == null) {
                this.symbols = this.NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    public long getText() {
        return 0L;
    }

    public boolean hasDebug() {
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            return attr.hasDebug();
        }
        return false;
    }

    public boolean isLittleEndian() {
        PE.Attribute attr = this.getAttribute();
        if (attr != null) {
            return attr.isLittleEndian();
        }
        return false;
    }

    public String[] getNeededSharedLibs() {
        return new String[0];
    }

    public String getSoName() {
        return "";
    }

    protected PE getPE() throws IOException {
        return new PE(this.getPath().toOSString());
    }

    /*
     * Exception decompiling
     */
    protected PE.Attribute getAttribute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 47->50)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loadInformation() throws IOException {
        PE pe = this.getPE();
        this.loadInformation(pe);
        pe.dispose();
    }

    private void loadInformation(PE pe) throws IOException {
        this.loadAttributes(pe);
        this.loadSymbols(pe);
    }

    private void loadAttributes(PE pe) throws IOException {
        this.attribute = pe.getAttribute();
    }

    private void loadSymbols(PE pe) throws IOException {
        ArrayList list = new ArrayList();
        Addr2line addr2line = this.getAddr2Line();
        CPPFilt cppfilt = this.getCPPFilt();
        CygPath cygpath = this.getCygPath();
        Coff.Symbol[] peSyms = pe.getSymbols();
        byte[] table = pe.getStringTable();
        this.addSymbols(peSyms, table, addr2line, cppfilt, cygpath, list);
        if (addr2line != null) {
            addr2line.dispose();
        }
        if (cppfilt != null) {
            cppfilt.dispose();
        }
        if (cygpath != null) {
            cygpath.dispose();
        }
        this.symbols = list.toArray(this.NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void addSymbols(Coff.Symbol[] peSyms, byte[] table, Addr2line addr2line, CPPFilt cppfilt, CygPath cygpath, List list) {
        int i = 0;
        while (i < peSyms.length) {
            String name;
            if ((peSyms[i].isFunction() || peSyms[i].isPointer() || peSyms[i].isArray()) && (name = peSyms[i].getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                Symbol sym = new Symbol(this);
                sym.type = peSyms[i].isFunction() ? 1 : 2;
                sym.addr = peSyms[i].n_value;
                sym.name = name;
                if (cppfilt != null) {
                    try {
                        sym.name = cppfilt.getFunction(sym.name);
                    }
                    catch (IOException iOException) {}
                }
                sym.filename = null;
                sym.startLine = 0;
                sym.endLine = 0;
                if (addr2line != null) {
                    try {
                        String filename = addr2line.getFileName(sym.addr);
                        if (filename != null && filename.equals("??")) {
                            filename = null;
                        }
                        if (filename != null) {
                            sym.filename = cygpath != null ? new Path(cygpath.getFileName(filename)) : new Path(filename);
                        }
                        sym.startLine = addr2line.getLineNumber(sym.addr);
                    }
                    catch (IOException iOException) {}
                }
                list.add(sym);
            }
            ++i;
        }
    }
}

