/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.makefile.IBadDirective;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefileValidator;
import org.eclipse.cdt.make.core.makefile.ISpecialRule;
import org.eclipse.cdt.make.core.makefile.gnu.IConditional;
import org.eclipse.cdt.make.core.makefile.gnu.ITerminal;
import org.eclipse.cdt.make.core.makefile.gnu.IVariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GNUMakefileValidator
implements IMakefileValidator {
    IMarkerGenerator reporter;

    public GNUMakefileValidator() {
    }

    public GNUMakefileValidator(IMarkerGenerator errorHandler) {
        this.setMarkerGenerator(errorHandler);
    }

    public void setMarkerGenerator(IMarkerGenerator errorHandler) {
        this.reporter = errorHandler;
    }

    public IMarkerGenerator getMarkerGenerator() {
        if (this.reporter == null) {
            this.reporter = new IMarkerGenerator(){

                public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
                    String name = "Makefile";
                    if (file != null) {
                        name = file.getName();
                    }
                    StringBuffer sb = new StringBuffer(name);
                    sb.append(':').append(lineNumber).append(':').append(this.getSeverity(severity));
                    if (errorDesc != null) {
                        sb.append(':').append(errorDesc);
                    }
                    if (errorVar != null) {
                        sb.append(':').append(errorVar);
                    }
                    sb.append('\n');
                    System.out.println(sb.toString());
                }

                public String getSeverity(int severity) {
                    if (severity == 3) {
                        return "Error Build";
                    }
                    if (severity == 2) {
                        return "Error resource";
                    }
                    if (severity == 0) {
                        return "Warning info";
                    }
                    if (severity == 1) {
                        return "Warning";
                    }
                    return "unknown";
                }
            };
        }
        return this.reporter;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkFile(IFile file, IProgressMonitor monitor) {
        block9: {
            String message = "Checking file : " + file.getFullPath().toString();
            monitor.subTask(message);
            GNUMakefile gnu = new GNUMakefile();
            InputStream stream = null;
            try {
                try {
                    stream = file.getContents();
                    InputStreamReader source = new InputStreamReader(stream);
                    gnu.parse(source);
                    this.validateDirectives((IResource)file, gnu.getDirectives());
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (stream == null) break block9;
            }
            try {}
            catch (IOException iOException) {}
            stream.close();
        }
        monitor.subTask("File checked");
        monitor.done();
    }

    public void validateDirectives(IResource res, IDirective[] directives) {
        int startLine;
        IMarkerGenerator marker = this.getMarkerGenerator();
        int conditionCount = 0;
        int defineCount = 0;
        IDirective directive = null;
        int i = 0;
        while (i < directives.length) {
            String varName;
            directive = directives[i];
            if (directive instanceof IConditional) {
                IConditional condition = (IConditional)directive;
                this.validateCondition(condition);
                if (!condition.isElse()) {
                    ++conditionCount;
                } else if (conditionCount == 0) {
                    int startLine2 = condition.getStartLine();
                    String msg = "else missing if condition";
                    int severity = 2;
                    varName = condition.toString().trim();
                    marker.addMarker(res, startLine2, msg, severity, varName);
                }
            } else if (directive instanceof ITerminal) {
                ITerminal terminal = (ITerminal)directive;
                if (terminal.isEndif()) {
                    if (conditionCount == 0) {
                        int startLine3 = terminal.getStartLine();
                        String msg = "Endif missing if/else condition";
                        int severity = 2;
                        varName = terminal.toString().trim();
                        marker.addMarker(res, startLine3, msg, severity, varName);
                    } else {
                        --conditionCount;
                    }
                } else if (terminal.isEndef()) {
                    if (defineCount == 0) {
                        int startLine4 = terminal.getStartLine();
                        String msg = "endef missing [override] define";
                        int severity = 2;
                        varName = terminal.toString().trim();
                        marker.addMarker(res, startLine4, msg, severity, varName);
                    } else {
                        --defineCount;
                    }
                }
            } else if (directive instanceof IVariableDefinition) {
                IVariableDefinition definition = (IVariableDefinition)directive;
                if (definition.isMultiLine()) {
                    ++defineCount;
                }
            } else if (directive instanceof IBadDirective) {
                int startLine5 = directive.getStartLine();
                String msg = "unknow directive";
                int severity = 2;
                String varName2 = directive.toString().trim();
                marker.addMarker(res, startLine5, msg, severity, varName2);
            } else if (directive instanceof ISpecialRule) {
                this.validateSpecialRule((ISpecialRule)directive);
            }
            ++i;
        }
        if (conditionCount > 0) {
            startLine = 0;
            String varName = "";
            int severity = 2;
            int i2 = directives.length - 1;
            while (i2 >= 0) {
                if (directives[i2] instanceof IConditional) {
                    startLine = directives[i2].getStartLine();
                    varName = directives[i2].toString().trim();
                    break;
                }
                --i2;
            }
            String msg = "No matching endif for condition";
            marker.addMarker(res, startLine, msg, severity, varName);
        }
        if (defineCount > 0) {
            startLine = 0;
            String varName = "";
            int severity = 2;
            int i3 = directives.length - 1;
            while (i3 >= 0) {
                IVariableDefinition definition;
                if (directives[i3] instanceof IVariableDefinition && (definition = (IVariableDefinition)directives[i3]).isMultiLine()) {
                    startLine = definition.getStartLine();
                    varName = definition.toString().trim();
                    break;
                }
                --i3;
            }
            String msg = "No matching endef for [override] define";
            marker.addMarker(res, startLine, msg, severity, varName);
        }
    }

    public void validateCondition(IConditional condition) {
    }

    public void validateSpecialRule(ISpecialRule rule) {
    }
}

