/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.contentassist;

import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryException;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.internal.core.contentassist.ContentAssistElementRequestor;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class CompletionEngine {
    protected IASTCompletionNode parse(IWorkingCopy sourceUnit, int completionOffset) {
        IScannerInfo buildScanInfo;
        ContentAssistElementRequestor requestor = new ContentAssistElementRequestor();
        IResource currentResource = sourceUnit.getResource();
        IPath realPath = currentResource.getLocation();
        IProject project = currentResource.getProject();
        CharArrayReader reader = new CharArrayReader(sourceUnit.getContents());
        ScannerInfo scanInfo = new ScannerInfo();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)project)) != null) {
            scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
        }
        ParserLanguage language = CoreModel.getDefault().hasCCNature(project) ? ParserLanguage.CPP : ParserLanguage.C;
        IParser parser = null;
        try {
            IScanner scanner = ParserFactory.createScanner((Reader)reader, (String)realPath.toOSString(), (IScannerInfo)scanInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)language, (ISourceElementRequestor)requestor, (IParserLogService)ParserUtil.getParserLogService());
            parser = ParserFactory.createParser((IScanner)scanner, (ISourceElementRequestor)requestor, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        if (parser != null) {
            IASTCompletionNode result = parser.parse(completionOffset);
            return result;
        }
        return null;
    }

    public List complete(IWorkingCopy sourceUnit, int completionOffset) {
        IASTCompletionNode completionNode = this.parse(sourceUnit, completionOffset);
        if (completionNode == null) {
            return null;
        }
        ArrayList completions = new ArrayList();
        if (completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.DOT_MEMBER && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.ARROW_MEMBER && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.QUALIFIEDNAME_MEMBER && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.FIELD_TYPE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.VARIABLE_TYPE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.ARGUMENT_TYPE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.METHOD_RETURN_TYPE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.FUNCTIOND_RETURN_TYPE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.SINGLE_NAME_REFERENCE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.QUALIFIED_NAME_REFERENCE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.STRUCTURE_REFERENCE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.CLASS_REFERENCE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.EXCEPTION_REFERENCE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.MACRO_REFERENCE && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.MESSAGE_SEND && completionNode.getCompletionKind() != IASTCompletionNode.CompletionKind.QUALIFIED_ALLOCATION_EXPRESSION) {
            completionNode.getCompletionKind();
        }
        return completions;
    }
}

