/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICPathEntry;

public class CPathEntry
implements ICPathEntry {
    public int entryKind;
    public boolean isExported;

    public CPathEntry(int entryKind, boolean isExported) {
        this.entryKind = entryKind;
        this.isExported = isExported;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICPathEntry) {
            ICPathEntry otherEntry = (ICPathEntry)obj;
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            return this.isExported == otherEntry.isExported();
        }
        return super.equals(obj);
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("inc")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("mac")) {
            return 7;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 6;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "inc";
            }
            case 7: {
                return "mac";
            }
            case 6: {
                return "con";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CDT_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CDT_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CDT_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CDT_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CDT_INCLUDE");
                break;
            }
            case 7: {
                buffer.append("CDT_MACRO");
                break;
            }
            case 6: {
                buffer.append("CDT_CONTAINER");
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

