/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.parser.EndOfFile;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IQuickParseCallback;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryException;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.IncludePattern;
import org.eclipse.cdt.internal.core.search.matching.MacroDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.OrPattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class CSearchPattern
implements ICSearchConstants,
ICSearchPattern,
IIndexConstants {
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int POSSIBLE_MATCH = 1;
    public static final int ACCURATE_MATCH = 2;
    public static final int INACCURATE_MATCH = 3;
    private static Requestor callback = new Requestor(ParserMode.COMPLETE_PARSE);
    protected int _matchMode;
    protected boolean _caseSensitive;
    protected ICSearchConstants.LimitTo _limitTo;

    public CSearchPattern(int matchMode, boolean caseSensitive, ICSearchConstants.LimitTo limitTo) {
        this._matchMode = matchMode;
        this._caseSensitive = caseSensitive;
        this._limitTo = limitTo;
    }

    public CSearchPattern() {
    }

    public ICSearchConstants.LimitTo getLimitTo() {
        return this._limitTo;
    }

    public boolean canAccept(ICSearchConstants.LimitTo limit) {
        return limit == this.getLimitTo();
    }

    public static CSearchPattern createPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (patternString == null || patternString.length() == 0) {
            return null;
        }
        CSearchPattern pattern = null;
        if (searchFor == ICSearchConstants.TYPE || searchFor == ICSearchConstants.CLASS || searchFor == ICSearchConstants.STRUCT || searchFor == ICSearchConstants.ENUM || searchFor == ICSearchConstants.UNION || searchFor == ICSearchConstants.CLASS_STRUCT || searchFor == ICSearchConstants.TYPEDEF) {
            pattern = CSearchPattern.createClassPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.METHOD || searchFor == ICSearchConstants.FUNCTION) {
            pattern = CSearchPattern.createMethodPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.FIELD || searchFor == ICSearchConstants.VAR) {
            pattern = CSearchPattern.createFieldPattern(patternString, searchFor, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.NAMESPACE) {
            pattern = CSearchPattern.createNamespacePattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.MACRO) {
            pattern = CSearchPattern.createMacroPattern(patternString, limitTo, matchMode, caseSensitive);
        } else if (searchFor == ICSearchConstants.INCLUDE) {
            pattern = CSearchPattern.createIncludePattern(patternString, limitTo, matchMode, caseSensitive);
        }
        return pattern;
    }

    private static CSearchPattern createIncludePattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo != ICSearchConstants.REFERENCES) {
            return null;
        }
        return new IncludePattern(patternString.toCharArray(), matchMode, limitTo, caseSensitive);
    }

    private static CSearchPattern createMacroPattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo != ICSearchConstants.DECLARATIONS && limitTo != ICSearchConstants.ALL_OCCURRENCES) {
            return null;
        }
        return new MacroDeclarationPattern(patternString.toCharArray(), matchMode, ICSearchConstants.DECLARATIONS, caseSensitive);
    }

    private static CSearchPattern createNamespacePattern(String patternString, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, ICSearchConstants.DEFINITIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createNamespacePattern(patternString, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            return orPattern;
        }
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((Reader)new StringReader(patternString), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        LinkedList list = CSearchPattern.scanForNames(scanner, null);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new NamespaceDeclarationPattern(name, (char[][])list.toArray((T[])qualifications), matchMode, limitTo, caseSensitive);
    }

    private static CSearchPattern createFieldPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createFieldPattern(patternString, searchFor, ICSearchConstants.DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((Reader)new StringReader(patternString), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        LinkedList list = CSearchPattern.scanForNames(scanner, null);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new FieldDeclarationPattern(name, (char[][])list.toArray((T[])qualifications), matchMode, searchFor, limitTo, caseSensitive);
    }

    private static CSearchPattern createMethodPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createMethodPattern(patternString, searchFor, ICSearchConstants.DEFINITIONS, matchMode, caseSensitive));
            return orPattern;
        }
        int index = patternString.indexOf(40);
        String paramString = index == -1 ? "" : patternString.substring(index);
        String nameString = index == -1 ? patternString : patternString.substring(0, index);
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((Reader)new StringReader(nameString), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        LinkedList names = CSearchPattern.scanForNames(scanner, null);
        LinkedList params = CSearchPattern.scanForParameters(paramString);
        char[] name = (char[])names.removeLast();
        char[][] qualifications = new char[][]{};
        qualifications = (char[][])names.toArray((T[])qualifications);
        char[][] parameters = new char[][]{};
        parameters = (char[][])params.toArray((T[])parameters);
        return new MethodDeclarationPattern(name, qualifications, parameters, matchMode, searchFor, limitTo, caseSensitive);
    }

    private static CSearchPattern createClassPattern(String patternString, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, int matchMode, boolean caseSensitive) {
        if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, ICSearchConstants.DECLARATIONS, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, searchFor, ICSearchConstants.REFERENCES, matchMode, caseSensitive));
            return orPattern;
        }
        if (searchFor == ICSearchConstants.CLASS_STRUCT) {
            OrPattern orPattern = new OrPattern();
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, ICSearchConstants.CLASS, limitTo, matchMode, caseSensitive));
            orPattern.addPattern(CSearchPattern.createClassPattern(patternString, ICSearchConstants.STRUCT, limitTo, matchMode, caseSensitive));
            return orPattern;
        }
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((Reader)new StringReader(patternString), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        IToken token = null;
        try {
            token = scanner.nextToken();
        }
        catch (EndOfFile endOfFile) {
        }
        catch (ScannerException scannerException) {}
        if (token != null) {
            boolean nullifyToken = true;
            if (token.getType() == 65) {
                searchFor = ICSearchConstants.CLASS;
            } else if (token.getType() == 109) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (token.getType() == 119) {
                searchFor = ICSearchConstants.UNION;
            } else if (token.getType() == 77) {
                searchFor = ICSearchConstants.ENUM;
            } else if (token.getType() == 116) {
                searchFor = ICSearchConstants.TYPEDEF;
            } else {
                nullifyToken = false;
            }
            if (nullifyToken) {
                token = null;
            }
        }
        LinkedList list = CSearchPattern.scanForNames(scanner, token);
        char[] name = (char[])list.removeLast();
        char[][] qualifications = new char[][]{};
        return new ClassDeclarationPattern(name, (char[][])list.toArray((T[])qualifications), searchFor, limitTo, matchMode, caseSensitive);
    }

    private static LinkedList scanForParameters(String paramString) {
        LinkedList<char[]> list = new LinkedList<char[]>();
        if (paramString == null || paramString.equals("")) {
            return list;
        }
        String functionString = "void f " + paramString + ";";
        IScanner scanner = null;
        try {
            scanner = ParserFactory.createScanner((Reader)new StringReader(functionString), (String)"TEXT", (IScannerInfo)new ScannerInfo(), (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (ISourceElementRequestor)callback, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        IQuickParseCallback callback = ParserFactory.createQuickParseCallback();
        IParser parser = null;
        try {
            parser = ParserFactory.createParser(scanner, (ISourceElementRequestor)callback, (ParserMode)ParserMode.QUICK_PARSE, (ParserLanguage)ParserLanguage.CPP, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryException parserFactoryException) {}
        if (parser.parse()) {
            IASTCompilationUnit compUnit = callback.getCompilationUnit();
            Iterator declarations = null;
            try {
                declarations = compUnit.getDeclarations();
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {}
            if (declarations == null || !declarations.hasNext()) {
                return null;
            }
            IASTFunction function = (IASTFunction)declarations.next();
            Iterator parameters = function.getParameters();
            char[] param = null;
            while (parameters.hasNext()) {
                param = CSearchPattern.getParamString((IASTParameterDeclaration)parameters.next());
                list.add(param);
            }
        }
        return list;
    }

    public static char[] getParamString(IASTParameterDeclaration param) {
        if (param == null) {
            return null;
        }
        String signature = "";
        IASTTypeSpecifier typeSpec = param.getTypeSpecifier();
        if (typeSpec instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simple = (IASTSimpleTypeSpecifier)typeSpec;
            signature = String.valueOf(signature) + simple.getTypename();
        } else if (typeSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elaborated = (IASTElaboratedTypeSpecifier)typeSpec;
            if (elaborated.getClassKind() == ASTClassKind.CLASS) {
                signature = String.valueOf(signature) + "class ";
            } else if (elaborated.getClassKind() == ASTClassKind.ENUM) {
                signature = String.valueOf(signature) + "enum ";
            } else if (elaborated.getClassKind() == ASTClassKind.STRUCT) {
                signature = String.valueOf(signature) + "struct ";
            } else if (elaborated.getClassKind() == ASTClassKind.UNION) {
                signature = String.valueOf(signature) + "union";
            }
            signature = String.valueOf(signature) + elaborated.getName();
        } else if (typeSpec instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpec = (IASTClassSpecifier)typeSpec;
            signature = String.valueOf(signature) + classSpec.getName();
        } else if (typeSpec instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumSpec = (IASTEnumerationSpecifier)typeSpec;
            signature = String.valueOf(signature) + enumSpec.getName();
        }
        signature = String.valueOf(signature) + " ";
        if (param.isConst()) {
            signature = String.valueOf(signature) + "const ";
        }
        if (param.isVolatile()) {
            signature = String.valueOf(signature) + "volatile ";
        }
        Iterator ptrs = param.getPointerOperators();
        while (ptrs.hasNext()) {
            ASTPointerOperator ptrOp = (ASTPointerOperator)ptrs.next();
            if (ptrOp == ASTPointerOperator.POINTER) {
                signature = String.valueOf(signature) + " * ";
                continue;
            }
            if (ptrOp == ASTPointerOperator.REFERENCE) {
                signature = String.valueOf(signature) + " & ";
                continue;
            }
            if (ptrOp == ASTPointerOperator.CONST_POINTER) {
                signature = String.valueOf(signature) + " const * ";
                continue;
            }
            if (ptrOp != ASTPointerOperator.VOLATILE_POINTER) continue;
            signature = String.valueOf(signature) + " volatile * ";
        }
        Iterator arrayModifiers = param.getArrayModifiers();
        while (arrayModifiers.hasNext()) {
            arrayModifiers.next();
            signature = String.valueOf(signature) + " [] ";
        }
        return signature.toCharArray();
    }

    private static LinkedList scanForNames(IScanner scanner, IToken unusedToken) {
        LinkedList<char[]> list = new LinkedList<char[]>();
        String name = new String("");
        try {
            IToken token = unusedToken != null ? unusedToken : scanner.nextToken();
            IToken prev = null;
            scanner.setThrowExceptionOnBadCharacterRead(true);
            boolean encounteredWild = false;
            boolean lastTokenWasOperator = false;
            block9: while (true) {
                switch (token.getType()) {
                    case 3: {
                        list.addLast(name.toCharArray());
                        name = new String("");
                        lastTokenWasOperator = false;
                        break;
                    }
                    case 95: {
                        name = String.valueOf(name) + token.getImage() + " ";
                        lastTokenWasOperator = true;
                        break;
                    }
                    default: {
                        if (token.getType() == 23 || token.getType() == 7) {
                            encounteredWild = true;
                        } else if (!encounteredWild && !lastTokenWasOperator && name.length() > 0 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && prev.getType() != 10 && token.getType() != 11 && token.getType() != 46) {
                            name = String.valueOf(name) + " ";
                        } else {
                            encounteredWild = false;
                        }
                        name = String.valueOf(name) + token.getImage();
                        lastTokenWasOperator = false;
                    }
                }
                prev = token;
                token = null;
                while (true) {
                    if (token != null) continue block9;
                    try {
                        token = scanner.nextToken();
                    }
                    catch (ScannerException e) {
                        if (e.getProblem().getID() != 0x1000001) continue;
                        if (!encounteredWild && !lastTokenWasOperator) {
                            name = String.valueOf(name) + " ";
                        }
                        name = String.valueOf(name) + "\\";
                        encounteredWild = true;
                        lastTokenWasOperator = false;
                        prev = null;
                    }
                }
                break;
            }
        }
        catch (EndOfFile endOfFile) {
            list.addLast(name.toCharArray());
        }
        catch (ScannerException scannerException) {}
        return list;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this._matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this._caseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this._caseSensitive);
                }
                case 2: {
                    if (!this._caseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this._caseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchQualifications(char[][] qualifications, char[][] candidate) {
        int root;
        int candidateLength;
        int qualLength = qualifications != null ? qualifications.length : 0;
        int n = candidateLength = candidate != null ? candidate.length : 0;
        if (qualLength == 0) {
            return true;
        }
        int n2 = root = qualifications[0].length == 0 ? 1 : 0;
        if (root == 1 && candidateLength != qualLength - 1 || root == 0 && candidateLength < qualLength) {
            return false;
        }
        int i = 1;
        while (i <= qualLength - root) {
            if (!this.matchesName(qualifications[qualLength - i], candidate[candidateLength - i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findIndexMatches(IIndex index, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
        try {
            ((IndexInput)input).open();
            this.findIndexMatches(input, requestor, detailLevel, progressMonitor, scope);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ((IndexInput)input).close();
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        char[] prefix = this.indexEntryPrefix();
        if (prefix == null) {
            return;
        }
        IEntryResult[] entries = input.queryEntriesPrefixedBy(prefix);
        if (entries == null) {
            return;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IEntryResult entry = entries[i];
            this.resetIndexInfo();
            this.decodeIndexEntry(entry);
            if (this.matchIndexEntry()) {
                this.feedIndexRequestor(requestor, detailLevel, entry.getFileReferences(), input, scope);
            }
            ++i;
        }
    }

    public abstract void feedIndexRequestor(IIndexSearchRequestor var1, int var2, int[] var3, IndexInput var4, ICSearchScope var5) throws IOException;

    protected abstract void resetIndexInfo();

    protected abstract void decodeIndexEntry(IEntryResult var1);

    public abstract char[] indexEntryPrefix();

    protected abstract boolean matchIndexEntry();

    public abstract int matchLevel(ISourceElementCallbackDelegate var1, ICSearchConstants.LimitTo var2);

    protected static class Requestor
    extends NullSourceElementRequestor {
        public Requestor(ParserMode mode) {
            super(mode);
        }

        public boolean acceptProblem(IProblem problem) {
            if (problem.getID() == 0x1000001) {
                return false;
            }
            return super.acceptProblem(problem);
        }
    }
}

